/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.integration.nei.GuiMultiblockHandler;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockHandler
extends TemplateRecipeHandler {
    public static final int CANDIDATE_SLOTS_X = 150;
    public static final int CANDIDATE_SLOTS_Y = 20;
    public static final int CANDIDATE_IN_COlUMN = 6;
    protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
    protected final List<PositionedStack> positionedIngredients = new ArrayList<PositionedStack>();
    protected int lastRecipeHeight;
    protected RecipeCacher recipeCacher = new RecipeCacher();
    protected GuiMultiblockHandler guiHandler;
    protected IConstructable[] currentMultiblocks;
    protected int oldRecipe;

    public MultiblockHandler(GuiMultiblockHandler guiHandler) {
        this.guiHandler = guiHandler;
        guiHandler.setOnIngredientChanged(this::resetPositionedIngredients);
        guiHandler.setOnCandidateChanged(this::setResults);
    }

    @NotNull
    public abstract ItemStack getConstructableStack(IConstructable var1);

    @NotNull
    protected abstract ObjectSet<IConstructable> tryLoadingMultiblocks(ItemStack var1);

    protected abstract boolean isPotentialCandidate(ItemStack var1);

    public void loadCraftingRecipes(ItemStack result) {
        this.loadRecipes(result);
        super.loadCraftingRecipes(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.loadRecipes(ingredient);
        super.loadUsageRecipes(ingredient);
    }

    private void loadRecipes(ItemStack stack) {
        this.currentMultiblocks = null;
        this.oldRecipe = -1;
        if (!this.isPotentialCandidate(stack)) {
            return;
        }
        ObjectSet<IConstructable> multiblocks = this.tryLoadingMultiblocks(stack);
        if (multiblocks.isEmpty()) {
            return;
        }
        this.currentMultiblocks = (IConstructable[])multiblocks.toArray((Object[])new IConstructable[0]);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        if (this.currentMultiblocks == null) {
            return;
        }
        if (this.oldRecipe != recipe) {
            this.oldRecipe = recipe;
            IConstructable multi = this.currentMultiblocks[recipe];
            this.guiHandler.loadMultiblock(multi, this.getConstructableStack(multi));
        }
        this.guiHandler.drawMultiblock();
        if (this.lastRecipeHeight != RecipeCatalysts.getHeight()) {
            this.resetPositionedIngredients(this.ingredients);
            this.lastRecipeHeight = RecipeCatalysts.getHeight();
        }
    }

    public int numRecipes() {
        return this.currentMultiblocks == null ? 0 : this.currentMultiblocks.length;
    }

    public String getGuiTexture() {
        return "blockrenderer6343:textures/void.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.structure");
    }

    protected GuiMultiblockHandler getGuiHandler() {
        return this.guiHandler;
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return Collections.emptyList();
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return this.arecipes.isEmpty() ? Collections.emptyList() : ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(0)).getOtherStacks();
    }

    public void resetPositionedIngredients(List<ItemStack> ingredients) {
        this.ingredients = ingredients;
        this.positionedIngredients.clear();
        int rowCount = RecipeCatalysts.getRowCount((int)RecipeCatalysts.getHeight(), (int)ingredients.size());
        for (int index = 0; index < ingredients.size(); ++index) {
            ItemStack catalyst = ingredients.get(index);
            int column = index / rowCount;
            int row = index % rowCount;
            this.positionedIngredients.add(new PositionedStack((Object)catalyst, -column * 16, row * 16));
        }
        Map catalystMap = RecipeCatalysts.getPositionedRecipeCatalystMap();
        catalystMap.put(this.getOverlayIdentifier(), this.positionedIngredients);
    }

    public void setResults(List<List<ItemStack>> results) {
        this.arecipes.clear();
        this.recipeCacher.setResults(results);
        this.arecipes.add(this.recipeCacher);
    }

    public class RecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> positionedResults;

        public RecipeCacher() {
            super((TemplateRecipeHandler)MultiblockHandler.this);
            this.positionedResults = new ArrayList<PositionedStack>();
        }

        public void setResults(List<List<ItemStack>> results) {
            this.positionedResults.clear();
            int columnCount = results.size() / 6 + 1;
            int realCandidateInColumn = results.size() % columnCount == 0 ? results.size() / columnCount : results.size() / columnCount + 1;
            for (int i = 0; i < results.size(); ++i) {
                PositionedStack result = new PositionedStack(results.get(i), 150 - (columnCount - 1) * 18 + i / realCandidateInColumn * 18, 20 + i % realCandidateInColumn * 18);
                result.generatePermutations();
                this.positionedResults.add(result);
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(MultiblockHandler.this.cycleticks / 20, this.positionedResults);
        }
    }
}

