/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.utils.XorShift128Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BlockSpring
extends Block {
    public static final XorShift128Random rand = new XorShift128Random();

    public BlockSpring() {
        super(Material.field_151576_e);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(field_149769_e);
        this.func_149649_H();
        this.func_149675_a(true);
        this.func_149647_a(BCCreativeTab.get("main"));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumSpring type : EnumSpring.VALUES) {
            list.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.assertSpring(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        world.func_147464_a(x, y, z, (Block)this, EnumSpring.fromMeta((int)meta).tickRate);
    }

    private void assertSpring(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        EnumSpring spring = EnumSpring.fromMeta(meta);
        world.func_147464_a(x, y, z, (Block)this, spring.tickRate);
        if (!spring.canGen || spring.liquidBlock == null) {
            return;
        }
        if (!world.func_147437_c(x, y + 1, z)) {
            return;
        }
        if (spring.chance != -1 && rand.nextInt(spring.chance) != 0) {
            return;
        }
        world.func_147449_b(x, y + 1, z, spring.liquidBlock);
    }

    public boolean func_149698_L() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("bedrock");
    }

    public static enum EnumSpring {
        WATER(5, -1, Blocks.field_150355_j),
        OIL(6000, 8, null);

        public static final EnumSpring[] VALUES;
        public final int tickRate;
        public final int chance;
        public Block liquidBlock;
        public boolean canGen = true;

        private EnumSpring(int tickRate, int chance, Block liquidBlock) {
            this.tickRate = tickRate;
            this.chance = chance;
            this.liquidBlock = liquidBlock;
        }

        public static EnumSpring fromMeta(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                return WATER;
            }
            return VALUES[meta];
        }

        static {
            VALUES = EnumSpring.values();
        }
    }
}

