/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketEntityUpdate;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.network.PacketGuiWidget;
import buildcraft.core.lib.network.PacketNBT;
import buildcraft.core.lib.network.PacketSlotChange;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.TByteIntMap;
import gnu.trove.map.hash.TByteIntHashMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@ChannelHandler.Sharable
public final class ChannelHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    public static final int CLIENT_ONLY = 1;
    public static final int SERVER_ONLY = 2;
    public static final int BOTH_SIDES = 3;
    public static final Marker SUSPICIOUS_PACKETS = MarkerManager.getMarker((String)"SuspiciousPackets");
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = new AttributeKey("bc:inboundpacket");
    private TByteObjectHashMap<Class<? extends Packet>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends Packet>> types = new TObjectByteHashMap();
    private TByteIntMap sides = new TByteIntHashMap();
    private int maxDiscriminator;

    public ChannelHandler() {
        this.addDiscriminator(0, PacketTileUpdate.class, 1);
        this.addDiscriminator(1, PacketTileState.class, 1);
        this.addDiscriminator(2, PacketNBT.class);
        this.addDiscriminator(3, PacketSlotChange.class);
        this.addDiscriminator(4, PacketGuiReturn.class);
        this.addDiscriminator(5, PacketGuiWidget.class);
        this.addDiscriminator(7, PacketCommand.class);
        this.addDiscriminator(8, PacketEntityUpdate.class, 1);
        this.maxDiscriminator = 9;
    }

    protected void logForgedPackets(EntityPlayer player, String packetType, ByteBuf rawPacket) {
        BCLog.logger.info(SUSPICIOUS_PACKETS, "Player {} tried to send packet of type {} to invalid side {}. This could be a false warning due to custom mods/addon, or it could be an legit attempt at hacking!", new Object[]{player.func_146103_bH(), player instanceof EntityPlayerMP ? Side.SERVER : Side.CLIENT, packetType});
    }

    public byte getDiscriminator(Class<? extends Packet> clazz) {
        return this.types.get(clazz);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> type) {
        return this.addDiscriminator(discriminator, type, 3);
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> type, int handlingSide) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        this.sides.put((byte)discriminator, handlingSide);
        return this;
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        msg.writeData(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        int expectedSide;
        this.testMessageValidity(msg);
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class clazz = (Class)this.discriminators.get(discriminator);
        if (clazz == null) {
            throw new NullPointerException("Undefined message for discriminator " + discriminator + " in channel " + msg.channel());
        }
        int n = expectedSide = ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get() == Side.CLIENT ? 1 : 2;
        if ((expectedSide & this.sides.get(discriminator)) != expectedSide) {
            INetHandler handler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(handler);
            this.logForgedPackets(player, clazz.getSimpleName(), payload.slice());
        } else {
            Packet newMsg = (Packet)clazz.newInstance();
            ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
            newMsg.readData(payload.slice());
            out.add(newMsg);
        }
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"BC ChannelHandler exception caught", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    public void registerPacketType(Class<? extends Packet> packetType) {
        this.addDiscriminator(this.maxDiscriminator++, packetType);
    }

    public void registerPacketType(Class<? extends Packet> packetType, int handlingSide) {
        this.addDiscriminator(this.maxDiscriminator++, packetType);
    }
}

