/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.stack;

import com.creativemd.creativecore.common.utils.stack.IStackLoader;
import com.creativemd.creativecore.common.utils.stack.StackInfo;
import com.creativemd.creativecore.common.utils.stack.StackInfoBlock;
import com.creativemd.creativecore.common.utils.stack.StackInfoItem;
import com.creativemd.creativecore.common.utils.string.StringUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StackInfoItemStack
extends StackInfo
implements IStackLoader {
    public ItemStack stack;
    public boolean needNBT;

    public StackInfoItemStack(ItemStack stack, boolean needNBT, int stackSize) {
        super(stackSize);
        this.stack = stack;
        this.needNBT = needNBT;
    }

    public StackInfoItemStack(ItemStack stack, int stackSize) {
        this(stack, stack.field_77990_d != null, stackSize);
    }

    public StackInfoItemStack(ItemStack stack) {
        this(stack, stack.field_77994_a);
    }

    @Override
    public StackInfo getStackInfo(Object item) {
        if (item instanceof ItemStack) {
            if (((ItemStack)item).func_77960_j() == Short.MAX_VALUE) {
                if (((ItemStack)item).func_77973_b() instanceof ItemBlock) {
                    return new StackInfoBlock(Block.func_149634_a((Item)((ItemStack)item).func_77973_b()));
                }
                return new StackInfoItem(((ItemStack)item).func_77973_b());
            }
            return new StackInfoItemStack((ItemStack)item);
        }
        return null;
    }

    @Override
    public StackInfo getStackInfoFromString(String input) {
        Object[] objects = StringUtils.StringToObjects(input);
        if (objects.length == 2 && objects[0] instanceof Item && objects[1] instanceof Integer) {
            return new StackInfoItemStack(new ItemStack((Item)objects[0], 1, ((Integer)objects[1]).intValue()));
        }
        if (objects.length == 3 && objects[0] instanceof Item && objects[1] instanceof Integer) {
            StackInfoItemStack result = new StackInfoItemStack(new ItemStack((Item)objects[0], 1, ((Integer)objects[1]).intValue()));
            result.needNBT = true;
            if (objects[2] instanceof NBTTagCompound) {
                result.stack.field_77990_d = (NBTTagCompound)objects[2];
            }
            return result;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.needNBT) {
            if (this.stack.field_77990_d == null) {
                return StringUtils.ObjectsToString(this.stack.func_77973_b(), this.stack.func_77960_j(), true);
            }
            return StringUtils.ObjectsToString(this.stack.func_77973_b(), this.stack.func_77960_j(), this.stack.field_77990_d);
        }
        return StringUtils.ObjectsToString(this.stack.func_77973_b(), this.stack.func_77960_j());
    }

    @Override
    protected boolean isStackInstanceIgnoreSize(ItemStack stack) {
        if (stack.func_77973_b() != this.stack.func_77973_b()) {
            return false;
        }
        if (stack.func_77960_j() != this.stack.func_77960_j()) {
            return false;
        }
        if (this.needNBT) {
            if (stack.field_77990_d == this.stack.field_77990_d) {
                return true;
            }
            if (stack.field_77990_d != null && this.stack.field_77990_d != null) {
                return stack.field_77990_d.equals((Object)this.stack.field_77990_d);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isInstanceIgnoreSize(StackInfo info) {
        if (info instanceof StackInfoItemStack) {
            if (((StackInfoItemStack)info).stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (((StackInfoItemStack)info).stack.func_77960_j() != this.stack.func_77960_j()) {
                return false;
            }
            if (((StackInfoItemStack)info).needNBT || this.needNBT) {
                if (((StackInfoItemStack)info).stack.field_77990_d == null && this.stack.field_77990_d == null) {
                    return true;
                }
                if (((StackInfoItemStack)info).stack.field_77990_d == null || this.stack.field_77990_d == null) {
                    return false;
                }
                return ((StackInfoItemStack)info).stack.field_77990_d.equals((Object)this.stack.field_77990_d);
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItemStack(int stacksize) {
        ItemStack stack = new ItemStack(this.stack.func_77973_b(), stacksize, this.stack.func_77960_j());
        if (this.needNBT) {
            stack.field_77990_d = (NBTTagCompound)this.stack.field_77990_d.func_74737_b();
        }
        return stack;
    }

    @Override
    public boolean equalsIgnoreSize(Object object) {
        return object instanceof StackInfoItemStack && ((StackInfoItemStack)object).isInstanceIgnoreSize(this.stack);
    }

    @Override
    public StackInfo copy() {
        return new StackInfoItemStack(this.stack.func_77946_l(), this.needNBT, this.stackSize);
    }

    @Override
    public String toTitle() {
        return this.stack.func_82833_r();
    }
}

