/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.renderers.tile;

import java.util.Random;
import makeo.gadomancy.client.models.ModelInfusionClawPart;
import makeo.gadomancy.client.models.ModelWandPart;
import makeo.gadomancy.common.blocks.tiles.TileInfusionClaw;
import makeo.gadomancy.common.utils.Injector;
import makeo.gadomancy.common.utils.SimpleResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.entity.RenderPrimalOrb;
import thaumcraft.client.renderers.item.ItemWandRenderer;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.projectile.EntityPrimalOrb;
import thaumcraft.common.items.wands.ItemWandCasting;

public class RenderTileInfusionClaw
extends TileEntitySpecialRenderer {
    private static final ResourceLocation RESOURCE = new SimpleResourceLocation("models/infusion_claw.png");
    private static final ModelInfusionClawPart[] MODELS;
    private static final Random RANDOM;
    private static final ItemWandRenderer WAND_RENDERER;
    private static final ItemWandRenderer STAFF_RENDERER;
    private static final RenderPrimalOrb RENDER_PRIMAL_ORB;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        this.render((TileInfusionClaw)tile, x, y, z, partialTicks);
    }

    private void render(TileInfusionClaw tile, double x, double y, double z, float partialTicks) {
        float ticks = (float)Minecraft.func_71410_x().field_71451_h.field_70173_aa + partialTicks;
        float elapsed = ticks - tile.lastRenderTick;
        tile.lastRenderTick = ticks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.renderPart(tile, elapsed, ticks);
        this.renderPrimalOrb(tile, elapsed);
        GL11.glPopMatrix();
    }

    private void renderPart(TileInfusionClaw tile, float elapsed, float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        World world = tile.func_145831_w();
        this.func_147499_a(RESOURCE);
        this.renderSides(tile, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, elapsed);
        this.renderCircle(tile, elapsed);
        this.renderWand(tile.func_70301_a(0), ticks);
        GL11.glPopMatrix();
    }

    private void renderCircle(TileInfusionClaw tile, float elapsed) {
        GL11.glPushMatrix();
        float speed = (float)Math.pow(1.1, Math.abs(tile.animationStates[9]));
        if (speed > 50.0f) {
            speed = 50.0f;
        }
        if (tile.animationStates[9] > 0.0f) {
            tile.animationStates[9] = (float)((double)tile.animationStates[9] + 0.5 * (double)elapsed);
            if (tile.animationStates[9] > 100.0f) {
                tile.animationStates[9] = -tile.animationStates[9];
                ItemStack wandStack = tile.func_70301_a(0);
                if (wandStack != null) {
                    tile.animationStates[11] = ((ItemWandCasting)wandStack.func_77973_b()).isStaff(wandStack) ? 0.5f : 0.1f;
                }
            }
        } else if (tile.animationStates[9] < 0.0f) {
            tile.animationStates[9] = (float)((double)tile.animationStates[9] + (double)elapsed * 0.5);
            if (tile.animationStates[9] > 0.0f) {
                tile.animationStates[9] = 0.0f;
            }
        }
        for (int i = 0; i < 4; ++i) {
            GL11.glPushMatrix();
            tile.animationStates[10] = (float)((double)tile.animationStates[10] + (double)speed * ((double)elapsed * 0.001 * Math.PI));
            float angle = (float)((double)tile.animationStates[10] + (double)i * 0.5 * Math.PI);
            float x = (float)Math.sin(angle);
            float y = (float)Math.cos(angle);
            float radius = 0.25f;
            GL11.glTranslated((double)0.0, (double)(0.0625 * Math.sin((double)angle / 1.4) + 0.0625), (double)0.0);
            GL11.glTranslated((double)(radius * x), (double)-0.27, (double)(radius * y));
            GL11.glRotated((double)45.0, (double)Math.cos(angle), (double)0.0, (double)(-Math.sin(angle)));
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            this.renderPart(i);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderWand(ItemStack wandStack, float ticks) {
        GL11.glRotatef((float)(ticks / 3.0f / 20.0f * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderTopPart();
        if (wandStack != null && wandStack.field_77994_a > 0) {
            GL11.glPushMatrix();
            ItemWandCasting item = (ItemWandCasting)ConfigItems.itemWandCasting;
            ItemStack wandFocusStack = wandStack.func_77946_l();
            item.setFocus(wandFocusStack, new ItemStack(ConfigItems.itemFocusPrimal));
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)(MathHelper.func_76126_a((float)(ticks / 3.0f / 10.0f)) * 0.08f + 0.08f), (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-1.4924f, (float)0.0f);
            if (item.isStaff(wandFocusStack)) {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                STAFF_RENDERER.renderItem(IItemRenderer.ItemRenderType.ENTITY, wandFocusStack, new Object[0]);
            } else {
                WAND_RENDERER.renderItem(IItemRenderer.ItemRenderType.ENTITY, wandFocusStack, new Object[0]);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderTopPart() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.453125f, (float)0.0f);
        GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
        this.renderPart(4);
        GL11.glPopMatrix();
    }

    private void renderPrimalOrb(TileInfusionClaw tile, float elapsed) {
        if (tile.animationStates[11] > 0.0f) {
            tile.animationStates[11] = tile.animationStates[11] + elapsed / 70.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)(0.75f - tile.animationStates[11]), (float)0.5f);
            GL11.glScalef((float)0.35f, (float)0.35f, (float)0.35f);
            EntityPrimalOrb orb = new EntityPrimalOrb(tile.func_145831_w(), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g, true);
            orb.field_70173_aa = Minecraft.func_71410_x().field_71451_h.field_70173_aa;
            RENDER_PRIMAL_ORB.renderEntityAt((Entity)orb, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            if (0.75f - tile.animationStates[11] < -0.5f) {
                tile.animationStates[11] = 0.0f;
            }
        }
    }

    private void createSideZap(TileInfusionClaw tile) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.createZap(tile, 0.5f + 0.5f * (float)dir.offsetX, 0.6f, 0.5f + 0.5f * (float)dir.offsetZ, 0.5f + (float)dir.offsetX * 0.2f, 0.2f, 0.5f + (float)dir.offsetZ * 0.2f);
            this.playZapSound(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }

    private void createZap(TileEntity tile, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Thaumcraft.proxy.nodeBolt(Thaumcraft.proxy.getClientWorld(), (float)tile.field_145851_c + startX, (float)tile.field_145848_d + startY, (float)tile.field_145849_e + startZ, (float)tile.field_145851_c + endX, (float)tile.field_145848_d + endY, (float)tile.field_145849_e + endZ);
    }

    private void playZapSound(float x, float y, float z) {
        Thaumcraft.proxy.getClientWorld().func_72980_b((double)x, (double)y, (double)z, "thaumcraft:zap", 0.1f, 1.0f + Thaumcraft.proxy.getClientWorld().field_73012_v.nextFloat() * 0.2f, false);
    }

    private void renderSides(TileInfusionClaw tile, World world, int x, int y, int z, float elapsed) {
        GL11.glPushMatrix();
        float speed = (float)Math.pow(1.1, Math.abs(tile.animationStates[8]));
        if (tile.animationStates[8] > 0.0f) {
            tile.animationStates[8] = tile.animationStates[8] + elapsed;
            if (tile.animationStates[8] > 50.0f) {
                tile.animationStates[8] = -tile.animationStates[8];
                tile.animationStates[9] = 1.0f;
                this.createSideZap(tile);
            }
        } else if (tile.animationStates[8] < 0.0f) {
            tile.animationStates[8] = (float)((double)tile.animationStates[8] + (double)elapsed * 0.5);
            if (tile.animationStates[8] > 0.0f) {
                tile.animationStates[8] = 0.0f;
            }
        }
        for (int i = 0; i < 4; ++i) {
            float heightMove = this.getNextMoveOffset(tile, i, speed, elapsed);
            float widthMove = this.getNextMoveOffset(tile, i + 4, speed, elapsed);
            ForgeDirection dir = ForgeDirection.getOrientation((int)(i + 2));
            boolean powered = world != null && world.func_72878_l(x + dir.offsetX, y, z + dir.offsetZ, dir.ordinal()) > 0;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)(-dir.offsetZ) * widthMove), (float)heightMove, (float)((float)(-dir.offsetX) * widthMove));
            GL11.glTranslated((double)(0.453125 * (double)dir.offsetX), (double)0.0, (double)(0.453125 * (double)dir.offsetZ));
            GL11.glRotatef((float)90.0f, (float)(-1 * dir.offsetZ), (float)0.0f, (float)dir.offsetX);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            this.renderRedstonePart(powered);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private float getNextMoveOffset(TileInfusionClaw tile, int id, float speed, float elapsed) {
        int n = id;
        tile.animationStates[n] = (float)((double)tile.animationStates[n] + RANDOM.nextDouble() * 2.0 * (double)elapsed * (double)speed);
        return (float)(0.0625 * Math.sin(tile.animationStates[id] / 30.0f));
    }

    private void renderRedstonePart(boolean powered) {
        this.renderPart(powered ? 6 : 5);
    }

    private void renderPart(int num) {
        MODELS[num].func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
    }

    static {
        RANDOM = new Random();
        WAND_RENDERER = new ItemWandRenderer();
        STAFF_RENDERER = new ItemWandRenderer();
        RENDER_PRIMAL_ORB = new RenderPrimalOrb();
        MODELS = new ModelInfusionClawPart[8];
        for (int i = 0; i < MODELS.length; ++i) {
            RenderTileInfusionClaw.MODELS[i] = new ModelInfusionClawPart(i);
        }
        new Injector(WAND_RENDERER).setField("model", (Object)new ModelWandPart(7, 4));
        new Injector(STAFF_RENDERER).setField("model", (Object)new ModelWandPart(7, 4));
        RENDER_PRIMAL_ORB.func_76976_a(RenderManager.field_78727_a);
    }
}

