/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.data;

import java.util.HashMap;
import java.util.Map;
import makeo.gadomancy.common.data.SyncDataHolder;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractData {
    private byte providerId;

    public final void markDirty() {
        AbstractDataProvider<? extends AbstractData> provider = Registry.getProvider(this.getProviderID());
        if (provider != null) {
            SyncDataHolder.markForUpdate(provider.getKey());
        }
    }

    public final void setProviderId(byte id) {
        this.providerId = id;
    }

    public final byte getProviderID() {
        return this.providerId;
    }

    public abstract boolean needsUpdate();

    public abstract void writeAllDataToPacket(NBTTagCompound var1);

    public abstract void writeToPacket(NBTTagCompound var1);

    public abstract void readRawFromPacket(NBTTagCompound var1);

    public abstract void handleIncomingData(AbstractData var1);

    public static abstract class ProviderAutoAllocate<T extends AbstractData>
    extends AbstractDataProvider<T> {
        public ProviderAutoAllocate(String key) {
            super(key, SyncDataHolder.allocateNewId());
        }
    }

    public static abstract class AbstractDataProvider<T extends AbstractData> {
        private String key;
        private byte providerId;

        protected AbstractDataProvider(String key, byte providerId) {
            this.key = key;
            this.providerId = providerId;
        }

        public abstract T provideNewInstance();

        public final String getKey() {
            return this.key;
        }

        public final byte getProviderId() {
            return this.providerId;
        }
    }

    public static class Registry {
        private static Map<Byte, AbstractDataProvider<? extends AbstractData>> registry = new HashMap<Byte, AbstractDataProvider<? extends AbstractData>>();

        public static void register(AbstractDataProvider<? extends AbstractData> provider) {
            registry.put(provider.getProviderId(), provider);
        }

        public static AbstractDataProvider<? extends AbstractData> getProvider(Byte id) {
            return registry.get(id);
        }
    }
}

