/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.schematics;

import galacticgreg.GalacticGreg;
import galacticgreg.schematics.SpaceSchematic;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;

public class SpaceSchematicHandler {
    File _mConfigFolderName;
    File _mSchematicsFolderName;
    private List<SpaceSchematic> _mSpaceSchematics;

    public SpaceSchematicHandler(File pConfigFolder) {
        this._mConfigFolderName = new File(String.format("%s/%s", pConfigFolder.toString(), "GalacticGreg"));
        this._mSchematicsFolderName = new File(String.format("%s/schematics", this._mConfigFolderName));
        this._mSpaceSchematics = new ArrayList<SpaceSchematic>();
        if (!this._mSchematicsFolderName.exists()) {
            this._mSchematicsFolderName.mkdirs();
        }
    }

    public SpaceSchematic getRandomSpaceSchematic() {
        int tRandomChance = GalacticGreg.GalacticRandom.nextInt(100);
        ArrayList<Integer> tRandomIDs = new ArrayList<Integer>();
        SpaceSchematic tChoosenSchematic = null;
        if (this._mSpaceSchematics == null) {
            return null;
        }
        if (this._mSpaceSchematics.isEmpty()) {
            return null;
        }
        if (this._mSpaceSchematics.size() == 1) {
            tChoosenSchematic = this._mSpaceSchematics.get(0);
            if (tChoosenSchematic.getRarity() < tRandomChance) {
                tChoosenSchematic = null;
            }
        } else {
            for (int i = 0; i < this._mSpaceSchematics.size(); ++i) {
                if (this._mSpaceSchematics.get(i).getRarity() < tRandomChance) continue;
                tRandomIDs.add(i);
            }
        }
        if (!tRandomIDs.isEmpty()) {
            int tRnd = GalacticGreg.GalacticRandom.nextInt(tRandomIDs.size());
            tChoosenSchematic = this._mSpaceSchematics.get((Integer)tRandomIDs.get(tRnd));
        }
        return tChoosenSchematic;
    }

    public boolean reloadSchematics(boolean pForceReload) {
        try {
            Collection structureFiles = FileUtils.listFiles((File)this._mSchematicsFolderName, (String[])new String[]{"xml"}, (boolean)false);
            ArrayList<SpaceSchematic> tNewSpaceSchematics = new ArrayList<SpaceSchematic>();
            int tErrorsFound = 0;
            if (structureFiles.isEmpty()) {
                return true;
            }
            for (File tSchematic : structureFiles) {
                try {
                    SpaceSchematic tSchematicObj = this.LoadSpaceSchematic(tSchematic);
                    if (tSchematicObj != null) {
                        tNewSpaceSchematics.add(tSchematicObj);
                        continue;
                    }
                    GalacticGreg.Logger.warn("Could not load Schematic %s. Please check the syntax", tSchematic);
                    ++tErrorsFound;
                }
                catch (Exception e) {
                    GalacticGreg.Logger.error("Error while loading Schematic %s", tSchematic);
                    e.printStackTrace();
                }
            }
            GalacticGreg.Logger.info("Successfully loaded %d Schematics", tNewSpaceSchematics.size());
            boolean tDoReplace = true;
            if (tErrorsFound > 0) {
                GalacticGreg.Logger.warn("Found %d errors while loading, not all schematics will be available", new Object[0]);
                if (pForceReload) {
                    GalacticGreg.Logger.info("Reload was forced, replacing currently active list with new one", new Object[0]);
                } else {
                    GalacticGreg.Logger.warn("Nothing was replaced. Fix any errors and reload again", new Object[0]);
                    tDoReplace = false;
                }
            }
            if (tDoReplace) {
                this._mSpaceSchematics = tNewSpaceSchematics;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean SaveSpaceStructure(SpaceSchematic pSchematic) {
        try {
            if (pSchematic.getName().isEmpty()) {
                return false;
            }
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{SpaceSchematic.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)pSchematic, (OutputStream)new FileOutputStream(String.format("%s/%s.xml", this._mSchematicsFolderName, pSchematic.getName()), false));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SpaceSchematic LoadSpaceSchematic(String pSchematicName) {
        return this.LoadSpaceSchematic(new File(String.format("%s/%s.xml", this._mSchematicsFolderName, pSchematicName)));
    }

    public SpaceSchematic LoadSpaceSchematic(File pName) {
        SpaceSchematic tSchematic = null;
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{SpaceSchematic.class});
            if (!pName.exists()) {
                GalacticGreg.Logger.error("SchematicFile %s could not be found", pName);
                return null;
            }
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            tSchematic = (SpaceSchematic)jaxUnmarsh.unmarshal(pName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tSchematic;
    }
}

