/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.MTEYOTTAHatch;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.client.GUI.GGUITextures;
import goodgenerator.loader.Loaders;
import goodgenerator.util.CharExchanger;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import tectech.TecTech;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;

public class MTEYottaFluidTank
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<MTEYottaFluidTank> multiDefinition = null;
    protected final ArrayList<MTEYOTTAHatch> mYottaHatch = new ArrayList();
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    public BigInteger mStorage = BigInteger.ZERO;
    public BigInteger mStorageCurrent = BigInteger.ZERO;
    public FluidStack mFluid = null;
    public FluidStack mLockedFluid = null;
    protected boolean isFluidLocked = false;
    protected int glassMeta;
    protected int maxCell;
    protected final String YOTTANK_BOTTOM = this.mName + "buttom";
    protected final String YOTTANK_MID = this.mName + "mid";
    protected final String YOTTANK_TOP = this.mName + "top";
    protected final NumberFormatMUI numberFormat = new NumberFormatMUI();
    private int workTickCounter = 0;
    public static final BigInteger MAX_INT_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected boolean voidExcessEnabled = false;
    protected Parameters.Group.ParameterIn tickRateSettings;
    private static final INameFunction<MTEYottaFluidTank> TICK_RATE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.YottaFluidTank.cfgi.0");
    private static final IStatusFunction<MTEYottaFluidTank> TICK_RATE_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 1.0, 0.0, 100.0, 100.0, new double[0]);
    private final FluidTankInfo[] tankInfoCache = new FluidTankInfo[1];
    private static final BigInteger[] storageWithCells = new BigInteger[10];

    @Override
    protected void parametersInstantiation_EM() {
        this.tickRateSettings = this.parametrization.getGroup(9, true).makeInParameter(1, 20.0, TICK_RATE_SETTING_NAME, TICK_RATE_STATUS);
    }

    public MTEYottaFluidTank(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTEYottaFluidTank(String name) {
        super(name);
    }

    public int getMeta() {
        return this.glassMeta;
    }

    public void setMeta(int meta) {
        this.glassMeta = meta;
    }

    public String getCap() {
        return this.mStorage.toString(10);
    }

    public String getStored() {
        return this.mStorageCurrent.toString(10);
    }

    public String getFluidName() {
        if (this.mFluid == null) {
            return StatCollector.func_74838_a((String)"scanner.info.YOTTank.empty");
        }
        return this.mFluid.getLocalizedName();
    }

    public String getLockedFluidName() {
        if (!this.isFluidLocked) {
            return StatCollector.func_74838_a((String)"scanner.info.YOTTank.none");
        }
        if (this.mLockedFluid == null) {
            return StatCollector.func_74838_a((String)"scanner.info.YOTTank.next");
        }
        return this.mLockedFluid.getLocalizedName();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        String tAmount = aNBT.func_74779_i("mStorage");
        String tAmountCurrent = aNBT.func_74779_i("mStorageCurrent");
        if (StringUtils.isEmpty((CharSequence)tAmount)) {
            tAmount = "0";
        }
        if (StringUtils.isEmpty((CharSequence)tAmountCurrent)) {
            tAmountCurrent = "0";
        }
        this.mStorage = new BigInteger(tAmount, 10);
        this.mStorageCurrent = new BigInteger(tAmountCurrent, 10);
        this.mFluid = FluidRegistry.getFluidStack((String)aNBT.func_74779_i("mFluidName"), (int)1);
        this.mLockedFluid = FluidRegistry.getFluidStack((String)aNBT.func_74779_i("mLockedFluidName"), (int)1);
        this.voidExcessEnabled = aNBT.func_74767_n("voidExcessEnabled");
        this.isFluidLocked = aNBT.func_74767_n("isFluidLocked");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("mStorage", this.mStorage.toString(10));
        aNBT.func_74778_a("mStorageCurrent", this.mStorageCurrent.toString(10));
        aNBT.func_74778_a("mFluidName", this.mFluid == null ? "" : this.mFluid.getFluid().getName());
        aNBT.func_74778_a("mLockedFluidName", this.mLockedFluid == null ? "" : this.mLockedFluid.getFluid().getName());
        aNBT.func_74757_a("voidExcessEnabled", this.voidExcessEnabled);
        aNBT.func_74757_a("isFluidLocked", this.isFluidLocked);
        super.saveNBTData(aNBT);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        this.mEUt = 0;
        this.mMaxProgresstime = 20;
        return SimpleCheckRecipeResult.ofSuccess("");
    }

    public boolean getIsVoidExcessEnabled() {
        return this.voidExcessEnabled;
    }

    public boolean reduceFluid(long amount) {
        BigInteger bigAmount = BigInteger.valueOf(amount);
        if (this.mStorageCurrent.compareTo(bigAmount) < 0) {
            return false;
        }
        this.mStorageCurrent = this.mStorageCurrent.subtract(bigAmount);
        return true;
    }

    public boolean addFluid(long amount, boolean doFill) {
        BigInteger bigAmount = BigInteger.valueOf(amount);
        BigInteger newTotal = this.mStorageCurrent.add(bigAmount);
        if (newTotal.compareTo(this.mStorage) > 0) {
            return false;
        }
        if (doFill) {
            this.mStorageCurrent = newTotal;
        }
        return true;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        boolean cacheNeedsRecreation;
        int tankCapacity;
        int fluidSize = this.mStorageCurrent.compareTo(MAX_INT_BIGINT) >= 0 ? Integer.MAX_VALUE : this.mStorageCurrent.intValue();
        int n = tankCapacity = this.mStorage.compareTo(MAX_INT_BIGINT) >= 0 ? Integer.MAX_VALUE : this.mStorage.intValue();
        if (this.tankInfoCache[0] == null || this.tankInfoCache[0].capacity != tankCapacity) {
            cacheNeedsRecreation = true;
        } else if (this.tankInfoCache[0].fluid == null) {
            cacheNeedsRecreation = this.mFluid != null;
        } else {
            boolean bl = cacheNeedsRecreation = !this.tankInfoCache[0].fluid.isFluidEqual(this.mFluid);
        }
        if (cacheNeedsRecreation) {
            FluidStack storedFluid = GTUtility.copyAmount(fluidSize, this.mFluid);
            this.tankInfoCache[0] = new FluidTankInfo(storedFluid, tankCapacity);
        } else if (this.mFluid != null) {
            this.tankInfoCache[0].fluid.amount = fluidSize;
        }
        return this.tankInfoCache;
    }

    @Override
    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mYottaHatch.clear();
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mStorage = BigInteger.ZERO;
        this.glassMeta = 0;
        this.maxCell = 0;
        if (!this.structureCheck_EM(this.YOTTANK_BOTTOM, 2, 0, 0)) {
            return false;
        }
        int cnt = 0;
        while (this.structureCheck_EM(this.YOTTANK_MID, 2, cnt + 1, 0)) {
            ++cnt;
        }
        if (cnt > 15 || cnt < 1) {
            return false;
        }
        if (!this.structureCheck_EM(this.YOTTANK_TOP, 2, cnt + 2, 0)) {
            return false;
        }
        if (this.maxCell + 3 <= this.glassMeta) {
            if (this.mStorage.compareTo(this.mStorageCurrent) < 0) {
                this.mStorageCurrent = this.mStorage;
            }
            if (this.mFluid == null) {
                this.mStorageCurrent = BigInteger.ZERO;
            }
            return true;
        }
        return false;
    }

    public IStructureDefinition<MTEYottaFluidTank> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.YOTTANK_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{"MM~MM", "MCCCM", "MCCCM", "MCCCM", "MMMMM"}, {"     ", " OOO ", " OOO ", " OOO ", "     "}})).addShape(this.YOTTANK_MID, StructureUtility.transpose((String[][])new String[][]{{"GGGGG", "GRRRG", "GRRRG", "GRRRG", "GGGGG"}})).addShape(this.YOTTANK_TOP, StructureUtility.transpose((String[][])new String[][]{{"FFFFF", "F   F", "F   F", "F   F", "FFFFF"}, {"CCCCC", "CIIIC", "CIIIC", "CIIIC", "CCCCC"}})).addElement('C', StructureUtility.ofBlock((Block)Loaders.yottaFluidTankCasing, (int)0)).addElement('G', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, MTEYottaFluidTank::setMeta, te -> (byte)te.getMeta()))).addElement('R', (IStructureElement)StructureUtility.ofChain(this.cells(10))).addElement('F', GTStructureUtility.ofFrame(Materials.Steel)).addElement('I', GTStructureUtility.buildHatchAdder(MTEYottaFluidTank.class).atLeast(HatchElement.InputHatch).casingIndex(1537).dot(1).buildAndChain(Loaders.yottaFluidTankCasing, 0)).addElement('M', GTStructureUtility.buildHatchAdder(MTEYottaFluidTank.class).atLeast(HatchElement.Maintenance).casingIndex(1537).dot(2).buildAndChain(Loaders.yottaFluidTankCasing, 0)).addElement('O', GTStructureUtility.buildHatchAdder(MTEYottaFluidTank.class).atLeast(HatchElement.OutputHatch).adder(MTEYottaFluidTank::addOutput).casingIndex(1537).dot(1).buildAndChain(Loaders.yottaFluidTankCasing, 0)).build();
        }
        return this.multiDefinition;
    }

    public List<IStructureElement<MTEYottaFluidTank>> cells(int num) {
        ArrayList<IStructureElement<MTEYottaFluidTank>> out = new ArrayList<IStructureElement<MTEYottaFluidTank>>();
        for (int i = 0; i < num; ++i) {
            int finalI = i;
            out.add((IStructureElement<MTEYottaFluidTank>)StructureUtility.onElementPass(x -> {
                x.mStorage = x.mStorage.add(this.calStorage(finalI));
                x.maxCell = Math.max(x.maxCell, finalI);
            }, (IStructureElement)StructureUtility.ofBlock((Block)Loaders.yottaFluidTankCell, (int)i)));
        }
        return out;
    }

    public final boolean addOutput(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((MTEHatchOutput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEYOTTAHatch) {
            if (!this.mYottaHatch.isEmpty()) {
                return false;
            }
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEYOTTAHatch)aMetaTileEntity).setTank(this);
            return this.mYottaHatch.add((MTEYOTTAHatch)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"scanner.info.YOTTank.1"), StatCollector.func_74838_a((String)(EnumChatFormatting.YELLOW + CharExchanger.formatNumber(this.getFluidName() + EnumChatFormatting.RESET))), StatCollector.func_74838_a((String)"scanner.info.YOTTank.0"), StatCollector.func_74838_a((String)(EnumChatFormatting.GREEN + CharExchanger.formatNumber(this.getCap()) + EnumChatFormatting.RESET + " L")), StatCollector.func_74838_a((String)"scanner.info.YOTTank.2"), StatCollector.func_74838_a((String)(EnumChatFormatting.GREEN + CharExchanger.formatNumber(this.getStored()) + EnumChatFormatting.RESET + " L (" + EnumChatFormatting.GREEN + this.getPercent() + "%" + EnumChatFormatting.RESET + ")")), StatCollector.func_74838_a((String)"scanner.info.YOTTank.3"), StatCollector.func_74838_a((String)(EnumChatFormatting.YELLOW + CharExchanger.formatNumber(this.getLockedFluidName()) + EnumChatFormatting.RESET))};
    }

    private String getPercent() {
        if (this.mStorage.signum() == 0) {
            return "0";
        }
        return this.mStorageCurrent.multiply(ONE_HUNDRED).divide(this.mStorage).toString();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Tank").addInfo("The max output speed is decided by the amount of stored liquid and the output hatch's capacity.").addInfo("The max fluid cell tier is limited by the glass tier.").addInfo("HV glass for T1, EV glass for T2, IV glass for T3. . .").addInfo("The max height of the cell blocks is 15.").beginVariableStructureBlock(5, 5, 1, 15, 5, 5, false).addController("Front of the second layer").addCasingInfoExactly("Steel Frame Box", 16, false).addCasingInfoRange("Glass (HV+)", 16, 240, true).addCasingInfoRange("Fluid Cell Block", 9, 135, true).addCasingInfoRange("YOTTank Casing", 25, 43, false).addInputHatch("Hint block with dot 1").addOutputHatch("Hint block with dot 3").toolTipFinisher(new String[0]);
        return tt;
    }

    public BigInteger calStorage(int meta) {
        return storageWithCells[meta];
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        super.onRunningTick(aStack);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            long tickRate = Math.min(100L, Math.max(1L, (long)this.tickRateSettings.get()));
            ++this.workTickCounter;
            if ((long)this.workTickCounter < tickRate) {
                return true;
            }
            this.workTickCounter = 0;
            ArrayList<FluidStack> tStore = this.getStoredFluids();
            for (FluidStack tFluid : tStore) {
                if (tFluid == null) continue;
                if (this.isFluidLocked) {
                    if (this.mLockedFluid != null) {
                        if (!tFluid.isFluidEqual(this.mLockedFluid)) {
                            continue;
                        }
                    } else {
                        this.mLockedFluid = tFluid.copy();
                        this.mLockedFluid.amount = 1;
                    }
                }
                if (this.mFluid != null && !tFluid.isFluidEqual(this.mFluid)) continue;
                if (this.mFluid == null) {
                    this.mFluid = tFluid.copy();
                    this.mFluid.amount = 1;
                }
                if (this.addFluid(tFluid.amount, true)) {
                    tFluid.amount = 0;
                    continue;
                }
                if (this.voidExcessEnabled) {
                    tFluid.amount = 0;
                } else {
                    BigInteger delta = this.mStorage.subtract(this.mStorageCurrent);
                    tFluid.amount -= delta.intValueExact();
                }
                this.mStorageCurrent = this.mStorage;
            }
            if (this.mStorageCurrent.compareTo(BigInteger.ZERO) <= 0) {
                this.mFluid = null;
            }
            if (this.mFluid != null) {
                int outputAmount = this.mStorageCurrent.divide(ONE_HUNDRED).min(MAX_INT_BIGINT).max(BigInteger.ONE).intValueExact();
                outputAmount = outputAmount != 1 ? (int)Math.min(Integer.MAX_VALUE, (long)outputAmount * tickRate) : Math.min(this.mStorageCurrent.intValueExact(), outputAmount * (int)tickRate);
                int originalOutputAmount = outputAmount;
                for (MTEHatch outputHatch : this.mOutputHatches) {
                    int remainingHatchSpace;
                    FluidStack fluidInHatch = outputHatch.mFluid;
                    if (fluidInHatch != null) {
                        if (!fluidInHatch.isFluidEqual(this.mFluid)) continue;
                        remainingHatchSpace = outputHatch.getCapacity() - fluidInHatch.amount;
                    } else {
                        remainingHatchSpace = outputHatch.getCapacity();
                    }
                    int amountToFillHatch = Math.min(remainingHatchSpace, outputAmount);
                    if (amountToFillHatch <= 0) continue;
                    FluidStack fillStack = this.mFluid.copy();
                    fillStack.amount = amountToFillHatch;
                    int transferredAmount = outputHatch.fill(fillStack, true);
                    outputAmount -= transferredAmount;
                }
                int totalDrainedAmount = originalOutputAmount - outputAmount;
                if (totalDrainedAmount > 0) {
                    this.mStorageCurrent = this.mStorageCurrent.subtract(BigInteger.valueOf(totalDrainedAmount));
                    if (this.mStorageCurrent.signum() < 0) {
                        throw new IllegalStateException("YOTTank drained beyond its fluid amount, indicating logic bug: " + this.mStorageCurrent);
                    }
                }
            }
        }
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.YOTTANK_BOTTOM, 2, 0, 0, stackSize, hintsOnly);
        int height = stackSize.field_77994_a;
        if (height > 15) {
            height = 15;
        }
        this.structureBuild_EM(this.YOTTANK_TOP, 2, height + 2, 0, stackSize, hintsOnly);
        while (height > 0) {
            this.structureBuild_EM(this.YOTTANK_MID, 2, height, 0, stackSize, hintsOnly);
            --height;
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack toolStack) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.voidExcessEnabled ^= true;
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(this.voidExcessEnabled ? "yottank.chat.voidExcessEnabled" : "yottank.chat.voidExcessDisabled", new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack toolStack) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            if (this.mLockedFluid == null) {
                if (this.mFluid != null) {
                    this.mLockedFluid = this.mFluid;
                    aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("yottank.chat.1", new Object[]{this.getFluidName()}));
                } else {
                    aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("yottank.chat.2", new Object[0]));
                }
                this.isFluidLocked = true;
            } else {
                this.mLockedFluid = null;
                this.isFluidLocked = false;
                aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("yottank.chat.0", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("YOTTank.hint", 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEYottaFluidTank(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1537), TextureFactory.of(textureFontOn), TextureFactory.builder().addIcon(textureFontOn_Glow).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1537), TextureFactory.of(textureFontOff), TextureFactory.builder().addIcon(textureFontOff_Glow).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1537)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = 0;
        built += this.survivialBuildPiece(this.YOTTANK_BOTTOM, stackSize, 2, 0, 0, elementBudget, env, false, true);
        int height = stackSize.field_77994_a;
        if (height > 15) {
            height = 15;
        }
        built += this.survivialBuildPiece(this.YOTTANK_TOP, stackSize, 2, height + 2, 0, elementBudget - built, env, false, true);
        while (height > 0) {
            built += this.survivialBuildPiece(this.YOTTANK_MID, stackSize, 2, height, 0, elementBudget - built, env, false, true);
            --height;
        }
        return built;
    }

    @Override
    protected boolean shouldDisplayCheckRecipeResult() {
        return false;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.YOTTank.0") + " " + this.numberFormat.format((Object)this.mStorage) + " L").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.BigIntegerSyncer(() -> this.mStorage, val -> {
            this.mStorage = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.YOTTank.1") + " " + this.getFluidName()).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.FluidStackSyncer(() -> this.mFluid, val -> {
            this.mFluid = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.YOTTank.2") + " " + this.numberFormat.format((Object)this.mStorageCurrent) + " L").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.BigIntegerSyncer(() -> this.mStorageCurrent, val -> {
            this.mStorageCurrent = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.YOTTank.3") + " " + this.getLockedFluidName()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.FluidStackSyncer(() -> this.mLockedFluid, val -> {
            this.mLockedFluid = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.isFluidLocked, val -> {
            this.isFluidLocked = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.voidExcessEnabled, val -> {
            this.voidExcessEnabled = val;
        }));
    }

    @Override
    protected ButtonWidget createSafeVoidButton() {
        return (ButtonWidget)new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            this.voidExcessEnabled = !this.voidExcessEnabled;
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_STANDARD_16x16);
            ret.add(this.voidExcessEnabled ? TecTechUITextures.OVERLAY_BUTTON_SAFE_VOID_ON : TecTechUITextures.OVERLAY_BUTTON_SAFE_VOID_OFF);
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, this.doesBindPlayerInventory() ? 132 : 156).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.YOTTank.button.void")).setTooltipShowUpDelay(5);
    }

    @Override
    protected ButtonWidget createPowerPassButton() {
        return (ButtonWidget)new ButtonWidget().setOnClick((clickData, widget) -> {
            TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
            boolean bl = this.isFluidLocked = !this.isFluidLocked;
            if (!widget.getContext().isClient()) {
                this.mLockedFluid = this.isFluidLocked ? this.mFluid : null;
            }
        }).setPlayClickSound(false).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(TecTechUITextures.BUTTON_STANDARD_16x16);
            ret.add(this.isFluidLocked ? GGUITextures.OVERLAY_BUTTON_LOCK_ON : GGUITextures.OVERLAY_BUTTON_LOCK_OFF);
            return ret.toArray(new IDrawable[0]);
        }).setPos(174, this.doesBindPlayerInventory() ? 116 : 140).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.YOTTank.button.locking")).setTooltipShowUpDelay(5);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    static {
        BigInteger baseStorage = BigInteger.valueOf(1000000L);
        BigInteger storageMultiplier = BigInteger.valueOf(100L);
        BigInteger currentStorage = baseStorage;
        for (int i = 0; i < 10; ++i) {
            MTEYottaFluidTank.storageWithCells[i] = currentStorage;
            currentStorage = currentStorage.multiply(storageMultiplier);
        }
    }
}

