/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;

public class TextureSet {
    private static final String aTextMatIconDir = "materialicons/";
    private static final String aTextVoidDir = "/void";
    private static final TextureType[] IS_BLOCK_TEXTURE = new TextureType[]{TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.BLOCK, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM, TextureType.ITEM};
    private static final String[] SUFFIXES = new String[]{"/dustTiny", "/dustSmall", "/dust", "/dustImpure", "/dustPure", "/crushed", "/crushedPurified", "/crushedCentrifuged", "/gem", "/nugget", "/casingSmall", "/ingot", "/ingotHot", "/ingotDouble", "/ingotTriple", "/ingotQuadruple", "/ingotQuintuple", "/plate", "/plateDouble", "/plateTriple", "/plateQuadruple", "/plateQuintuple", "/plateDense", "/stick", "/lens", "/round", "/bolt", "/screw", "/ring", "/foil", "/cell", "/cellPlasma", "/toolHeadSword", "/toolHeadPickaxe", "/toolHeadShovel", "/toolHeadAxe", "/toolHeadHoe", "/toolHeadHammer", "/toolHeadFile", "/toolHeadSaw", "/toolHeadDrill", "/toolHeadChainsaw", "/toolHeadWrench", "/toolHeadUniversalSpade", "/toolHeadSense", "/toolHeadPlow", "/toolHeadArrow", "/toolHeadScrewdriver", "/toolHeadBuzzSaw", "/toolHeadSoldering", "/nanites", "/wireFine", "/gearGtSmall", "/rotor", "/stickLong", "/springSmall", "/spring", "/arrowGtWood", "/arrowGtPlastic", "/gemChipped", "/gemFlawed", "/gemFlawless", "/gemExquisite", "/gearGt", "/oreRaw", "/void", "/void", "/oreSmall", "/ore", "/wire", "/foil", "/block1", "/block2", "/block3", "/block4", "/block5", "/block6", "/pipeSide", "/pipeTiny", "/pipeSmall", "/pipeMedium", "/pipeLarge", "/pipeHuge", "/frameGt", "/pipeQuadruple", "/pipeNonuple", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/crateGtDust", "/crateGtIngot", "/crateGtGem", "/crateGtPlate", "/turbineBlade", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/void", "/plateSuperdense", "/handleMallet", "/toolHeadMallet"};
    public boolean is_custom = false;
    public static final TextureSet SET_NONE = new TextureSet("NONE");
    public static final TextureSet SET_DULL = new TextureSet("DULL");
    public static final TextureSet SET_RUBY = new TextureSet("RUBY");
    public static final TextureSet SET_OPAL = new TextureSet("OPAL");
    public static final TextureSet SET_LEAF = new TextureSet("LEAF");
    public static final TextureSet SET_WOOD = new TextureSet("WOOD");
    public static final TextureSet SET_SAND = new TextureSet("SAND");
    public static final TextureSet SET_FINE = new TextureSet("FINE");
    public static final TextureSet SET_FIERY = new TextureSet("FIERY");
    public static final TextureSet SET_FLUID = new TextureSet("FLUID");
    public static final TextureSet SET_ROUGH = new TextureSet("ROUGH");
    public static final TextureSet SET_PAPER = new TextureSet("PAPER");
    public static final TextureSet SET_GLASS = new TextureSet("GLASS");
    public static final TextureSet SET_FLINT = new TextureSet("FLINT");
    public static final TextureSet SET_LAPIS = new TextureSet("LAPIS");
    public static final TextureSet SET_SHINY = new TextureSet("SHINY");
    public static final TextureSet SET_SHARDS = new TextureSet("SHARDS");
    public static final TextureSet SET_POWDER = new TextureSet("POWDER");
    public static final TextureSet SET_QUARTZ = new TextureSet("QUARTZ");
    public static final TextureSet SET_EMERALD = new TextureSet("EMERALD");
    public static final TextureSet SET_DIAMOND = new TextureSet("DIAMOND");
    public static final TextureSet SET_LIGNITE = new TextureSet("LIGNITE");
    public static final TextureSet SET_MAGNETIC = new TextureSet("MAGNETIC");
    public static final TextureSet SET_METALLIC = new TextureSet("METALLIC");
    public static final TextureSet SET_NETHERSTAR = new TextureSet("NETHERSTAR");
    public static final TextureSet SET_GEM_VERTICAL = new TextureSet("GEM_VERTICAL");
    public static final TextureSet SET_GEM_HORIZONTAL = new TextureSet("GEM_HORIZONTAL");
    public static final short INDEX_wire = 69;
    public static final short INDEX_foil = 70;
    public static final short INDEX_block1 = 71;
    public static final short INDEX_block2 = 72;
    public static final short INDEX_block3 = 73;
    public static final short INDEX_block4 = 74;
    public static final short INDEX_block5 = 75;
    public static final short INDEX_block6 = 76;
    public final IIconContainer[] mTextures = new IIconContainer[128];
    public final String mSetName;

    public TextureSet(String aSetName) {
        this.mSetName = aSetName;
        for (int i = 0; i < 128; ++i) {
            this.mTextures[i] = IS_BLOCK_TEXTURE[i] == TextureType.BLOCK ? new Textures.BlockIcons.CustomIcon(aTextMatIconDir + aSetName + SUFFIXES[i]) : (SUFFIXES[i].equals("/nanites") && !aSetName.contains("CUSTOM") ? new Textures.ItemIcons.CustomIcon("materialicons/NANITES" + SUFFIXES[i]) : new Textures.ItemIcons.CustomIcon(aTextMatIconDir + aSetName + SUFFIXES[i]));
        }
    }

    public TextureSet(String aSetName, boolean isCustom) {
        this("CUSTOM/" + aSetName);
        this.is_custom = isCustom;
    }

    private TextureSet(String aSetName, TextureSet origin, boolean overrideBlock, boolean overrideItem) {
        this.mSetName = "CUSTOM/" + aSetName;
        this.is_custom = true;
        for (int i = 0; i < 128; ++i) {
            if (IS_BLOCK_TEXTURE[i] == TextureType.BLOCK) {
                if (overrideBlock) {
                    this.mTextures[i] = new Textures.BlockIcons.CustomIcon(aTextMatIconDir + this.mSetName + SUFFIXES[i]);
                    continue;
                }
                this.mTextures[i] = origin.mTextures[i];
                continue;
            }
            this.mTextures[i] = overrideItem ? new Textures.ItemIcons.CustomIcon(aTextMatIconDir + aSetName + SUFFIXES[i]) : origin.mTextures[i];
        }
    }

    public TextureSet withBlockTextures(String aNewSetName) {
        return new TextureSet(aNewSetName, this, true, false);
    }

    private static enum TextureType {
        BLOCK,
        ITEM;

    }
}

