/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddInventorySlots;
import gregtech.api.interfaces.modularui.IGetGUITextureSet;
import gregtech.api.interfaces.tileentity.IGTEnet;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.interfaces.tileentity.IIC2Enet;
import gregtech.api.metatileentity.TileIC2EnergySink;
import gregtech.api.net.GTPacketBlockEvent;
import gregtech.api.net.GTPacketSetConfigurationCircuit;
import gregtech.api.util.GTTooltipDataCache;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class BaseTileEntity
extends TileEntity
implements IHasWorldObjectAndCoords,
IIC2Enet,
IGTEnet,
ITileWithModularUI,
IAddGregtechLogo,
IGetGUITextureSet,
IAddInventorySlots {
    protected boolean mInventoryChanged = false;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private final ChunkCoordinates mReturnedCoordinates = new ChunkCoordinates();
    protected TileIC2EnergySink ic2EnergySink = null;
    protected boolean joinedIc2Enet = false;
    protected GTTooltipDataCache mTooltipCache = new GTTooltipDataCache();
    public static final String BATTERY_SLOT_TOOLTIP = "GT5U.machines.battery_slot.tooltip";
    public static final String BATTERY_SLOT_TOOLTIP_ALT = "GT5U.machines.battery_slot.tooltip.alternative";
    public static final String UNUSED_SLOT_TOOLTIP = "GT5U.machines.unused_slot.tooltip";
    public static final String SPECIAL_SLOT_TOOLTIP = "GT5U.machines.special_slot.tooltip";
    public static final String STALLED_STUTTERING_TOOLTIP = "GT5U.machines.stalled_stuttering.tooltip";
    public static final String STALLED_VENT_TOOLTIP = "GT5U.machines.stalled_vent.tooltip";
    public static final String FLUID_TRANSFER_TOOLTIP = "GT5U.machines.fluid_transfer.tooltip";
    public static final String ITEM_TRANSFER_TOOLTIP = "GT5U.machines.item_transfer.tooltip";
    public static final String POWER_SOURCE_KEY = "GT5U.machines.powersource.";
    public static final String BUTTON_FORBIDDEN_TOOLTIP = "GT5U.gui.button.forbidden";
    public static final String NEI_TRANSFER_STEAM_TOOLTIP = "GT5U.machines.nei_transfer.steam.tooltip";
    public static final String NEI_TRANSFER_VOLTAGE_TOOLTIP = "GT5U.machines.nei_transfer.voltage.tooltip";
    public static final int TOOLTIP_DELAY = 5;
    protected Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x404040);
    protected Supplier<Integer> COLOR_TITLE_WHITE = () -> this.getTextColorOrDefault("title_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_WHITE = () -> this.getTextColorOrDefault("text_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x404040);
    protected Supplier<Integer> COLOR_TEXT_RED = () -> this.getTextColorOrDefault("text_red", 0xFF0000);

    public static ForgeDirection getSideForPlayerPlacing(Entity player, ForgeDirection defaultFacing, boolean[] aAllowedFacings) {
        ForgeDirection facingFromPlayer = GTUtility.getSideFromPlayerFacing(player);
        if (facingFromPlayer != ForgeDirection.UNKNOWN && aAllowedFacings[facingFromPlayer.ordinal()]) {
            return facingFromPlayer;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!aAllowedFacings[dir.ordinal()]) continue;
            return dir;
        }
        return defaultFacing;
    }

    private void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        Arrays.fill(this.mBufferedTileEntities, null);
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    @Override
    public final int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public ChunkCoordinates getCoords() {
        this.mReturnedCoordinates.field_71574_a = this.field_145851_c;
        this.mReturnedCoordinates.field_71572_b = this.field_145848_d;
        this.mReturnedCoordinates.field_71573_c = this.field_145849_e;
        return this.mReturnedCoordinates;
    }

    @Override
    public final int getOffsetX(ForgeDirection side, int multiplier) {
        return this.field_145851_c + side.offsetX * multiplier;
    }

    @Override
    public final short getOffsetY(ForgeDirection side, int multiplier) {
        return (short)(this.field_145848_d + side.offsetY * multiplier);
    }

    @Override
    public final int getOffsetZ(ForgeDirection side, int multiplier) {
        return this.field_145849_e + side.offsetZ * multiplier;
    }

    @Override
    public final boolean isServerSide() {
        if (this.field_145850_b == null) {
            return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
        }
        return !this.field_145850_b.field_72995_K;
    }

    @Override
    public final boolean isClientSide() {
        if (this.field_145850_b == null) {
            return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return this.field_145850_b.field_72995_K;
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    @Override
    public int getRandomNumber(int aRange) {
        return ThreadLocalRandom.current().nextInt(aRange);
    }

    @Override
    public final BiomeGenBase getBiome(int x, int z) {
        return this.field_145850_b.func_72807_a(x, z);
    }

    @Override
    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public final Block getBlockOffset(int x, int y, int z) {
        return this.getBlock(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final Block getBlockAtSide(ForgeDirection side) {
        return this.getBlockAtSideAndDistance(side, 1);
    }

    @Override
    public final Block getBlockAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getBlock(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final byte getMetaIDOffset(int x, int y, int z) {
        return this.getMetaID(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final byte getMetaIDAtSide(ForgeDirection side) {
        return this.getMetaIDAtSideAndDistance(side, 1);
    }

    @Override
    public final byte getMetaIDAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getMetaID(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final byte getLightLevelOffset(int x, int y, int z) {
        return this.getLightLevel(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final byte getLightLevelAtSide(ForgeDirection side) {
        return this.getLightLevelAtSideAndDistance(side, 1);
    }

    @Override
    public final byte getLightLevelAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getLightLevel(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final boolean getOpacityOffset(int x, int y, int z) {
        return this.getOpacity(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final boolean getOpacityAtSide(ForgeDirection side) {
        return this.getOpacityAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getOpacityAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getOpacity(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final boolean getSkyOffset(int x, int y, int z) {
        return this.getSky(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final boolean getSkyAtSide(ForgeDirection side) {
        return this.getSkyAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getSkyAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getSky(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final boolean getAirOffset(int x, int y, int z) {
        return this.getAir(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final boolean getAirAtSide(ForgeDirection side) {
        return this.getAirAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getAirAtSideAndDistance(ForgeDirection side, int distance) {
        return this.getAir(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final TileEntity getTileEntityOffset(int x, int y, int z) {
        return this.getTileEntity(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    @Override
    public final TileEntity getTileEntityAtSideAndDistance(ForgeDirection side, int distance) {
        if (distance == 1) {
            return this.getTileEntityAtSide(side);
        }
        return this.getTileEntity(this.getOffsetX(side, distance), this.getOffsetY(side, distance), this.getOffsetZ(side, distance));
    }

    @Override
    public final IInventory getIInventory(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntity(x, y, z);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryOffset(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntityOffset(x, y, z);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IInventory getIInventoryAtSideAndDistance(ForgeDirection side, int distance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, distance);
        if (tTileEntity instanceof IInventory) {
            return (IInventory)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainer(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntity(x, y, z);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerOffset(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntityOffset(x, y, z);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSideAndDistance(ForgeDirection side, int distance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, distance);
        if (tTileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntity(x, y, z);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int x, int y, int z) {
        TileEntity tTileEntity = this.getTileEntityOffset(x, y, z);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(ForgeDirection side, int distance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, distance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    @Override
    public final Block getBlock(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return Blocks.field_150350_a;
        }
        return this.field_145850_b.func_147439_a(x, y, z);
    }

    public Block getBlock(ChunkCoordinates aCoords) {
        if (this.field_145850_b == null) {
            return Blocks.field_150350_a;
        }
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(aCoords) && !this.field_145850_b.func_72899_e(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) {
            return Blocks.field_150350_a;
        }
        return this.field_145850_b.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public final byte getMetaID(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return 0;
        }
        return (byte)this.field_145850_b.func_72805_g(x, y, z);
    }

    @Override
    public final byte getLightLevel(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return 0;
        }
        return (byte)(this.field_145850_b.func_72801_o(x, y, z) * 15.0f);
    }

    @Override
    public final boolean getSky(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return true;
        }
        return this.field_145850_b.func_72937_j(x, y, z);
    }

    @Override
    public final boolean getOpacity(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return false;
        }
        return GTUtility.isOpaqueBlock(this.field_145850_b, x, y, z);
    }

    @Override
    public final boolean getAir(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return true;
        }
        return GTUtility.isBlockAir(this.field_145850_b, x, y, z);
    }

    @Override
    public TileEntity getTileEntity(int x, int y, int z) {
        if (this.ignoreUnloadedChunks && this.crossedChunkBorder(x, z) && !this.field_145850_b.func_72899_e(x, y, z)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(x, y, z);
    }

    @Override
    public final TileEntity getTileEntityAtSide(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        if (side == ForgeDirection.UNKNOWN || this.mBufferedTileEntities[ordinalSide] == this) {
            return null;
        }
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        if (this.crossedChunkBorder(tX, tZ)) {
            this.mBufferedTileEntities[ordinalSide] = null;
            if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                return null;
            }
        }
        if (this.mBufferedTileEntities[ordinalSide] == null) {
            this.mBufferedTileEntities[ordinalSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
            if (this.mBufferedTileEntities[ordinalSide] == null) {
                this.mBufferedTileEntities[ordinalSide] = this;
                return null;
            }
            return this.mBufferedTileEntities[ordinalSide];
        }
        if (this.mBufferedTileEntities[ordinalSide].func_145837_r()) {
            this.mBufferedTileEntities[ordinalSide] = null;
            return this.getTileEntityAtSide(side);
        }
        if (this.mBufferedTileEntities[ordinalSide].field_145851_c == tX && this.mBufferedTileEntities[ordinalSide].field_145848_d == tY && this.mBufferedTileEntities[ordinalSide].field_145849_e == tZ) {
            return this.mBufferedTileEntities[ordinalSide];
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.leaveEnet();
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public void func_145845_h() {
        this.isDead = false;
    }

    public final void onAdjacentBlockChange(int ignoredAX, int ignoredAY, int ignoredAZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    public void updateNeighbours(int mStrongRedstone, int oStrongRedstone) {
        Block thisBlock = this.getBlockOffset(0, 0, 0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x1 = this.field_145851_c + dir.offsetX;
            int y1 = this.field_145848_d + dir.offsetY;
            int z1 = this.field_145849_e + dir.offsetZ;
            if (!this.field_145850_b.func_72899_e(x1, y1, z1)) continue;
            this.field_145850_b.func_147460_e(x1, y1, z1, thisBlock);
            if (((mStrongRedstone | oStrongRedstone) >>> dir.ordinal() & 1) == 0 || !this.getBlock(x1, y1, z1).func_149721_r()) continue;
            int skipUpdateSide = dir.getOpposite().ordinal();
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                int x2 = x1 + dir2.offsetX;
                int y2 = y1 + dir2.offsetY;
                int z2 = z1 + dir2.offsetZ;
                if (dir2.ordinal() == skipUpdateSide || !this.field_145850_b.func_72899_e(x2, y2, z2)) continue;
                this.field_145850_b.func_147460_e(x2, y2, z2, thisBlock);
            }
        }
    }

    @Override
    public final void sendBlockEvent(byte aID, byte aValue) {
        GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketBlockEvent(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    protected boolean crossedChunkBorder(int x, int z) {
        return x >> 4 != this.field_145851_c >> 4 || z >> 4 != this.field_145849_e >> 4;
    }

    public final boolean crossedChunkBorder(ChunkCoordinates coords) {
        return coords.field_71574_a >> 4 != this.field_145851_c >> 4 || coords.field_71573_c >> 4 != this.field_145849_e >> 4;
    }

    public final void setOnFire() {
        GTUtility.setCoordsOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    public final void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    public void func_70296_d() {
        Chunk chunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
        if (chunk != null) {
            chunk.func_76630_e();
        }
    }

    @Nullable
    public List<ItemStack> getItemsForHoloGlasses() {
        return null;
    }

    protected Supplier<Boolean> getValidator() {
        return () -> !this.isDead();
    }

    public boolean useModularUI() {
        return false;
    }

    protected void createIc2Sink() {
        if (this.ic2EnergySink == null && this.isServerSide() && this.shouldJoinIc2Enet()) {
            this.ic2EnergySink = new TileIC2EnergySink((IGregTechTileEntity)((Object)this));
        }
    }

    @Override
    public void doEnetUpdate() {
        this.leaveEnet();
        this.joinEnet();
    }

    protected void joinEnet() {
        if (this.joinedIc2Enet || !this.shouldJoinIc2Enet()) {
            return;
        }
        if (this.ic2EnergySink == null) {
            this.createIc2Sink();
        }
        if (this.ic2EnergySink != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.ic2EnergySink));
            this.joinedIc2Enet = true;
        }
    }

    protected void leaveEnet() {
        if (this.joinedIc2Enet && this.ic2EnergySink != null && this.isServerSide()) {
            this.joinedIc2Enet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.ic2EnergySink));
        }
    }

    public ItemStackHandler getInventoryHandler() {
        return null;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
    }

    public void bindPlayerInventoryUI(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.bindPlayerInventory(buildContext.getPlayer(), 7, (IDrawable)this.getGUITextureSet().getItemSlot());
    }

    public String getLocalName() {
        return "Unknown";
    }

    protected void addTitleToUI(ModularWindow.Builder builder) {
        this.addTitleToUI(builder, this.getLocalName());
    }

    protected void addTitleToUI(ModularWindow.Builder builder, String title) {
        if (GTMod.gregtechproxy.mTitleTabStyle == 2) {
            this.addTitleItemIconStyle(builder, title);
        } else {
            this.addTitleTextStyle(builder, title);
        }
    }

    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
        int TAB_PADDING = 3;
        int TITLE_PADDING = 2;
        int titleWidth = 0;
        int titleHeight = 0;
        if (NetworkUtils.isClient()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List titleLines = fontRenderer.func_78271_c(title, this.getGUIWidth() - 10);
            titleWidth = titleLines.size() > 1 ? this.getGUIWidth() - 10 : fontRenderer.func_78256_a(title);
            titleHeight = titleLines.size() * fontRenderer.field_78288_b + (titleLines.size() - 1) * 1;
        }
        DrawableWidget tab = new DrawableWidget();
        TextWidget text = new TextWidget(title).setDefaultColor(this.getTitleColor()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(titleWidth);
        if (GTMod.gregtechproxy.mTitleTabStyle == 1) {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabAngular()).setPos(0, -(titleHeight + 3) + 1).setSize(this.getGUIWidth(), titleHeight + 6);
            text.setPos(5, -titleHeight + 3);
        } else {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabDark()).setPos(0, -(titleHeight + 6) + 1).setSize(titleWidth + 10, titleHeight + 6 - 1);
            text.setPos(5, -titleHeight);
        }
        ((ModularWindow.Builder)builder.widget((Widget)tab)).widget((Widget)text);
    }

    protected void addTitleItemIconStyle(ModularWindow.Builder builder, String title) {
        builder.widget(new MultiChildWidget().addChild(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getTitleTabNormal()).setPos(0, 0).setSize(24, 24)).addChild(new ItemDrawable(this.getStackForm(1L)).asWidget().setPos(4, 4)).addTooltip(title).setTooltipShowUpDelay(5).setPos(0, -21));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.DEFAULT;
    }

    protected int getTitleColor() {
        return this.COLOR_TITLE.get();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 63));
    }

    protected int getGUIWidth() {
        return 176;
    }

    protected int getGUIHeight() {
        return 166;
    }

    protected boolean doesBindPlayerInventory() {
        return true;
    }

    @Override
    public void add1by1Slot(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)1).startFromSlot(0).endAtSlot(0).background(background).build().setPos(79, 34));
    }

    @Override
    public void add2by2Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).background(background).build().setPos(70, 25));
    }

    @Override
    public void add3by3Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)3).startFromSlot(0).endAtSlot(8).background(background).build().setPos(61, 16));
    }

    @Override
    public void add4by4Slots(ModularWindow.Builder builder, IDrawable ... background) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        if (background.length == 0) {
            background = new IDrawable[]{this.getGUITextureSet().getItemSlot()};
        }
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).background(background).build().setPos(52, 7));
    }

    public void addCoverTabs(ModularWindow.Builder builder, UIBuildContext buildContext) {
    }

    public IConfigurationCircuitSupport getConfigurationCircuitSupport() {
        if (!(this instanceof IConfigurationCircuitSupport)) {
            return null;
        }
        return (IConfigurationCircuitSupport)((Object)this);
    }

    protected void addConfigurationCircuitSlot(ModularWindow.Builder builder) {
        ItemStackHandler inventoryHandler = this.getInventoryHandler();
        if (inventoryHandler == null) {
            return;
        }
        BaseTileEntity baseTileEntity = this;
        if (!(baseTileEntity instanceof IInventory)) {
            return;
        }
        final IInventory inv = (IInventory)baseTileEntity;
        final IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        final AtomicBoolean dialogOpened = new AtomicBoolean(false);
        builder.widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)inventoryHandler, ccs.getCircuitSlot(), true)){

            protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                ItemStack newCircuit;
                if (clickData.shift) {
                    if (clickData.mouseButton == 0) {
                        if (NetworkUtils.isClient() && !dialogOpened.get()) {
                            BaseTileEntity.this.openSelectCircuitDialog(this.getContext(), dialogOpened);
                        }
                        return;
                    }
                    newCircuit = null;
                } else {
                    List<ItemStack> tCircuits = ccs.getConfigurationCircuits();
                    int index = GTUtility.findMatchingStackInList(tCircuits, cursorStack);
                    if (index < 0) {
                        int curIndex = GTUtility.findMatchingStackInList(tCircuits, inv.func_70301_a(ccs.getCircuitSlot())) + 1;
                        curIndex = clickData.mouseButton == 0 ? ++curIndex : --curIndex;
                        curIndex = Math.floorMod(curIndex, tCircuits.size() + 1) - 1;
                        newCircuit = curIndex < 0 ? null : tCircuits.get(curIndex);
                    } else {
                        newCircuit = tCircuits.get(index);
                    }
                }
                inv.func_70299_a(ccs.getCircuitSlot(), newCircuit);
            }

            protected void phantomScroll(int direction) {
                this.phantomClick(new Widget.ClickData(direction > 0 ? 1 : 0, false, false, false));
            }

            public List<String> getExtraTooltip() {
                return Arrays.asList(EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.1")), EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.2")), EnumChatFormatting.DARK_GRAY + EnumChatFormatting.func_110646_a((String)StatCollector.func_74838_a((String)"GT5U.machines.select_circuit.tooltip.3")));
            }
        }.setOverwriteItemStackTooltip(list -> {
            list.removeIf(line -> line.contains(StatCollector.func_74838_a((String)"gt.integrated_circuit.tooltip.0")) || line.contains(StatCollector.func_74838_a((String)"gt.integrated_circuit.tooltip.1")));
            return list;
        }).disableShiftInsert().setHandlePhantomActionClient(true).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_INT_CIRCUIT}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.select_circuit.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(ccs.getCircuitSlotX() - 1, ccs.getCircuitSlotY() - 1));
    }

    protected void openSelectCircuitDialog(ModularUIContext uiContext, AtomicBoolean dialogOpened) {
        IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        BaseTileEntity baseTileEntity = this;
        if (!(baseTileEntity instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)baseTileEntity;
        List<ItemStack> circuits = ccs.getConfigurationCircuits();
        uiContext.openClientWindow(player -> new SelectItemUIFactory(StatCollector.func_74838_a((String)"GT5U.machines.select_circuit"), this.getStackForm(0L), this::onCircuitSelected, circuits, GTUtility.findMatchingStackInList(circuits, inv.func_70301_a(ccs.getCircuitSlot()))).setAnotherWindow(true, dialogOpened).setGuiTint(this.getGUIColorization()).setCurrentGetter(() -> inv.func_70301_a(ccs.getCircuitSlot())).createWindow(new UIBuildContext(player)));
    }

    protected void onCircuitSelected(ItemStack selected) {
        IConfigurationCircuitSupport ccs = this.getConfigurationCircuitSupport();
        if (ccs == null) {
            return;
        }
        BaseTileEntity baseTileEntity = this;
        if (!(baseTileEntity instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)baseTileEntity;
        GTValues.NW.sendToServer(new GTPacketSetConfigurationCircuit(this, selected));
        inv.func_70299_a(ccs.getCircuitSlot(), selected);
    }

    protected int getTextColorOrDefault(String textType, int defaultColor) {
        return defaultColor;
    }

    public int getGUIColorization() {
        return GTUtil.getRGBaInt(Dyes.dyeWhite.getRGBA());
    }

    public ItemStack getStackForm(long aAmount) {
        return null;
    }
}

