/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import gregtech.api.enums.Materials;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.multiblock.casing.FunctionalCasing;
import gregtech.api.multitileentity.multiblock.casing.UpgradeCasing;
import gregtech.api.util.GTUtil;
import gregtech.common.tileentities.casings.upgrade.Inventory;
import gregtech.common.tileentities.casings.upgrade.Tank;
import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;

public class MultiTileEntityClassContainer {
    private final WeakReference<MultiTileEntityRegistry> registry;
    private String localized;
    private String categoryName;
    private final short muteID;
    private final Class<? extends MultiTileEntity> muteClass;
    private MultiTileEntity referenceTileEntity;
    private NBTTagCompound parameters;
    public boolean hidden = false;

    public MultiTileEntityClassContainer(MultiTileEntityRegistry aRegistry, int aID, Class<? extends MultiTileEntity> aClass) {
        this.registry = new WeakReference<MultiTileEntityRegistry>(aRegistry);
        this.muteID = (short)aID;
        this.muteClass = aClass;
        this.parameters = new NBTTagCompound();
    }

    public boolean register() {
        MultiTileEntityRegistry registry = (MultiTileEntityRegistry)this.registry.get();
        if (this.parameters.func_74764_b("gt.material") && !this.parameters.func_74764_b("gt.color")) {
            this.parameters.func_74768_a("gt.color", GTUtil.getRGBInt(Materials.get(this.parameters.func_74779_i("gt.material")).getRGBA()));
        }
        try {
            this.referenceTileEntity = this.muteClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        this.referenceTileEntity.initFromNBT(this.parameters, this.muteID, (short)-1);
        return registry != null && registry.add(this.localized, this) != null;
    }

    public MultiTileEntityClassContainer name(String aName) {
        this.localized = aName;
        return this;
    }

    public MultiTileEntityClassContainer category(String aCategoryName) {
        this.categoryName = aCategoryName;
        return this;
    }

    public MultiTileEntityClassContainer hide() {
        this.hidden = true;
        return this;
    }

    public MultiTileEntityClassContainer material(Materials material) {
        this.parameters.func_74778_a("gt.material", material.toString());
        if (!this.parameters.func_74764_b("gt.color")) {
            this.parameters.func_74768_a("gt.color", GTUtil.getRGBInt(material.getRGBA()));
        }
        return this;
    }

    public MultiTileEntityClassContainer color(int rbg) {
        this.parameters.func_74768_a("gt.color", rbg);
        return this;
    }

    public MultiTileEntityClassContainer color(short[] rgba) {
        this.parameters.func_74768_a("gt.color", GTUtil.getRGBInt(rgba));
        return this;
    }

    public MultiTileEntityClassContainer textureFolder(String texture) {
        this.parameters.func_74778_a("gt.texture.folder", texture);
        return this;
    }

    public MultiTileEntityClassContainer inputInventorySize(int aSize) {
        this.parameters.func_74768_a("gt.invsize.in", aSize);
        return this;
    }

    public MultiTileEntityClassContainer outputInventorySize(int aSize) {
        this.parameters.func_74768_a("gt.invsize.out", aSize);
        return this;
    }

    public MultiTileEntityClassContainer tankCapacity(Long aCapacity) {
        this.parameters.func_74772_a("gt.tankcap", aCapacity.longValue());
        return this;
    }

    public MultiTileEntityClassContainer tier(int aTier) {
        this.verifyDescendentOfMultiple(true, UpgradeCasing.class, FunctionalCasing.class);
        this.parameters.func_74768_a("gt.tier", aTier);
        return this;
    }

    public MultiTileEntityClassContainer upgradeInventorySize(int aSize) {
        this.verifyDescendentOf(Inventory.class);
        this.parameters.func_74768_a("gt.invsize.upg", aSize);
        return this;
    }

    public MultiTileEntityClassContainer upgradeTankCount(int count) {
        this.verifyDescendentOf(Tank.class);
        this.parameters.func_74768_a("gt.tank.ct.upg", count);
        return this;
    }

    public MultiTileEntityClassContainer upgradeTankCapacity(Long aCapacity) {
        this.parameters.func_74772_a("gt.tank.cap.upg", aCapacity.longValue());
        return this;
    }

    public MultiTileEntityClassContainer upgradeAmperage(long amperage) {
        this.parameters.func_74772_a("gt.amp.upg", amperage);
        return this;
    }

    public MultiTileEntityClassContainer setNBT(String key, Object val) {
        return this.setNBT(new Tuple((Object)key, val));
    }

    public MultiTileEntityClassContainer setNBT(Tuple ... aTags) {
        this.parameters = GTUtil.fuseNBT(this.parameters, GTUtil.makeNBT(aTags));
        return this;
    }

    public WeakReference<MultiTileEntityRegistry> getRegistry() {
        return this.registry;
    }

    public Class<? extends MultiTileEntity> getMuteClass() {
        return this.muteClass;
    }

    public short getMuteID() {
        return this.muteID;
    }

    public MultiTileEntity getReferenceTileEntity() {
        return this.referenceTileEntity;
    }

    public NBTTagCompound getParameters() {
        return this.parameters;
    }

    private void verifyDescendentOf(Class<?> cls) {
        if (!cls.isAssignableFrom(this.muteClass)) {
            throw new IllegalArgumentException("Expected a descendent of " + cls.getName() + " got " + this.muteClass.getName() + " instead.");
        }
    }

    private void verifyDescendentOfMultiple(boolean onlyOne, Class<?> ... classes) {
        boolean atLeastOne = false;
        StringBuilder classNames = new StringBuilder();
        for (Class<? extends MultiTileEntity> clazz : classes) {
            classNames.append(clazz.getName()).append(" ");
            if (!onlyOne) {
                this.verifyDescendentOf(clazz);
                atLeastOne = true;
                continue;
            }
            if (!clazz.isAssignableFrom(this.muteClass)) continue;
            atLeastOne = true;
        }
        if (!atLeastOne) {
            throw new IllegalArgumentException("Expected a descendent of any of these " + classNames + " got " + this.muteClass.getName() + " instead.");
        }
    }
}

