/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityBlock;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiTileEntityItem
extends ItemBlock {
    public final MultiTileEntityBlock block;

    public MultiTileEntityItem(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.block = (MultiTileEntityBlock)block;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean F3_H) {
        MultiTileEntity mute = this.block.getRegistry().getReferenceTileEntity(stack);
        if (mute == null) {
            list.add("INVALID ITEM!");
            return;
        }
        try {
            mute.addToolTips(list, stack, F3_H);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("addInformation", e);
        }
        NBTTagCompound aNBT = stack.func_77978_p();
        CoverableTileEntity.addInstalledCoversInformation(aNBT, list);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List<ItemStack> aList) {
        for (MultiTileEntityClassContainer tClass : this.block.getRegistry().registrations) {
            if (tClass.hidden || !tClass.getReferenceTileEntity().getSubItems(this.block, aItem, aTab, aList, tClass.getMuteID())) continue;
            aList.add(this.block.getRegistry().getItem(tClass.getMuteID()));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (y < 0 || y > world.func_72800_K()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        try {
            ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
            Block clickedBlock = world.func_147439_a(x, y, z);
            if (clickedBlock instanceof BlockSnow && (world.func_72805_g(x, y, z) & 7) < 1) {
                ordinalSide = 1;
                side = ForgeDirection.UP;
            } else if (clickedBlock != Blocks.field_150395_bd && clickedBlock != Blocks.field_150329_H && clickedBlock != Blocks.field_150330_I && !clickedBlock.isReplaceable((IBlockAccess)world, x, y, z)) {
                x += side.offsetX;
                y += side.offsetY;
                z += side.offsetZ;
            }
            Block tReplacedBlock = world.func_147439_a(x, y, z);
            if (!tReplacedBlock.isReplaceable((IBlockAccess)world, x, y, z) || !this.block.func_149705_a(world, x, y, z, ordinalSide, stack)) {
                return false;
            }
            if (stack.field_77994_a == 0 || !player.func_82247_a(x, y, z, ordinalSide, stack)) {
                return false;
            }
            if (!world.func_147465_d(x, y, z, (Block)this.block, Items.field_151008_G.getDamage(stack), 2)) {
                return false;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof IMultiTileEntity)) {
                throw new IllegalStateException("TileEntity is not an IMultiTileEntity");
            }
            IMultiTileEntity mute = (IMultiTileEntity)te;
            try {
                if (mute.onPlaced(stack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.block.field_149762_H.func_150496_b(), (this.block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.block.field_149762_H.func_150494_d() * 0.8f);
                }
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("onPlaced", e);
            }
            try {
                if (!world.field_72995_K) {
                    world.func_147444_c(x, y, z, tReplacedBlock);
                    world.func_147453_f(x, y, z, (Block)this.block);
                }
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("notifyBlockChange", e);
            }
            try {
                mute.onTileEntityPlaced();
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("onTileEntityPlaced", e);
            }
            try {
                world.func_147451_t(x, y, z);
            }
            catch (Throwable e) {
                GTMod.GT_FML_LOGGER.error("updateAllLightTypes", e);
            }
            --stack.field_77994_a;
            return true;
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("onItemUse", e);
            return false;
        }
    }

    public boolean func_150936_a(World aWorld, int aX, int aY, int aZ, int ordinalSide, EntityPlayer aPlayer, ItemStack aStack) {
        return true;
    }

    public final String func_77658_a() {
        return this.block.getRegistry().getInternalName();
    }

    public final String func_77667_c(ItemStack aStack) {
        return this.block.getRegistry().getInternalName() + "." + this.getDamage(aStack);
    }

    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int aMeta) {
        this.field_77791_bV = Items.field_151025_P.func_77617_a(0);
        return this.field_77791_bV;
    }

    public boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    public final boolean func_77651_p() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }
}

