/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.CoverInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class GTPacketSendCoverData
extends GTPacket {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected ForgeDirection side;
    protected int coverID;
    protected ISerializableObject coverData;

    public GTPacketSendCoverData() {
    }

    public GTPacketSendCoverData(int mX, short mY, int mZ, ForgeDirection coverSide, int coverID, ISerializableObject coverData) {
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
    }

    public GTPacketSendCoverData(CoverInfo info, ICoverable tile) {
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = info.getSide();
        this.coverID = info.getCoverID();
        this.coverData = info.getCoverData();
    }

    public GTPacketSendCoverData(ForgeDirection coverSide, int coverID, ISerializableObject coverData, ICoverable tile) {
        this.mX = tile.getXCoord();
        this.mY = tile.getYCoord();
        this.mZ = tile.getZCoord();
        this.side = coverSide;
        this.coverID = coverID;
        this.coverData = coverData;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.SEND_COVER_DATA.id;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte(this.side.ordinal());
        aOut.writeInt(this.coverID);
        this.coverData.writeToByteBuf(aOut);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        int coverId = aData.readInt();
        return new GTPacketSendCoverData(aData.readInt(), aData.readShort(), aData.readInt(), ForgeDirection.getOrientation((int)aData.readByte()), coverId, GregTechAPI.getCoverBehaviorNew(coverId).createDataObject().readFromPacket(aData, null));
    }

    @Override
    public void process(IBlockAccess aWorld) {
        CoverableTileEntity coverable;
        TileEntity tile;
        if (aWorld != null && (tile = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ)) instanceof CoverableTileEntity && !(coverable = (CoverableTileEntity)tile).isDead()) {
            coverable.receiveCoverData(this.side, this.coverID, this.coverData, null);
        }
    }
}

