/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.SteamVariant;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PurificationUnitRecipeMapFrontend
extends RecipeMapFrontend {
    private final int overlayHeight;
    private static final Pos2d realProgressBarPos = new Pos2d(3, 3);

    public PurificationUnitRecipeMapFrontend(int overlayHeight, BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder.progressBarSize(new Size(0, 0)).progressBarPos(new Pos2d(0, 0)), neiPropertiesBuilder);
        this.overlayHeight = overlayHeight;
    }

    @Override
    public void addProgressBar(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        assert (this.uiProperties.progressBarTexture != null);
        UITexture texture = this.uiProperties.progressBarTexture.get();
        builder.widget(new ProgressBar().setTexture(texture, 170).setDirection(this.uiProperties.progressBarDirection).setProgress(progressSupplier).setSynced(false, false).setPos(realProgressBarPos.add(windowOffset)).setSize(new Size(170, this.overlayHeight)));
    }

    @Override
    public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        ModularWindow.Builder builder = ModularWindow.builder((Size)this.neiProperties.recipeBackgroundSize);
        if (this.uiProperties.useProgressBar) {
            this.addProgressBar(builder, progressSupplier, windowOffset);
        }
        UIHelper.forEachSlots((i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)itemOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> {
            if (this.uiProperties.useSpecialSlot) {
                builder.widget(SlotWidget.phantom((IItemHandlerModifiable)specialSlotInventory, (int)0).setBackground(backgrounds).setPos(pos).setSize(18, 18));
            }
        }, (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidInputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (i, backgrounds, pos) -> builder.widget(SlotWidget.phantom((IItemHandlerModifiable)fluidOutputsInventory, (int)i).setBackground(backgrounds).setPos(pos).setSize(18, 18)), (IDrawable)ModularUITextures.ITEM_SLOT, (IDrawable)ModularUITextures.FLUID_SLOT, this.uiProperties, this.uiProperties.maxItemInputs, this.uiProperties.maxItemOutputs, this.uiProperties.maxFluidInputs, this.uiProperties.maxFluidOutputs, SteamVariant.NONE, windowOffset);
        this.addGregTechLogo(builder, windowOffset);
        for (Pair<IDrawable, Pair<Size, Pos2d>> specialTexture : this.uiProperties.specialTextures) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)specialTexture.getLeft()).setSize((Size)((Pair)specialTexture.getRight()).getLeft()).setPos(((Pos2d)((Pair)specialTexture.getRight()).getRight()).add(windowOffset)));
        }
        return builder;
    }
}

