/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.IRedstoneCircuitBlock;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class CircuitryBehavior {
    public CircuitryBehavior(int aIndex) {
        GregTechAPI.sCircuitryBehaviors.put(aIndex, this);
    }

    public static boolean getAnyRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity()) || aRedstoneCircuitBlock.getInputRedstone(side) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean getAllRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity()) || aRedstoneCircuitBlock.getInputRedstone(side) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean getOneRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        int tRedstoneAmount = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity()) || aRedstoneCircuitBlock.getInputRedstone(side) <= 0) continue;
            ++tRedstoneAmount;
        }
        return tRedstoneAmount == 1;
    }

    public static byte getStrongestRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        byte tRedstoneAmount = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity())) continue;
            tRedstoneAmount = (byte)Math.max(tRedstoneAmount, aRedstoneCircuitBlock.getInputRedstone(side));
        }
        return tRedstoneAmount;
    }

    public static byte getWeakestNonZeroRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        if (!CircuitryBehavior.getAnyRedstone(aRedstoneCircuitBlock)) {
            return 0;
        }
        byte tRedstoneAmount = 15;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity()) || aRedstoneCircuitBlock.getInputRedstone(side) <= 0) continue;
            tRedstoneAmount = (byte)Math.min(tRedstoneAmount, aRedstoneCircuitBlock.getInputRedstone(side));
        }
        return tRedstoneAmount;
    }

    public static byte getWeakestRedstone(IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        if (!CircuitryBehavior.getAnyRedstone(aRedstoneCircuitBlock)) {
            return 0;
        }
        byte tRedstoneAmount = 15;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side == aRedstoneCircuitBlock.getOutputFacing() || !aRedstoneCircuitBlock.getCover(side).letsRedstoneGoIn(side, aRedstoneCircuitBlock.getCoverID(side), aRedstoneCircuitBlock.getCoverVariable(side), aRedstoneCircuitBlock.getOwnTileEntity())) continue;
            tRedstoneAmount = (byte)Math.min(tRedstoneAmount, aRedstoneCircuitBlock.getInputRedstone(side));
        }
        return tRedstoneAmount;
    }

    public abstract void initParameters(int[] var1, IRedstoneCircuitBlock var2);

    public abstract void validateParameters(int[] var1, IRedstoneCircuitBlock var2);

    public abstract void onTick(int[] var1, IRedstoneCircuitBlock var2);

    public abstract boolean displayItemStack(int[] var1, IRedstoneCircuitBlock var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public abstract String getName();

    @SideOnly(value=Side.CLIENT)
    public abstract String getDescription();

    @SideOnly(value=Side.CLIENT)
    public abstract String getDataDescription(int[] var1, int var2);

    @SideOnly(value=Side.CLIENT)
    public String getDataDisplay(int[] aCircuitData, int aCircuitDataIndex) {
        return null;
    }
}

