/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.item;

import gregtech.api.util.GTUtility;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHolder {
    private final Item item;
    private final int meta;
    private final NBTTagCompound tag;
    private final int[] oreIDs;

    public ItemHolder(@Nonnull ItemStack item) {
        this.item = item.func_77973_b();
        this.meta = Items.field_151008_G.getDamage(item);
        this.tag = item.func_77978_p();
        this.oreIDs = OreDictionary.getOreIDs((ItemStack)item);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public NBTTagCompound getNBT() {
        return this.tag;
    }

    public int[] getOreDictTagIDs() {
        return this.oreIDs;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ItemHolder)) {
            return false;
        }
        ItemHolder otherIH = (ItemHolder)other;
        if (Arrays.stream(this.oreIDs).anyMatch(id -> {
            for (int i = 0; i < otherIH.getOreDictTagIDs().length; ++i) {
                if (id != otherIH.getOreDictTagIDs()[i]) continue;
                return true;
            }
            return false;
        })) {
            return true;
        }
        if (this.item != otherIH.getItem() || this.meta != otherIH.getMeta()) {
            return false;
        }
        if (this.tag == null && otherIH.getNBT() == null) {
            return true;
        }
        if (this.tag == null || otherIH.getNBT() == null) {
            return false;
        }
        return this.tag.equals((Object)otherIH);
    }

    public int hashCode() {
        return GTUtility.stackToInt(this.toStack());
    }

    @Nonnull
    private ItemStack toStack() {
        ItemStack item = new ItemStack(this.item, 1, this.meta);
        item.field_77990_d = this.tag;
        return item;
    }
}

