/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.shutdown;

import gregtech.api.util.GTUtility;
import gregtech.api.util.shutdown.ShutDownReason;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class ReasonOutOfStuff
implements ShutDownReason {
    private String required;
    private int amount;

    ReasonOutOfStuff(@NotNull String required, int amount) {
        this.required = required;
        this.amount = amount;
    }

    @Override
    @NotNull
    public String getID() {
        return "out_of_stuff";
    }

    @Override
    @NotNull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.out_of_stuff", (Object[])new Object[]{this.required, GTUtility.formatNumbers(this.amount)}));
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74778_a("required", this.required);
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.required = tag.func_74779_i("required");
        tag.func_74768_a("amount", this.amount);
    }

    @Override
    @NotNull
    public ShutDownReason newInstance() {
        return new ReasonOutOfStuff("stuff", 1);
    }

    @Override
    public void encode(@NotNull PacketBuffer buffer) {
        buffer.writeInt(this.amount);
        try {
            buffer.func_150785_a(this.required);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.amount = buffer.readInt();
        try {
            this.required = buffer.func_150789_c(32768);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean wasCritical() {
        return true;
    }
}

