/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import appeng.api.util.IOrientable;
import appeng.tile.misc.TileInterface;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.glodblock.github.nei.object.IRecipeExtractor;
import com.glodblock.github.nei.recipes.FluidRecipe;
import com.glodblock.github.nei.recipes.extractor.GregTech5RecipeExtractor;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.net.GTPacketClientPreference;
import gregtech.api.objects.GTItemStack;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.util.ColorsMetadataSection;
import gregtech.api.util.ColorsMetadataSectionSerializer;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTClientPreference;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTMusicSystem;
import gregtech.api.util.GTPlayedSound;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.client.GTMouseEventHandler;
import gregtech.client.SeekingOggCodec;
import gregtech.common.GTProxy;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.pollution.Pollution;
import gregtech.common.pollution.PollutionRenderer;
import gregtech.common.render.BlackholeRenderer;
import gregtech.common.render.DroneRender;
import gregtech.common.render.FlaskRenderer;
import gregtech.common.render.FluidDisplayStackRenderer;
import gregtech.common.render.GTCapeRenderer;
import gregtech.common.render.GTRendererBlock;
import gregtech.common.render.LaserRenderer;
import gregtech.common.render.MetaGeneratedToolRenderer;
import gregtech.common.render.MultiTileRenderer;
import gregtech.common.render.WormholeRenderer;
import gregtech.common.render.items.DataStickRenderer;
import gregtech.common.render.items.InfiniteSprayCanRenderer;
import gregtech.common.render.items.MetaGeneratedItemRenderer;
import gregtech.common.tileentities.debug.MTEAdvDebugStructureWriter;
import gregtech.loaders.ExtraIcons;
import gregtech.loaders.misc.GTBees;
import gregtech.loaders.preload.GTPreLoad;
import gregtech.nei.NEIGTConfig;
import ic2.api.tile.IWrenchable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;

public class GTClient
extends GTProxy
implements Runnable {
    public static final String GTNH_CAPE_LIST_URL = "https://raw.githubusercontent.com/GTNewHorizons/CustomGTCapeHook-Cape-List/master/capes.txt";
    public static final String GT_CAPE_LIST_URL = "http://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlist.txt";
    private static final List<Block> ROTATABLE_VANILLA_BLOCKS;
    private static final int[][] GRID_SWITCH_TABLE;
    private static final Transformation ROTATION_MARKER_TRANSFORM_CENTER;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS;
    private static final int[] ROTATION_MARKER_TRANSFORMS_SIDES;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_CORNER;
    private static int rotationMarkerDisplayList;
    private static boolean rotationMarkerDisplayListCompiled;
    private final HashSet<String> mCapeList = new HashSet();
    public static final PollutionRenderer mPollutionRenderer;
    private final GTCapeRenderer mCapeRenderer;
    private final List<Materials> mPosR;
    private final List<Materials> mPosG;
    private final List<Materials> mPosB;
    private final List<Materials> mPosA = Collections.emptyList();
    private final List<Materials> mNegR;
    private final List<Materials> mNegG;
    private final List<Materials> mNegB;
    private final List<Materials> mNegA = Collections.emptyList();
    private final List<Materials> mMoltenPosR;
    private final List<Materials> mMoltenPosG;
    private final List<Materials> mMoltenPosB;
    private final List<Materials> mMoltenPosA = Collections.emptyList();
    private final List<Materials> mMoltenNegR;
    private final List<Materials> mMoltenNegG;
    private final List<Materials> mMoltenNegB;
    private final List<Materials> mMoltenNegA = Collections.emptyList();
    private long mAnimationTick = 0L;
    private long afterSomeTime;
    private boolean mAnimationDirection = false;
    private GTClientPreference mPreference;
    private boolean mFirstTick = false;
    public static final int ROTATION_MARKER_RESOLUTION = 120;
    private int mReloadCount;
    private float renderTickTime;
    public static MetaGeneratedItemRenderer metaGeneratedItemRenderer;
    private static boolean checkedForChicken;
    public static int hideValue;
    public static int changeDetected;

    public GTClient() {
        this.mCapeRenderer = new GTCapeRenderer(this.mCapeList);
        this.mPosR = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mPosG = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mPosB = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mNegR = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegG = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegB = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mMoltenPosR = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mMoltenPosG = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mMoltenPosB = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mMoltenNegR = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegG = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegB = Collections.singletonList(Materials.InfusedEntropy);
    }

    private static void drawGrid(DrawBlockHighlightEvent aEvent, boolean showCoverConnections, boolean aIsWrench, boolean aIsSneaking) {
        IAlignment tAlignment;
        if (!checkedForChicken) {
            try {
                Class.forName("codechicken.lib.vec.Rotation");
            }
            catch (ClassNotFoundException e) {
                return;
            }
            checkedForChicken = true;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        int program = GL11.glGetInteger((int)35725);
        GL20.glUseProgram((int)0);
        MovingObjectPosition target = aEvent.target;
        EntityPlayer player = aEvent.player;
        double camX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)aEvent.partialTicks;
        double camY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)aEvent.partialTicks;
        double camZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)aEvent.partialTicks;
        GL11.glTranslated((double)(target.field_72311_b - (int)camX), (double)(target.field_72312_c - (int)camY), (double)(target.field_72309_d - (int)camZ));
        GL11.glTranslated((double)(0.5 - (camX - (double)((int)camX))), (double)(0.5 - (camY - (double)((int)camY))), (double)(0.5 - (camZ - (double)((int)camZ))));
        int tSideHit = target.field_72310_e;
        Rotation.sideRotations[tSideHit].glApply();
        GL11.glTranslated((double)0.0, (double)-0.502, (double)0.0);
        GL11.glLineWidth((float)2.5f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
        TileEntity tTile = player.field_70170_p.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        Block block = player.field_70170_p.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        int meta = player.field_70170_p.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        int tConnections = 0;
        if (tTile instanceof ICoverable) {
            BaseMetaTileEntity baseMetaTile;
            ForgeDirection[] iCoverable = (ForgeDirection[])tTile;
            if (showCoverConnections) {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    if (iCoverable.getCoverIDAtSide(tSide) == 0) continue;
                    tConnections |= tSide.flag;
                }
            } else if (tTile instanceof BaseMetaTileEntity && (baseMetaTile = (BaseMetaTileEntity)tTile).getAlignment() == null) {
                if (!aIsSneaking) {
                    tConnections |= baseMetaTile.getFrontFacing().flag;
                } else {
                    IMetaTileEntity iMetaTileEntity = baseMetaTile.getMetaTileEntity();
                    if (iMetaTileEntity instanceof MTEBasicMachine) {
                        MTEBasicMachine basicMachine = (MTEBasicMachine)iMetaTileEntity;
                        tConnections |= basicMachine.mMainFacing.flag;
                    }
                }
            } else if (tTile instanceof BaseMetaPipeEntity) {
                BaseMetaPipeEntity pipeEntity = (BaseMetaPipeEntity)tTile;
                tConnections = pipeEntity.mConnections;
            }
        } else if (tTile instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tTile;
            tConnections |= ForgeDirection.getOrientation((int)wrenchable.getFacing()).flag;
        } else if (ROTATABLE_VANILLA_BLOCKS.contains(block)) {
            tConnections |= ForgeDirection.getOrientation((int)meta).flag;
        } else if (tTile instanceof TileInterface) {
            TileInterface tileInterface = (TileInterface)tTile;
            tConnections |= tileInterface.getUp().getOpposite().flag;
        }
        if (tConnections != 0) {
            block11: for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                if ((tConnections & tSide.flag) == 0) continue;
                switch (GRID_SWITCH_TABLE[target.field_72310_e][tSide.ordinal()]) {
                    case 0: {
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 1: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        continue block11;
                    }
                    case 2: {
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 3: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        continue block11;
                    }
                    case 4: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 5: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                    }
                }
            }
        }
        GL11.glEnd();
        Function<ForgeDirection, Transformation[]> getTransform = direction -> {
            try {
                if (direction.ordinal() == tSideHit) {
                    return new Transformation[]{ROTATION_MARKER_TRANSFORM_CENTER};
                }
                if (direction.getOpposite().ordinal() == tSideHit) {
                    return ROTATION_MARKER_TRANSFORMS_CORNER;
                }
                return new Transformation[]{ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS[ROTATION_MARKER_TRANSFORMS_SIDES[tSideHit * 6 + direction.ordinal()]]};
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return new Transformation[0];
            }
        };
        if (aIsWrench && tTile instanceof IAlignmentProvider && (tAlignment = ((IAlignmentProvider)tTile).getAlignment()) != null) {
            for (Transformation transform : getTransform.apply(tAlignment.getDirection())) {
                GTClient.drawExtendedRotationMarker(transform, aIsSneaking, tAlignment);
            }
        }
        if (aIsWrench && tTile instanceof IOrientable) {
            IOrientable orientable = (IOrientable)tTile;
            if (!(tTile instanceof TileInterface) && orientable.canBeRotated()) {
                for (Transformation transform : getTransform.apply(aIsSneaking ? orientable.getForward() : orientable.getUp())) {
                    GTClient.drawExtendedRotationMarker(transform, aIsSneaking, orientable);
                }
            }
        }
        GL20.glUseProgram((int)program);
        GL11.glPopMatrix();
    }

    private static void drawExtendedRotationMarker(Transformation transform, boolean sneaking, IAlignment alignment) {
        if (sneaking) {
            if (alignment.isFlipChangeAllowed()) {
                GTClient.drawFlipMarker(transform);
            }
        } else if (alignment.isRotationChangeAllowed()) {
            GTClient.drawRotationMarker(transform);
        }
    }

    private static void drawExtendedRotationMarker(Transformation transform, boolean sneaking, IOrientable orientable) {
        GTClient.drawRotationMarker(transform);
    }

    private static void drawRotationMarker(Transformation transform) {
        if (!rotationMarkerDisplayListCompiled) {
            rotationMarkerDisplayList = GLAllocation.func_74526_a((int)1);
            GTClient.compileRotationMarkerDisplayList(rotationMarkerDisplayList);
            rotationMarkerDisplayListCompiled = true;
        }
        GL11.glPushMatrix();
        transform.glApply();
        GL11.glCallList((int)rotationMarkerDisplayList);
        GL11.glPopMatrix();
    }

    private static void compileRotationMarkerDisplayList(int displayList) {
        int i;
        GL11.glNewList((int)displayList, (int)4864);
        GL11.glBegin((int)2);
        for (i = 0; i <= 120; ++i) {
            GL11.glVertex3d((double)(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.4), (double)0.0, (double)(Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.4));
        }
        for (i = 120; i >= 0; --i) {
            GL11.glVertex3d((double)(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.24), (double)0.0, (double)(Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.24));
        }
        GL11.glVertex3d((double)0.1411145618, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.32, (double)0.0, (double)-0.178885438199);
        GL11.glVertex3d((double)0.498885438199, (double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glEndList();
    }

    private static void drawFlipMarker(Transformation transform) {
        GL11.glPushMatrix();
        transform.glApply();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glLineStipple((int)4, (short)-21846);
        GL11.glEnable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(0.1, 0.0, 0.04);
        t.func_78377_a(0.1, 0.0, 0.2);
        t.func_78377_a(0.35, 0.0, 0.35);
        t.func_78377_a(0.35, 0.0, -0.35);
        t.func_78377_a(0.1, 0.0, -0.2);
        t.func_78377_a(0.1, 0.0, -0.04);
        t.func_78381_a();
        GL11.glDisable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(-0.1, 0.0, 0.04);
        t.func_78377_a(-0.1, 0.0, 0.2);
        t.func_78377_a(-0.35, 0.0, 0.35);
        t.func_78377_a(-0.35, 0.0, -0.35);
        t.func_78377_a(-0.1, 0.0, -0.2);
        t.func_78377_a(-0.1, 0.0, -0.04);
        t.func_78381_a();
        t.func_78371_b(2);
        t.func_78377_a(0.15, 0.0, -0.04);
        t.func_78377_a(0.15, 0.0, -0.1);
        t.func_78377_a(0.25, 0.0, 0.0);
        t.func_78377_a(0.15, 0.0, 0.1);
        t.func_78377_a(0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.1);
        t.func_78377_a(-0.25, 0.0, 0.0);
        t.func_78377_a(-0.15, 0.0, -0.1);
        t.func_78377_a(-0.15, 0.0, -0.04);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public boolean isBukkitSide() {
        return false;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public int addArmor(String aPrefix) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)aPrefix);
    }

    @Override
    public void onPreLoad() {
        String[] arr;
        super.onPreLoad();
        MinecraftForge.EVENT_BUS.register((Object)new ExtraIcons());
        Minecraft.func_71410_x().func_110438_M().field_110621_c.func_110504_a((IMetadataSectionSerializer)new ColorsMetadataSectionSerializer(), ColorsMetadataSection.class);
        new MTEAdvDebugStructureWriter.ForgeEventHandler();
        for (String tName : arr = new String[]{"renadi", "hanakocz", "MysteryDump", "Flaver4", "x_Fame", "Peluche321", "Goshen_Ithilien", "manf", "Bimgo", "leagris", "IAmMinecrafter02", "Cerous", "Devilin_Pixy", "Bkarlsson87", "BadAlchemy", "CaballoCraft", "melanclock", "Resursator", "demanzke", "AndrewAmmerlaan", "Deathlycraft", "Jirajha", "Axlegear", "kei_kouma", "Dracion", "dungi", "Dorfschwein", "Zero Tw0", "mattiagraz85", "sebastiank30", "Plem", "invultri", "grillo126", "malcanteth", "Malevolence_", "Nicholas_Manuel", "Sirbab", "kehaan", "bpgames123", "semig0d", "9000bowser", "Sovereignty89", "Kris1432", "xander_cage_", "samuraijp", "bsaa", "SpwnX", "tworf", "Kadah", "kanni", "Stute", "Hegik", "Onlyme", "t3hero", "Hotchi", "jagoly", "Nullav", "BH5432", "Sibmer", "inceee", "foxxx0", "Hartok", "TMSama", "Shlnen", "Carsso", "zessirb", "meep310", "Seldron", "yttr1um", "hohounk", "freebug", "Sylphio", "jmarler", "Saberawr", "r00teniy", "Neonbeta", "yinscape", "voooon24", "Quintine", "peach774", "lepthymo", "bildeman", "Kremnari", "Aerosalo", "OndraSter", "oscares91", "mr10movie", "Daxx367x2", "EGERTRONx", "aka13_404", "Abouttabs", "Johnstaal", "djshiny99", "megatronp", "DZCreeper", "Kane_Hart", "Truculent", "vidplace7", "simon6689", "MomoNasty", "UnknownXLV", "goreacraft", "Fluttermine", "Daddy_Cecil", "MrMaleficus", "TigersFangs", "cublikefoot", "chainman564", "NikitaBuker", "Misha999777", "25FiveDetail", "AntiCivilBoy", "michaelbrady", "xXxIceFirexXx", "Speedynutty68", "GarretSidzaka", "HallowCharm977", "mastermind1919", "The_Hypersonic", "diamondguy2798", "zF4ll3nPr3d4t0r", "CrafterOfMines57", "XxELIT3xSNIP3RxX", "SuterusuKusanagi", "xavier0014", "adamros", "alexbegt"}) {
            this.mCapeList.add(tName.toLowerCase());
        }
        new Thread(this).start();
        mPollutionRenderer.preLoad();
        this.mPreference = new GTClientPreference();
        Materials.initClient();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        GTRendererBlock.register();
        new MultiTileRenderer();
        new DroneRender();
        new LaserRenderer();
        new WormholeRenderer();
        new BlackholeRenderer();
        metaGeneratedItemRenderer = new MetaGeneratedItemRenderer();
        for (MetaGeneratedItem item : MetaGeneratedItem.sInstances.values()) {
            metaGeneratedItemRenderer.registerItem(item);
        }
        if (Mods.Forestry.isModLoaded()) {
            metaGeneratedItemRenderer.registerItem(GTBees.combs);
        }
        new MetaGeneratedToolRenderer();
        new FlaskRenderer();
        new FluidDisplayStackRenderer();
        new DataStickRenderer();
        new InfiniteSprayCanRenderer();
        MinecraftForge.EVENT_BUS.register((Object)new NEIGTConfig());
        MinecraftForge.EVENT_BUS.register((Object)new GTMouseEventHandler());
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager l) {
                GUIColorOverride.onResourceManagerReload();
                FallbackableSteamTexture.reload();
                GregTechAPI.sCoverBehaviors.values().forEach(CoverBehaviorBase::reloadColorOverride);
            }
        });
        Pollution.onPostInitClient();
    }

    @Override
    public void onLoadComplete() {
        super.onLoadComplete();
        for (RecipeCategory category : RecipeCategory.ALL_RECIPE_CATEGORIES.values()) {
            if (!category.recipeMap.getFrontend().getNEIProperties().registerNEI) continue;
            FluidRecipe.addRecipeMap((String)category.unlocalizedName, (IRecipeExtractor)new GregTech5RecipeExtractor(category.unlocalizedName.equals("gt.recipe.scanner") || category.unlocalizedName.equals("gt.recipe.fakeAssemblylineProcess")));
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundSetupEvent event) {
        try {
            SoundSystemConfig.setCodec((String)"gt5oggseek", SeekingOggCodec.class);
        }
        catch (SoundSystemException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        Scanner tScanner;
        GTLog.out.println("GTMod: Downloading Cape List.");
        try {
            tScanner = new Scanner(new URL(GT_CAPE_LIST_URL).openStream());
            try {
                while (tScanner.hasNextLine()) {
                    this.mCapeList.add(tScanner.nextLine().toLowerCase());
                }
            }
            finally {
                tScanner.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GTLog.err);
        }
        GTLog.out.println("GT New Horizons: Downloading Cape List.");
        try {
            tScanner = new Scanner(new URL(GTNH_CAPE_LIST_URL).openStream());
            try {
                while (tScanner.hasNextLine()) {
                    String tName = tScanner.nextLine().toLowerCase();
                    if (tName.contains(":")) {
                        if (this.mCapeList.contains(tName.substring(0, tName.indexOf(":")))) continue;
                        this.mCapeList.add(tName);
                        continue;
                    }
                    this.mCapeList.add(tName);
                }
            }
            finally {
                tScanner.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GTLog.err);
        }
    }

    @Override
    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
        this.mFirstTick = true;
        ++this.mReloadCount;
        GTMusicSystem.ClientSystem.reset();
        GTValues.calculateMaxPlasmaTurbineEfficiency();
    }

    @Override
    public void reloadNEICache() {
        ++this.mReloadCount;
    }

    @Override
    public int getNEIReloadCount() {
        return this.mReloadCount;
    }

    @SubscribeEvent
    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        this.mCapeRenderer.receiveRenderSpecialsEvent(aEvent);
    }

    @SubscribeEvent
    public void onPlayerTickEventClient(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            if (this.mFirstTick) {
                this.mFirstTick = false;
                GTValues.NW.sendToServer(new GTPacketClientPreference(this.mPreference));
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    GTModHandler.removeAllIC2Recipes();
                }
            }
            ++this.afterSomeTime;
            if (this.afterSomeTime >= 100L) {
                this.afterSomeTime = 0L;
            }
            Iterator<Map.Entry<GTPlayedSound, Integer>> iterator = GTUtility.sPlayedSoundMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GTPlayedSound, Integer> tEntry = iterator.next();
                if (tEntry.getValue() < 0) {
                    iterator.remove();
                    continue;
                }
                tEntry.setValue(tEntry.getValue() - 1);
            }
            if (!GregTechAPI.mServerStarted) {
                GregTechAPI.mServerStarted = true;
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (Mods.GregTech.ID.equals(e.modID)) {
            this.mPreference = new GTClientPreference();
            GTPreLoad.loadClientConfig();
            if (e.isWorldRunning) {
                GTValues.NW.sendToServer(new GTPacketClientPreference(this.mPreference));
            }
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent aEvent) {
        IGregTechTileEntity gtEntity;
        Block aBlock = aEvent.player.field_70170_p.func_147439_a(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        TileEntity aTileEntity = aEvent.player.field_70170_p.func_147438_o(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        if (GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sWrenchList)) {
            IOrientable orientable;
            if (aTileEntity instanceof ITurnable || ROTATABLE_VANILLA_BLOCKS.contains(aBlock) || aTileEntity instanceof IWrenchable || aTileEntity instanceof IOrientable && (orientable = (IOrientable)aTileEntity).canBeRotated() || aBlock instanceof BlockFrameBox) {
                GTClient.drawGrid(aEvent, false, true, aEvent.player.func_70093_af());
            }
            return;
        }
        if (aTileEntity == null && aBlock instanceof BlockFrameBox) {
            if (GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sCovers.keySet())) {
                GTClient.drawGrid(aEvent, true, false, aEvent.player.func_70093_af());
            }
            return;
        }
        if (!(aTileEntity instanceof ICoverable)) {
            return;
        }
        if (aEvent.player.func_70093_af() && aTileEntity instanceof IGregTechTileEntity && (gtEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity() instanceof MetaPipeEntity && aEvent.currentItem != null && aEvent.currentItem.func_77973_b() instanceof ItemMachines && GregTechAPI.METATILEENTITIES[aEvent.currentItem.func_77960_j()] instanceof MetaPipeEntity) {
            GTClient.drawGrid(aEvent, false, false, false);
        }
        if (GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sWireCutterList) || GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sSolderingToolList) || GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sSoftHammerList) && aTileEntity instanceof MultiBlockPart && aEvent.player.func_70093_af()) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
                GTClient.drawGrid(aEvent, false, false, aEvent.player.func_70093_af());
            }
            return;
        }
        if (aEvent.currentItem == null && aEvent.player.func_70093_af() || GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sCrowbarList) || GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sScrewdriverList)) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    if (((ICoverable)aTileEntity).getCoverIDAtSide(tSide) <= 0) continue;
                    GTClient.drawGrid(aEvent, true, false, true);
                    return;
                }
            }
            return;
        }
        if (GTUtility.isStackInList(aEvent.currentItem, GregTechAPI.sCovers.keySet()) && ((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
            GTClient.drawGrid(aEvent, true, false, aEvent.player.func_70093_af());
        }
        if (GTUtility.areStacksEqual(ItemList.Tool_Cover_Copy_Paste.get(1L, new Object[0]), aEvent.currentItem, true) && ((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
            GTClient.drawGrid(aEvent, true, false, aEvent.player.func_70093_af());
        }
    }

    @SubscribeEvent
    public void receiveRenderEvent(RenderPlayerEvent.Pre aEvent) {
        if (GTUtility.getFullInvisibility(aEvent.entityPlayer)) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderStart(TickEvent.RenderTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.START) {
            this.renderTickTime = aEvent.renderTickTime;
        }
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.END) {
            int newHideValue;
            GTMusicSystem.ClientSystem.tick();
            if (changeDetected > 0) {
                --changeDetected;
            }
            if ((newHideValue = GTClient.shouldHeldItemHideThings()) != hideValue) {
                hideValue = newHideValue;
                changeDetected = 5;
            }
            ++this.mAnimationTick;
            if (this.mAnimationTick % 50L == 0L) {
                this.mAnimationDirection = !this.mAnimationDirection;
            }
            int tDirection = this.mAnimationDirection ? 1 : -1;
            for (Materials tMaterial : this.mPosR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mPosG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mPosB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mPosA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mNegR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mNegG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mNegB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mNegA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], -tDirection);
            }
        }
    }

    public short getSafeRGBValue(short aRBG, int aDelta) {
        int tmp = aRBG + aDelta;
        if (tmp > 255) {
            tmp = 255;
        }
        if (tmp < 0) {
            tmp = 0;
        }
        return (short)tmp;
    }

    @Override
    public long getAnimationTicks() {
        return this.mAnimationTick;
    }

    @Override
    public float getPartialRenderTicks() {
        return this.renderTickTime;
    }

    @Override
    public void doSonictronSound(ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (GTUtility.isStackInvalid(aStack)) {
            return;
        }
        String tString = SoundResource.NOTE_HARP.toString();
        int j = this.mSoundItems.size();
        for (int i = 0; i < j; ++i) {
            if (!GTUtility.areStacksEqual((ItemStack)this.mSoundItems.get(i), aStack)) continue;
            tString = (String)this.mSoundNames.get(i);
            break;
        }
        if (tString.startsWith(SoundResource.RANDOM_EXPLODE.toString())) {
            if (aStack.field_77994_a == 3) {
                tString = SoundResource.RANDOM_FUSE.toString();
            } else if (aStack.field_77994_a == 2) {
                tString = "random.old_explode";
            }
        }
        if (tString.startsWith("streaming.")) {
            switch (aStack.field_77994_a) {
                case 1: {
                    String string = tString + "13";
                    break;
                }
                case 2: {
                    String string = tString + "cat";
                    break;
                }
                case 3: {
                    String string = tString + "blocks";
                    break;
                }
                case 4: {
                    String string = tString + "chirp";
                    break;
                }
                case 5: {
                    String string = tString + "far";
                    break;
                }
                case 6: {
                    String string = tString + "mall";
                    break;
                }
                case 7: {
                    String string = tString + "mellohi";
                    break;
                }
                case 8: {
                    String string = tString + "stal";
                    break;
                }
                case 9: {
                    String string = tString + "strad";
                    break;
                }
                case 10: {
                    String string = tString + "ward";
                    break;
                }
                case 11: {
                    String string = tString + "11";
                    break;
                }
                case 12: {
                    String string = tString + "wait";
                    break;
                }
                default: {
                    String string = tString = tString + "wherearewenow";
                }
            }
        }
        if (tString.startsWith("streaming.")) {
            new WorldSpawnedEventBuilder.RecordEffectEventBuilder().setIdentifier(tString.substring(10)).setPosition(aX, aY, aZ).run();
        } else {
            new WorldSpawnedEventBuilder.SoundEventBuilder().setVolume(3.0f).setPitch(tString.startsWith("note.") ? (float)Math.pow(2.0, (double)(aStack.field_77994_a - 13) / 12.0) : 1.0f).setIdentifier(tString).setPosition(aX, aY, aZ).run();
        }
    }

    private static int shouldHeldItemHideThings() {
        try {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return 0;
            }
            ItemStack tCurrentItem = player.func_71045_bC();
            if (tCurrentItem == null) {
                return 0;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)tCurrentItem);
            int hide = 0;
            for (int i : ids) {
                if (!OreDictionary.getOreName((int)i).equals("craftingToolSolderingIron")) continue;
                hide |= 1;
                break;
            }
            if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sWrenchList) || GTUtility.isStackInList(tCurrentItem, GregTechAPI.sHardHammerList) || GTUtility.isStackInList(tCurrentItem, GregTechAPI.sSoftHammerList) || GTUtility.isStackInList(tCurrentItem, GregTechAPI.sWireCutterList) || GTUtility.isStackInList(tCurrentItem, GregTechAPI.sSolderingToolList) || GTUtility.isStackInList(tCurrentItem, GregTechAPI.sCrowbarList) || GregTechAPI.sCovers.containsKey(new GTItemStack(tCurrentItem)) || tCurrentItem.func_77973_b() instanceof ItemMachines && GregTechAPI.METATILEENTITIES[tCurrentItem.func_77960_j()] instanceof MetaPipeEntity && player.func_70093_af()) {
                hide |= 2;
            }
            return hide;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void recieveChunkPollutionPacket(ChunkCoordIntPair chunk, int pollution) {
        mPollutionRenderer.processPacket(chunk, pollution);
    }

    static {
        GRID_SWITCH_TABLE = new int[][]{{0, 5, 3, 1, 2, 4}, {5, 0, 1, 3, 2, 4}, {1, 3, 0, 5, 2, 4}, {3, 1, 5, 0, 2, 4}, {4, 2, 3, 1, 0, 5}, {2, 4, 3, 1, 5, 0}};
        ROTATION_MARKER_TRANSFORM_CENTER = new Scale(0.5);
        ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.0)).compile(), new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.0)).compile()};
        ROTATION_MARKER_TRANSFORMS_SIDES = new int[]{-1, -1, 2, 0, 3, 1, -1, -1, 0, 2, 3, 1, 0, 2, -1, -1, 3, 1, 2, 0, -1, -1, 3, 1, 1, 3, 2, 0, -1, -1, 3, 1, 2, 0, -1, -1};
        ROTATION_MARKER_TRANSFORMS_CORNER = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, -0.375)).compile()};
        rotationMarkerDisplayListCompiled = false;
        ROTATABLE_VANILLA_BLOCKS = Arrays.asList(Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150409_cd, Blocks.field_150367_z, Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_150477_bB, Blocks.field_150438_bZ, Blocks.field_150423_aK, Blocks.field_150428_aP);
        mPollutionRenderer = new PollutionRenderer();
        checkedForChicken = false;
        hideValue = 0;
        changeDetected = 0;
    }
}

