/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class CoverRedstoneWirelessBase
extends CoverBehavior {
    private static final int MAX_CHANNEL = 65535;
    private static final int PRIVATE_MASK = -131072;
    private static final int PUBLIC_MASK = 65535;
    private static final int CHECKBOX_MASK = 65536;

    public CoverRedstoneWirelessBase(ITexture coverTexture) {
        super(coverTexture);
    }

    @Override
    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        GregTechAPI.sWirelessRedstone.put(aCoverVariable, (byte)0);
        return true;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || side.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTechAPI.sWirelessRedstone.put(aCoverVariable.get(), (byte)0);
            aCoverVariable.set(aCoverVariable.get() & 0xFFFF0000 | Integer.valueOf(GTUtility.stackToInt(aPlayer.field_71071_by.func_70448_g())).hashCode() & 0xFFFF);
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("081", "Frequency: ") + aCoverVariable);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCoverRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || side.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625) {
            GregTechAPI.sWirelessRedstone.put(aCoverVariable, (byte)0);
            int val = GTUtility.stackToInt(aPlayer.field_71071_by.func_70448_g()) * (1 + aPlayer.field_71071_by.func_70448_g().func_77960_j());
            aCoverVariable = aCoverVariable & 0xFFFF0000 | val & 0xFFFF;
            aTileEntity.setCoverDataAtSide(side, aCoverVariable);
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("081", "Frequency: ") + (aCoverVariable & 0xFFFF));
            return true;
        }
        return false;
    }

    @Override
    protected boolean isGUIClickableImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((double)aX > 0.375 && (double)aX < 0.625 || side.offsetX == 0 || (double)aY > 0.375 && (double)aY < 0.625 || (double)aZ <= 0.375 || (double)aZ >= 0.625) {
            int n;
            GregTechAPI.sWirelessRedstone.put(aCoverVariable, (byte)0);
            float[] tCoords = GTUtility.getClickedFacingCoords(side, aX, aY, aZ);
            switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                case 0: {
                    n = -32;
                    break;
                }
                case 1: {
                    n = 32;
                    break;
                }
                case 2: {
                    n = -1024;
                    break;
                }
                case 3: {
                    n = 1024;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            int tAdjustVal = n;
            int tPublicChannel = (aCoverVariable & 0xFFFF) + tAdjustVal;
            aCoverVariable = tPublicChannel < 0 ? (aCoverVariable &= 0xFFFF0000) : (tPublicChannel > 65535 ? aCoverVariable & 0xFFFF0000 | 0xFFFF : aCoverVariable & 0xFFFF0000 | tPublicChannel);
        }
        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("081", "Frequency: ") + (aCoverVariable & 0xFFFF));
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public String getDescription(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return GTUtility.trans("081", "Frequency: ") + aCoverVariable;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new RedstoneWirelessBaseUIFactory(buildContext).createWindow();
    }

    private class RedstoneWirelessBaseUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public RedstoneWirelessBaseUIFactory(CoverUIBuildContext buildContext) {
            super(CoverRedstoneWirelessBase.this, buildContext);
        }

        @Override
        protected int getGUIWidth() {
            return 250;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)new CoverDataControllerWidget<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverRedstoneWirelessBase.this).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> this.getFlagFrequency(CoverRedstoneWirelessBase.convert(coverData)), (coverData, state) -> new ISerializableObject.LegacyCoverData(state.intValue() | this.getFlagCheckbox(CoverRedstoneWirelessBase.convert(coverData))), widget -> widget.setBounds(0.0, 65535.0).setScrollValues(1.0, 1000.0, 10.0).setFocusOnGuiOpen(true).setPos(0, 2).setSize(69, 12))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofCheck(), coverData -> this.getFlagCheckbox(CoverRedstoneWirelessBase.convert(coverData)) > 0, (coverData, state) -> new ISerializableObject.LegacyCoverData(this.getFlagFrequency(CoverRedstoneWirelessBase.convert(coverData)) | (state != false ? 65536 : 0)), widget -> widget.setPos(0, 36)).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("246", "Frequency")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(82, 29))).widget(new TextWidget(GTUtility.trans("602", "Use Private Frequency")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 65));
        }

        private int getFlagFrequency(int coverVariable) {
            return coverVariable & 0xFFFF;
        }

        private int getFlagCheckbox(int coverVariable) {
            return coverVariable & 0x10000;
        }
    }
}

