/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.ColoredBlockContainer;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Other;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourSprayColor
extends BehaviourNone {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final byte mColor;
    protected String mTooltip;
    private final String mTooltipUses = GTLanguageManager.addStringLocalization("gt.behaviour.paintspray.uses", "Remaining Uses:");
    private final String mTooltipUnstackable = GTLanguageManager.addStringLocalization("gt.behaviour.unstackable", "Not usable when stacked!");
    protected final String mTooltipChain = GTLanguageManager.addStringLocalization("gt.behaviour.paintspray.chain", "If used while sneaking it will spray a chain of blocks");
    protected final String mTooltipChainAmount = GTLanguageManager.addStringLocalization("gt.behaviour.paintspray.chain_amount", "Sprays up to %d blocks, in the direction you're looking at");

    public BehaviourSprayColor(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses, int aColor) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses;
        this.mColor = (byte)aColor;
        this.mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.paintspray." + this.mColor + ".tooltip", "Can Color things in " + Dyes.get((int)this.mColor).mName);
    }

    public BehaviourSprayColor(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses;
        this.mColor = 0;
        this.mTooltip = "";
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        if (ColoredBlockContainer.getInstance(aWorld, aX, aY, aZ, side, aPlayer).isValid()) {
            return this.onItemUseFirst(aItem, aStack, aPlayer, aWorld, aX, aY, aZ, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K || aStack.field_77994_a != 1) {
            return false;
        }
        boolean rOutput = false;
        if (!aPlayer.func_82247_a(aX, aY, aZ, side.ordinal(), aStack)) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        long tUses = this.getUses(aStack, tNBT);
        int painted = 0;
        int maxPainted = Other.sprayCanChainRange;
        Vec3 look = aPlayer.func_70040_Z();
        double absX = Math.abs(look.field_72450_a);
        double absY = Math.abs(look.field_72448_b);
        double absZ = Math.abs(look.field_72449_c);
        ForgeDirection lookSide = absX > absY && absX > absZ ? (look.field_72450_a > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (absY > absX && absY > absZ ? (look.field_72448_b > 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN) : (look.field_72449_c > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH));
        Block initialBlock = aWorld.func_147439_a(aX, aY, aZ);
        int initialBlockMeta = aWorld.func_72805_g(aX, aY, aZ);
        TileEntity initialTE = aWorld.func_147438_o(aX, aY, aZ);
        while (GTUtility.areStacksEqual(aStack, this.mUsed, true) && this.colorize(aWorld, aX, aY, aZ, side, aPlayer)) {
            TileEntity targetTE;
            GTUtility.sendSoundToPlayers(aWorld, SoundResource.IC2_TOOLS_PAINTER, 1.0f, 1.0f, aX, aY, aZ);
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                --tUses;
            }
            rOutput = true;
            if (++painted >= maxPainted && maxPainted != -1 || !aPlayer.func_70093_af() || tUses <= 0L) break;
            switch (lookSide) {
                case UP: {
                    ++aY;
                    break;
                }
                case DOWN: {
                    --aY;
                    break;
                }
                case NORTH: {
                    --aZ;
                    break;
                }
                case SOUTH: {
                    ++aZ;
                    break;
                }
                case WEST: {
                    --aX;
                    break;
                }
                case EAST: {
                    ++aX;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + lookSide);
                }
            }
            if (aWorld.func_147439_a(aX, aY, aZ) != initialBlock || aWorld.func_72805_g(aX, aY, aZ) != initialBlockMeta || initialTE == null ^ (targetTE = aWorld.func_147438_o(aX, aY, aZ)) == null) break;
            if (initialTE == null || targetTE == null) continue;
            if (!initialTE.getClass().isInstance(targetTE)) break;
            if (!(initialTE instanceof IGregTechTileEntity)) continue;
            IGregTechTileEntity currentGTTile = (IGregTechTileEntity)initialTE;
            if (!(targetTE instanceof IGregTechTileEntity)) continue;
            IGregTechTileEntity targetGTTile = (IGregTechTileEntity)targetTE;
            if (currentGTTile.getMetaTileID() == targetGTTile.getMetaTileID()) continue;
            break;
        }
        this.setRemainingUses(aStack, tNBT, tUses);
        return rOutput;
    }

    @Override
    public boolean shouldInterruptBlockActivation(EntityPlayer player, TileEntity tileEntity, ForgeDirection side) {
        return ColoredBlockContainer.getInstance(player, tileEntity, side).isValid();
    }

    protected long getUses(ItemStack aStack, NBTTagCompound tNBT) {
        long tUses = tNBT.func_74763_f("GT.RemainingPaint");
        if (GTUtility.areStacksEqual(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mUsed));
            tUses = this.mUses;
        }
        return tUses;
    }

    protected void setRemainingUses(ItemStack aStack, NBTTagCompound tNBT, long tUses) {
        tNBT.func_82580_o("GT.RemainingPaint");
        if (tUses > 0L) {
            tNBT.func_74772_a("GT.RemainingPaint", tUses);
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        if (tUses <= 0L) {
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(this.mEmpty));
            }
        }
    }

    protected boolean colorize(World aWorld, int aX, int aY, int aZ, ForgeDirection side, EntityPlayer player) {
        return ColoredBlockContainer.getInstance(aWorld, aX, aY, aZ, side, player).setColor(this.getColor());
    }

    protected byte getColor() {
        return this.mColor;
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        aList.add(this.mTooltipChain);
        aList.add(String.format(this.mTooltipChainAmount, Other.sprayCanChainRange));
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemainingPaint = tNBT == null ? this.mUses : (GTUtility.areStacksEqual(aStack, this.mFull, true) ? this.mUses : tNBT.func_74763_f("GT.RemainingPaint"));
        aList.add(this.mTooltipUses + " " + tRemainingPaint);
        aList.add(this.mTooltipUnstackable);
        return aList;
    }
}

