/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEDistillationTower
extends MTEEnhancedMultiBlockBase<MTEDistillationTower>
implements ISurvivalConstructable {
    protected static final int CASING_INDEX = 49;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    private static final IStructureDefinition<MTEDistillationTower> STRUCTURE_DEFINITION;
    protected final List<List<MTEHatchOutput>> mOutputHatchesByLayer = new ArrayList<List<MTEHatchOutput>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;

    public MTEDistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEDistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDistillationTower(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Distillery, DT").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").beginVariableStructureBlock(3, 3, 3, 12, 3, 3, true).addController("Front bottom").addOtherStructurePart("Clean Stainless Steel Machine Casing", "7 x h - 5 (minimum)").addEnergyHatch("Any casing except top centre", 1, 2).addMaintenanceHatch("Any casing", 1, 2, 3).addInputHatch("Any bottom layer casing", 1).addOutputBus("Any bottom layer casing", 1).addOutputHatch("2-11x Output Hatches (At least one per layer except bottom layer)", 2, 3).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.distillationTowerRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic();
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onTopLayerFound(boolean aIsCasing) {
        this.mTopLayerFound = true;
        if (aIsCasing) {
            this.onCasingFound();
        }
    }

    protected int getCurrentLayerOutputHatchCount() {
        return this.mOutputHatchesByLayer.size() < this.mHeight || this.mHeight <= 0 ? 0 : this.mOutputHatchesByLayer.get(this.mHeight - 1).size();
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchOutput tHatch;
        IMetaTileEntity iMetaTileEntity;
        if (aTileEntity != null && !aTileEntity.isDead() && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchOutput) {
            tHatch = (MTEHatchOutput)iMetaTileEntity;
        } else {
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch);
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return this.getFluidOutputSlotsByLayer(toOutput, this.mOutputHatchesByLayer);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public boolean isRotationChangeAllowed() {
        return false;
    }

    @Override
    public IStructureDefinition<MTEDistillationTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12) {
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0)) {
                return false;
            }
            if (this.mOutputHatchesByLayer.size() < this.mHeight || this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                return false;
            }
            if (this.mTopLayerFound) break;
            ++this.mHeight;
        }
        return this.mCasing >= 7 * (this.mHeight + 1) - 5 && this.mHeight + 1 >= 3 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    protected void addFluidOutputs(FluidStack[] outputFluids) {
        for (int i = 0; i < outputFluids.length && i < this.mOutputHatchesByLayer.size(); ++i) {
            FluidStack fluidStack = outputFluids[i];
            if (fluidStack == null) continue;
            FluidStack tStack = fluidStack.copy();
            if (MTEDistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, true)) continue;
            MTEDistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, false);
        }
    }

    @Override
    public boolean canDumpFluidToME() {
        return this.mOutputHatchesByLayer.stream().allMatch(tLayerOutputHatches -> tLayerOutputHatches.stream().anyMatch(tHatch -> {
            MTEHatchOutputME tMEHatch;
            return tHatch instanceof MTEHatchOutputME && (tMEHatch = (MTEHatchOutputME)tHatch).canAcceptFluid();
        }));
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.mHeight = 0;
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 1, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalHeight = Math.min(12, stackSize.field_77994_a + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.mHeight = i;
            built = this.survivialBuildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, 1, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        this.mHeight = tTotalHeight - 1;
        return this.survivialBuildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, 1, tTotalHeight - 1, 0, elementBudget, env, false, true);
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GT_MACHINES_DISTILLERY_LOOP;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    static {
        IHatchElement<MTEDistillationTower> layeredOutputHatch = HatchElement.OutputHatch.withCount(MTEDistillationTower::getCurrentLayerOutputHatchCount).withAdder(MTEDistillationTower::addLayerOutputHatch);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape(STRUCTURE_PIECE_LAYER, StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape(STRUCTURE_PIECE_LAYER_HINT, StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape(STRUCTURE_PIECE_TOP_HINT, StructureUtility.transpose((String[][])new String[][]{{"LLL", "LLL", "LLL"}})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEDistillationTower.class).atLeast(HatchElement.Energy, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.Maintenance).casingIndex(49).dot(1).build(), StructureUtility.onElementPass(MTEDistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEDistillationTower.class).atLeast(layeredOutputHatch).casingIndex(49).dot(2).disallowOnly(ForgeDirection.UP, ForgeDirection.DOWN).build(), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, 49, 2), GTStructureUtility.ofHatchAdder(MTEDistillationTower::addLayerOutputHatch, 49, 2), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 49, 2), StructureUtility.onElementPass(MTEDistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).addElement('L', GTStructureUtility.buildHatchAdder(MTEDistillationTower.class).atLeast(layeredOutputHatch).casingIndex(49).dot(2).disallowOnly(ForgeDirection.UP).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 49, 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 49, 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(true), (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)), StructureUtility.isAir()})).build();
    }
}

