/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.base.StackableModularController;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GT_StructureUtilityMuTE;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multiblock.logic.LayeredCokeBatteryProcessingLogic;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LayeredCokeBattery
extends StackableModularController<LayeredCokeBattery, LayeredCokeBatteryProcessingLogic> {
    private static IStructureDefinition<LayeredCokeBattery> STRUCTURE_DEFINITION_MEGA = null;
    protected static final String STRUCTURE_PIECE_BASE = "T1";
    private static final Vec3Impl STRUCTURE_OFFSET_BASE = new Vec3Impl(2, 2, 0);
    private static final Vec3Impl STRUCTURE_OFFSET_MEGA_POSITION = new Vec3Impl(4, 7, -4);
    private static final Vec3Impl STRUCTURE_OFFSET_MEGA_START = new Vec3Impl(0, 0, -3);
    private static final Vec3Impl STRUCTURE_OFFSET_MEGA_STACK = new Vec3Impl(0, 0, -2);
    private static final Vec3Impl STRUCTURE_OFFSET_MEGA_STOP = new Vec3Impl(0, 0, -1);

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.layeredcokebattery";
    }

    @Override
    public String getLocalName() {
        return "Layered Coke Battery";
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return STRUCTURE_OFFSET_BASE;
    }

    @Override
    public GT_StructureUtilityMuTE.UpgradeCasings getBaseMucType() {
        return GT_StructureUtilityMuTE.UpgradeCasings.Heater;
    }

    @Override
    public int getParallelFactor() {
        return 2;
    }

    @Override
    public void construct(ItemStack trigger, boolean hintsOnly) {
        int blueprintCount = trigger.field_77994_a - 1 + this.getMinStacks();
        int stackCount = Math.min(blueprintCount, this.getMaxStacks());
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(STRUCTURE_PIECE_BASE, trigger, hintsOnly, this.buildState.getCurrentOffset());
        this.buildState.addOffset(this.getMegaPositionOffset());
        if (stackCount >= 1) {
            this.buildPiece(STACKABLE_START, trigger, hintsOnly, this.buildState.getCurrentOffset());
            this.buildState.addOffset(this.getStartingStackOffset());
            for (int i = 0; i < stackCount; ++i) {
                this.buildPiece(STACKABLE_MIDDLE, trigger, hintsOnly, this.buildState.getCurrentOffset());
                this.buildState.addOffset(this.getPerStackOffset());
            }
            if (this.hasTop()) {
                this.buildPiece(STACKABLE_STOP, trigger, hintsOnly, this.buildState.getCurrentOffset());
            }
        }
        this.buildState.stopBuilding();
    }

    @Override
    public IStructureDefinition<LayeredCokeBattery> getStructureDefinition() {
        if (STRUCTURE_DEFINITION_MEGA == null) {
            STRUCTURE_DEFINITION_MEGA = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{" AAA ", "AAAAA", "AEEEP", "AAAAA"}, {" AAA ", "A   A", "A   A", "AAAAA"}, {" A~A ", "A   A", "A   A", "AAAAA"}, {" AAA ", "A   A", "A   A", "AAAAA"}, {" AAA ", "AAAAA", "AAAAA", "AAAAA"}})).addShape(STACKABLE_STOP, StructureUtility.transpose((String[][])new String[][]{{"AHFFFFAFFFFHA", "AAAAAAAAAAAAA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {"HB B B B B BH", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {"HB B B B B BH", "AFAFAFAFAFAFA"}, {" B B B B B B ", "AFAFAFAFAFAFA"}, {"AAAAAAAAAAAAA", "AAAAAAAAAAAAA"}})).addShape(STACKABLE_MIDDLE, StructureUtility.transpose((String[][])new String[][]{{"AHFFFFAFFFFHA", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {"HB    A    BH", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {"HB    A    BH", "AAAAAAAAAAAAA"}, {" B    A    B ", "AAAAAAAAAAAAA"}, {"AAAAAAAAAAAAA", "AAAAAAAAAAAAA"}})).addShape(STACKABLE_START, StructureUtility.transpose((String[][])new String[][]{{"AAAAAAAAAAAAA", "AHFFFFAFFFFHA", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", "HB B B B B BH", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", "HB B B B B BH", "AAAAAAAAAAAAA"}, {"AFAFAFAFAFAFA", " B B B B B B ", "AAAAAAAAAAAAA"}, {"AAAAAAAAAAAAA", "AAAAAAAAAAAAA", "AAAAAAAAAAAAA"}})).addElement('A', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.Chemical.getCasing())).addElement('B', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT | MultiBlockPart.ENERGY_IN, GT_MultiTileCasing.Distillation.getCasing())).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('D', GTStructureUtility.ofFrame(Materials.Steel)).addElement('E', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.MOTOR_CASINGS)).addElement('F', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlockUnlocalizedName((String)Mods.IndustrialCraft2.ID, (String)"blockAlloyGlass", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.BartWorks.ID, (String)"BW_GlasBlocks2", (int)0, (boolean)true), StructureUtility.ofBlockUnlocalizedName((String)Mods.Thaumcraft.ID, (String)"blockCosmeticOpaque", (int)2, (boolean)false)})).addElement('H', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.HEATER_CASINGS, GT_StructureUtilityMuTE.INSULATOR_CASINGS)).addElement('P', GT_StructureUtilityMuTE.ofMuTECasings(0, GT_StructureUtilityMuTE.AMPERAGE_CASINGS)).build();
        }
        return STRUCTURE_DEFINITION_MEGA;
    }

    @Override
    public boolean checkMachine() {
        this.stackCount = 0;
        this.resetMucCount();
        this.buildState.startBuilding(this.getStartingStructureOffset());
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getMegaPositionOffset());
        if (!this.checkPiece(STACKABLE_START, this.buildState.getCurrentOffset())) {
            return this.buildState.failBuilding();
        }
        this.buildState.addOffset(this.getStartingStackOffset());
        for (int i = 0; i < this.getMaxStacks() && this.checkPiece(this.getStackableMiddle(i), this.buildState.getCurrentOffset()); ++i) {
            this.buildState.addOffset(this.getPerStackOffset());
            ++this.stackCount;
        }
        if (this.stackCount < this.getMinStacks()) {
            return this.buildState.failBuilding();
        }
        if (!this.checkPiece(this.getStackableStop(), this.buildState.stopBuilding())) {
            return this.buildState.failBuilding();
        }
        this.calculateTier();
        if (!this.calculateMucMultipliers()) {
            return false;
        }
        this.calculateParallels();
        this.updatePowerLogic();
        return this.tier > 0;
    }

    @Override
    protected boolean calculateMucMultipliers() {
        int totalInsulatorCount;
        Map<GT_StructureUtilityMuTE.UpgradeCasings, int[]> mucMap = this.getMucMap();
        int[] heaterList = mucMap.get((Object)GT_StructureUtilityMuTE.UpgradeCasings.Heater);
        int[] insulatorList = mucMap.get((Object)GT_StructureUtilityMuTE.UpgradeCasings.Insulator);
        int totalHeaterCount = Arrays.stream(heaterList).sum();
        if (totalHeaterCount + (totalInsulatorCount = Arrays.stream(insulatorList).sum()) < this.stackCount || totalInsulatorCount > totalHeaterCount) {
            return false;
        }
        if (totalInsulatorCount > 0) {
            this.euTickMultiplier = 1.0 / (double)totalInsulatorCount;
        }
        return true;
    }

    @Override
    public short getCasingRegistryID() {
        return 0;
    }

    @Override
    public int getCasingMeta() {
        return GT_MultiTileCasing.Distillation.getId();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Coke Oven").beginVariableStructureBlock(7, 9, 2 + this.getMinStacks(), 2 + this.getMaxStacks(), 7, 9, true).addController("Bottom Front Center").addCasingInfoExactly("Test Casing", 60, false).addEnergyHatch("Any bottom layer casing").addInputHatch("Any non-optional external facing casing on the stacks").addInputBus("Any non-optional external facing casing on the stacks").addOutputHatch("Any non-optional external facing casing on the stacks").addOutputBus("Any non-optional external facing casing on the stacks").addStructureInfo(String.format("Stackable middle stacks between %d-%d time(s).", this.getMinStacks(), this.getMaxStacks())).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public int getMinStacks() {
        return 0;
    }

    @Override
    public int getMaxStacks() {
        return 20;
    }

    public Vec3Impl getMegaPositionOffset() {
        return STRUCTURE_OFFSET_MEGA_POSITION;
    }

    @Override
    public Vec3Impl getStartingStackOffset() {
        return STRUCTURE_OFFSET_MEGA_START;
    }

    @Override
    public Vec3Impl getPerStackOffset() {
        return STRUCTURE_OFFSET_MEGA_STACK;
    }

    @Override
    public Vec3Impl getAfterLastStackOffset() {
        return STRUCTURE_OFFSET_MEGA_STOP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP.resourceLocation;
    }

    @Override
    @Nonnull
    protected LayeredCokeBatteryProcessingLogic createProcessingLogic() {
        return new LayeredCokeBatteryProcessingLogic();
    }
}

