/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.metatileentity.implementations.MTEFluid;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverOverflowValve
extends CoverBehaviorBase<OverflowValveData> {
    private final int minOverflowPoint = 0;
    private final int maxOverflowPoint;

    public CoverOverflowValve(int maxOverflowPoint) {
        super(OverflowValveData.class);
        this.maxOverflowPoint = maxOverflowPoint;
    }

    @Override
    public OverflowValveData createDataObject() {
        return new OverflowValveData(this.maxOverflowPoint, this.maxOverflowPoint / 10, true, true);
    }

    @Override
    public OverflowValveData createDataObject(int aLegacyData) {
        return new OverflowValveData(aLegacyData, this.maxOverflowPoint / 10, false, true);
    }

    private FluidStack doOverflowThing(FluidStack fluid, OverflowValveData data) {
        if (fluid != null && fluid.amount > data.overflowPoint) {
            fluid.amount = Math.max(fluid.amount - data.voidingRate, data.overflowPoint);
        }
        return fluid;
    }

    private void doOverflowThings(FluidStack[] fluids, OverflowValveData data) {
        for (FluidStack fluid : fluids) {
            this.doOverflowThing(fluid, data);
        }
    }

    @Override
    protected OverflowValveData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, OverflowValveData data, ICoverable aTileEntity, long aTimer) {
        if (data == null) {
            return new OverflowValveData(this.maxOverflowPoint, this.maxOverflowPoint / 10, true, true);
        }
        if (data.overflowPoint == 0 || data.voidingRate == 0) {
            return data;
        }
        if (aTileEntity instanceof CommonMetaTileEntity) {
            MTEFluid fluidPipe;
            CommonMetaTileEntity common = (CommonMetaTileEntity)aTileEntity;
            IMetaTileEntity tile = common.getMetaTileEntity();
            if (tile instanceof MTEBasicTank) {
                MTEBasicTank fluidTank = (MTEBasicTank)tile;
                fluidTank.setDrainableStack(this.doOverflowThing(fluidTank.getDrainableStack(), data));
                return data;
            }
            if (tile instanceof MTEFluid && (fluidPipe = (MTEFluid)tile).isConnectedAtSide(side)) {
                this.doOverflowThings(fluidPipe.mFluids, data);
                return data;
            }
        }
        return data;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, OverflowValveData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, OverflowValveData data, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, OverflowValveData data, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, OverflowValveData data, Fluid aFluid, ICoverable aTileEntity) {
        return data.canFluidOutput;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, OverflowValveData data, Fluid aFluid, ICoverable aTileEntity) {
        return data.canFluidInput;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected OverflowValveData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GTUtility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f) {
            data.overflowPoint += (int)((float)this.maxOverflowPoint * (aPlayer.func_70093_af() ? 0.1f : 0.01f));
        } else {
            data.overflowPoint -= (int)((float)this.maxOverflowPoint * (aPlayer.func_70093_af() ? 0.1f : 0.01f));
        }
        if (data.overflowPoint > this.maxOverflowPoint) {
            data.overflowPoint = 0;
        }
        if (data.overflowPoint <= 0) {
            data.overflowPoint = this.maxOverflowPoint;
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GTPP.chat.text.cover_overflow_valve_overflow_point", (Object[])new Object[]{data.overflowPoint}));
        return data;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, OverflowValveData data, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int amount;
        int n = amount = aPlayer.func_70093_af() ? 128 : 8;
        if (GTUtility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f) {
            data.overflowPoint += amount;
        } else {
            data.overflowPoint -= amount;
        }
        if (data.overflowPoint > this.maxOverflowPoint) {
            data.overflowPoint = 0;
        }
        if (data.overflowPoint <= 0) {
            data.overflowPoint = this.maxOverflowPoint;
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GTPP.chat.text.cover_overflow_valve_overflow_point", (Object[])new Object[]{data.overflowPoint}));
        aTileEntity.setCoverDataAtSide(side, data);
        return true;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new OverflowUIFactory(buildContext).createWindow();
    }

    public static class OverflowValveData
    implements ISerializableObject {
        private int overflowPoint;
        private int voidingRate;
        private boolean canFluidInput;
        private boolean canFluidOutput;

        public OverflowValveData(int overflowPoint, int voidingRate, boolean canFluidInput, boolean canFluidOutput) {
            this.overflowPoint = overflowPoint;
            this.voidingRate = voidingRate;
            this.canFluidInput = canFluidInput;
            this.canFluidOutput = canFluidOutput;
        }

        @Override
        @NotNull
        public ISerializableObject copy() {
            return new OverflowValveData(this.overflowPoint, this.voidingRate, this.canFluidInput, this.canFluidOutput);
        }

        @Override
        @NotNull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("overflowPoint", this.overflowPoint);
            tag.func_74768_a("voidingRate", this.voidingRate);
            tag.func_74757_a("canFluidInput", this.canFluidInput);
            tag.func_74757_a("canFluidOutput", this.canFluidOutput);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.overflowPoint).writeInt(this.voidingRate).writeBoolean(this.canFluidInput).writeBoolean(this.canFluidOutput);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)aNBT;
                this.overflowPoint = tag.func_74762_e("overflowPoint");
                this.voidingRate = tag.func_74762_e("voidingRate");
                this.canFluidInput = tag.func_74767_n("canFluidInput");
                this.canFluidOutput = tag.func_74767_n("canFluidOutput");
            }
        }

        @Override
        @NotNull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            this.overflowPoint = aBuf.readInt();
            this.voidingRate = aBuf.readInt();
            this.canFluidInput = aBuf.readBoolean();
            this.canFluidOutput = aBuf.readBoolean();
            return this;
        }
    }

    private final class OverflowUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int width = 71;
        private static final int height = 10;
        private static final int xFI = 43;
        private static final int yFI = 81;
        private static final int xFO = 6;
        private static final int yFO = 81;
        private static final int xOP = 6;
        private static final int yOP = 27;
        private static final int xVR = 6;
        private static final int yVR = 53;

        public OverflowUIFactory(CoverUIBuildContext buildContext) {
            super(CoverOverflowValve.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_overflow_point")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(6, 27))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_liter")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(80, 38))).widget((Widget)new CoverDataControllerWidget<OverflowValveData>(this::getCoverData, this::setCoverData, CoverOverflowValve.this).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((OverflowValveData)coverData).overflowPoint, (coverData, state) -> {
                ((OverflowValveData)coverData).overflowPoint = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(0.0, CoverOverflowValve.this.maxOverflowPoint).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(6, 37).setSize(71, 10)))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_voiding_rate")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(12, 53))).widget(new TextWidget(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_l_per_update")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(80, 64))).widget((Widget)new CoverDataControllerWidget<OverflowValveData>(this::getCoverData, this::setCoverData, CoverOverflowValve.this).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((OverflowValveData)coverData).voidingRate, (coverData, state) -> {
                ((OverflowValveData)coverData).voidingRate = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(0.0, CoverOverflowValve.this.maxOverflowPoint).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(6, 63).setSize(71, 10)))).widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<OverflowValveData>(this::getCoverData, this::setCoverData, CoverOverflowValve.this, this::getClickable, this::updateData).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_ALLOW_INPUT).addTooltip(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_allow_fluid_input")).setPos(61, 81)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLOCK_INPUT).addTooltip(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_block_fluid_input")).setPos(43, 81)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_ALLOW_OUTPUT).addTooltip(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_allow_fluid_output")).setPos(6, 81)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLOCK_OUTPUT).addTooltip(StatCollector.func_74838_a((String)"GTPP.gui.text.cover_overflow_valve_block_fluid_output")).setPos(24, 81)));
        }

        private boolean getClickable(int id, OverflowValveData data) {
            boolean bl;
            switch (id) {
                case 0: {
                    bl = data.canFluidInput;
                    break;
                }
                case 1: {
                    if (!data.canFluidInput) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    bl = data.canFluidOutput;
                    break;
                }
                case 3: {
                    if (!data.canFluidOutput) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong button id: " + id);
                }
            }
            return bl;
        }

        private OverflowValveData updateData(int id, OverflowValveData data) {
            OverflowValveData overflowValveData;
            switch (id) {
                case 0: {
                    data.canFluidInput = true;
                    overflowValveData = data;
                    break;
                }
                case 1: {
                    data.canFluidInput = false;
                    overflowValveData = data;
                    break;
                }
                case 2: {
                    data.canFluidOutput = true;
                    overflowValveData = data;
                    break;
                }
                case 3: {
                    data.canFluidOutput = false;
                    overflowValveData = data;
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong button id: " + id);
                }
            }
            return overflowValveData;
        }
    }
}

