/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.steam;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings1;
import gregtech.common.blocks.BlockCasings2;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTESteamMultiBase;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MTESteamWasher
extends MTESteamMultiBase<MTESteamWasher>
implements ISurvivalConstructable {
    private static final String STRUCTUR_PIECE_MAIN = "main";
    private IStructureDefinition<MTESteamWasher> STRUCTURE_DEFINITION = null;
    private final String[][] shape = new String[][]{{"         ", "         ", " CCCCCC  ", "         ", "         "}, {"         ", "         ", " C    C  ", "         ", "         "}, {"     AAA ", "    A   A", " C  A C A", "    A   A", "     AAA "}, {"    ADDDA", "AAA D   D", "AAA D C D", "AAA D   D", "    ADDDA"}, {"    ADDDA", "A~A DEEED", "AAA DECED", "AAA DEEED", "    ADDDA"}, {"    AAAAA", "AAA ABBBA", "AAA ABABA", "AAA ABBBA", "    AAAAA"}};
    private static final int HORIZONTAL_OFF_SET = 1;
    private static final int VERTICAL_OFF_SET = 4;
    private static final int DEPTH_OFF_SET = 1;
    private static final int MACHINEMODE_OREWASH = 0;
    private static final int MACHINEMODE_SIMPLEWASH = 1;
    private boolean isBroken = true;
    private int tierGearBoxCasing = -1;
    private int tierPipeCasing = -1;
    private int tierMachineCasing = -1;
    private int tierMachine = 1;
    private int tCountCasing = 0;

    public MTESteamWasher(String aName) {
        super(aName);
    }

    public MTESteamWasher(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESteamWasher(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Washer";
    }

    public int getTierMachineCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings1 && 10 == meta) {
            ++this.tCountCasing;
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 0 == meta) {
            ++this.tCountCasing;
            return 2;
        }
        return 0;
    }

    public static int getTierGearBoxCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 2 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 3 == meta) {
            return 2;
        }
        return 0;
    }

    public static int getTierPipeCasing(Block block, int meta) {
        if (block == GregTechAPI.sBlockCasings2 && 12 == meta) {
            return 1;
        }
        if (block == GregTechAPI.sBlockCasings2 && 13 == meta) {
            return 2;
        }
        return 0;
    }

    protected void updateHatchTexture() {
        for (MTEHatch h : this.mSteamInputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamOutputs) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mSteamInputFluids) {
            h.updateTexture(this.getCasingTextureID());
        }
        for (MTEHatch h : this.mInputHatches) {
            h.updateTexture(this.getCasingTextureID());
        }
    }

    private int getCasingTextureID() {
        if (this.tierGearBoxCasing == 2 || this.tierPipeCasing == 2 || this.tierMachineCasing == 2) {
            return ((BlockCasings2)GregTechAPI.sBlockCasings2).getTextureIndex(0);
        }
        return ((BlockCasings1)GregTechAPI.sBlockCasings1).getTextureIndex(10);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.tierMachineCasing = aValue;
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.tierMachineCasing;
    }

    @Override
    protected GTRenderedTexture getFrontOverlay() {
        return new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_STEAM_WASHER);
    }

    @Override
    protected GTRenderedTexture getFrontOverlayActive() {
        return new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_STEAM_WASHER_ACTIVE);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureID())};
    }

    @Override
    public IStructureDefinition<MTESteamWasher> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTUR_PIECE_MAIN, StructureUtility.transpose((String[][])this.shape)).addElement('B', StructureUtility.ofBlocksTiered(MTESteamWasher::getTierGearBoxCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)3)), (Object)-1, (t, m) -> {
                t.tierGearBoxCasing = m;
            }, t -> t.tierGearBoxCasing)).addElement('C', StructureUtility.ofBlocksTiered(MTESteamWasher::getTierPipeCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13)), (Object)-1, (t, m) -> {
                t.tierPipeCasing = m;
            }, t -> t.tierPipeCasing)).addElement('D', StructureUtility.ofBlock((Block)Blocks.field_150359_w, (int)0)).addElement('E', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150355_j), StructureUtility.ofBlockAnyMeta((Block)BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater))})).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{MTESteamWasher.buildSteamInput(MTESteamWasher.class).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).build(), GTStructureUtility.buildHatchAdder(MTESteamWasher.class).atLeast(MTESteamMultiBase.SteamHatchElement.InputBus_Steam, MTESteamMultiBase.SteamHatchElement.OutputBus_Steam, HatchElement.InputHatch).casingIndex(10).dot(1).allowOnly(ForgeDirection.NORTH).buildAndChain(new IStructureElement[0]), StructureUtility.ofBlocksTiered(this::getTierMachineCasing, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)10), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)0)), (Object)-1, (t, m) -> {
                t.tierMachineCasing = m;
            }, t -> t.tierMachineCasing)})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTUR_PIECE_MAIN, stackSize, hintsOnly, 1, 4, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTUR_PIECE_MAIN, stackSize, 1, 4, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tierGearBoxCasing = -1;
        this.tierPipeCasing = -1;
        this.tierMachineCasing = -1;
        this.tCountCasing = 0;
        if (!this.checkPiece(STRUCTUR_PIECE_MAIN, 1, 4, 1)) {
            return false;
        }
        if (this.tierGearBoxCasing < 0 && this.tierPipeCasing < 0 && this.tierMachineCasing < 0) {
            return false;
        }
        if (this.tierGearBoxCasing == 1 && this.tierPipeCasing == 1 && this.tierMachineCasing == 1 && this.tCountCasing >= 55 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 1;
            return true;
        }
        if (this.tierGearBoxCasing == 2 && this.tierPipeCasing == 2 && this.tierMachineCasing == 2 && this.tCountCasing >= 55 && this.checkHatches()) {
            this.updateHatchTexture();
            this.tierMachine = 2;
            return true;
        }
        return false;
    }

    private boolean checkHatches() {
        return !this.mSteamInputFluids.isEmpty() && !this.mSteamInputs.isEmpty() && !this.mSteamOutputs.isEmpty() && this.mOutputHatches.isEmpty() && !this.mInputHatches.isEmpty();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        if (this.machineMode == 1) {
            return GTPPRecipeMaps.simpleWasherRecipes;
        }
        return RecipeMaps.oreWasherRecipes;
    }

    @Override
    @NotNull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GTPPRecipeMaps.simpleWasherRecipes, RecipeMaps.oreWasherRecipes);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (!MTESteamWasher.this.isBroken) {
                    if (this.availableVoltage < (long)recipe.mEUt) {
                        return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                    }
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                MTESteamWasher.this.checkForWater();
                MTESteamWasher.this.isBroken = false;
                return SimpleCheckRecipeResult.ofFailure("no_water");
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(1.25 * (double)MTESteamWasher.this.tierMachine).setSpeedBoost(1.6 / (double)MTESteamWasher.this.tierMachine);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getTierRecipes() {
        return 1;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("25% faster than using single block steam machines of the same pressure").addInfo("Only consumes steam at 62.5% of the L/s normally required").addInfo("Processes up to 8 items at once").addInfo("Processing Speed & Steam Consumption is doubled under High Pressure").beginStructureBlock(5, 5, 5, false).addInputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing", 1).addStructureInfo(EnumChatFormatting.WHITE + "Steam Input Hatch " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Any casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "Basic " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "55-59x" + EnumChatFormatting.GRAY + " Bronze Plated Bricks").addStructureInfo(EnumChatFormatting.GOLD + "24x" + EnumChatFormatting.GRAY + " Any Glass").addStructureInfo(EnumChatFormatting.GOLD + "12x" + EnumChatFormatting.GRAY + " Bronze Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "8x" + EnumChatFormatting.GRAY + " Bronze Gear Box Casing").addStructureInfo("").addStructureInfo(EnumChatFormatting.BLUE + "High Pressure " + EnumChatFormatting.DARK_PURPLE + "Tier").addStructureInfo(EnumChatFormatting.GOLD + "55-59x" + EnumChatFormatting.GRAY + " Solid Steel Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "24x" + EnumChatFormatting.GRAY + " Any Glass").addStructureInfo(EnumChatFormatting.GOLD + "12x" + EnumChatFormatting.GRAY + " Steel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "8x" + EnumChatFormatting.GRAY + " Steel Gear Box Casing").toolTipFinisher(GTValues.AuthorEvgenWarGold);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Machine Tier: " + EnumChatFormatting.YELLOW + this.tierMachine);
        info.add("Parallel: " + EnumChatFormatting.YELLOW + this.getMaxParallelRecipes());
        return info.toArray(new String[0]);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + MTESteamWasher.getSteamTierTextForWaila(tag) + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("parallel") + EnumChatFormatting.RESET);
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("tierMachine", this.tierMachine);
        tag.func_74768_a("parallel", this.getMaxParallelRecipes());
        tag.func_74768_a("mode", this.machineMode);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("tierMachine", this.tierMachine);
        aNBT.func_74768_a("mMode", this.machineMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.tierMachine = aNBT.func_74762_e("tierMachine");
        this.machineMode = aNBT.func_74762_e("mMode");
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_STEAM_WASHER_LOOP;
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public int nextMachineMode() {
        if (this.machineMode == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_WASHPLANT);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_SIMPLEWASHER);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_WASH_PLANT.mode." + this.machineMode));
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate < -250) {
                this.mUpdate = 50;
            }
            if (aTick % 1200L == 0L) {
                this.isBroken = true;
            }
        }
    }

    private void checkForWater() {
        ExtendedFacing facing = this.getExtendedFacing();
        ForgeDirection frontFacing = facing.getDirection();
        Flip curFlip = facing.getFlip();
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        double xOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        switch (frontFacing) {
            case WEST: {
                xOffset -= 1.0;
                zOffset += curFlip.isHorizontallyFlipped() ? -6.0 : 4.0;
                break;
            }
            case EAST: {
                xOffset -= 1.0;
                zOffset += curFlip.isHorizontallyFlipped() ? 4.0 : -6.0;
                break;
            }
            case NORTH: {
                zOffset -= 1.0;
                xOffset += curFlip.isHorizontallyFlipped() ? 4.0 : -6.0;
                break;
            }
            case SOUTH: {
                zOffset -= 1.0;
                xOffset += curFlip.isHorizontallyFlipped() ? -6.0 : 4.0;
            }
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Block tBlock = this.getBaseMetaTileEntity().getWorld().func_147439_a((int)((double)i + xOffset + (double)x), (int)((double)y + yOffset), (int)((double)j + zOffset + (double)z));
                if (tBlock != Blocks.field_150350_a || !this.tryConsumeWater()) continue;
                this.getBaseMetaTileEntity().getWorld().func_147449_b((int)((double)i + xOffset + (double)x), (int)((double)y + yOffset), (int)((double)j + zOffset + (double)z), Blocks.field_150355_j);
            }
        }
    }

    private boolean tryConsumeWater() {
        if (this.getStoredFluids() != null) {
            for (FluidStack waterCapacity : this.getStoredFluids()) {
                if (!waterCapacity.isFluidEqual(FluidUtils.getWater(1000)) || waterCapacity.amount < 1000) continue;
                waterCapacity.amount -= 1000;
                return true;
            }
        }
        return false;
    }
}

