/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.MTERedstoneBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MTERedstoneStrengthDisplay
extends MTERedstoneBase {
    public byte mRedstoneStrength = 0;
    public byte mType = 0;
    public static TexturesGtBlock.CustomIcon[] sIconList = new TexturesGtBlock.CustomIcon[144];

    public MTERedstoneStrengthDisplay(int aID, String aUnlocal, String aLocal, String aDescription) {
        super(aID, aUnlocal, aLocal, 5, 0, aDescription, new ITexture[0]);
    }

    public MTERedstoneStrengthDisplay(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 5, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERedstoneStrengthDisplay(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mRedstoneStrength", this.mRedstoneStrength);
        aNBT.func_74774_a("mType", this.mType);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mRedstoneStrength = aNBT.func_74771_c("mRedstoneStrength");
        this.mType = aNBT.func_74771_c("mType");
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mRedstoneStrength = (byte)(aValue & 0xF);
        this.mType = (byte)(aValue >>> 4);
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.mRedstoneStrength & 0xF | this.mType << 4);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide()) {
            this.mRedstoneStrength = this.getBaseMetaTileEntity().getStrongestRedstone();
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mType = (byte)((this.mType + 1) % 6);
        }
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getSides(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getSidesActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], new GTRenderedTexture(sIconList[this.mType * 16 + this.mRedstoneStrength])};
        }
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Top_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Top_On)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Bottom_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Bottom_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_On)};
    }

    static {
        for (int i = 0; i < 144; ++i) {
            MTERedstoneStrengthDisplay.sIconList[i] = new TexturesGtBlock.CustomIcon("TileEntities/gt4/redstone/Display/" + i);
        }
    }
}

