/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTETieredTank
extends MTEBasicTank {
    public MTETieredTank(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "Stores " + GTUtility.formatNumbers((int)(Math.pow(2.0, aTier) * 32000.0)) + "L of fluid", new ITexture[0]);
    }

    public MTETieredTank(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        ArrayList<String> description = new ArrayList<String>(Arrays.asList(this.mDescriptionArray));
        description.add("A portable tank.");
        if (this.mFluid != null) {
            description.add("Fluid: " + this.mFluid.getLocalizedName() + " " + this.mFluid.amount + "L");
        }
        description.add(GTPPCore.GT_Tooltip.get());
        return description.toArray(new String[0]);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (side == ForgeDirection.UP) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GTRenderedTexture(Textures.BlockIcons.OVERLAY_TOP_FLUIDTANK);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GTRenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_FLUIDTANK);
        }
        return iTextureArray;
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        FluidStack tContents;
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("mFluid") && (tContents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d.func_74775_l("mFluid"))) != null && tContents.amount > 0) {
            tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_TANK_INFO", "Contains Fluid: ", !GregTechAPI.sPostloadFinished) + EnumChatFormatting.YELLOW + tContents.getLocalizedName() + EnumChatFormatting.GRAY);
            tooltip.add(GTLanguageManager.addStringLocalization("TileEntity_TANK_AMOUNT", "Fluid Amount: ", !GregTechAPI.sPostloadFinished) + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tContents.amount) + " L" + EnumChatFormatting.GRAY);
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public final byte getUpdateData() {
        return 0;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.mFluid == null) {
            return new String[]{GTValues.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", "No Fluid", "0L", this.getCapacity() + "L"};
        }
        return new String[]{GTValues.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", this.mFluid.getLocalizedName(), this.mFluid.amount + "L", this.getCapacity() + "L"};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETieredTank(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int getCapacity() {
        return (int)(Math.pow(2.0, this.mTier) * 32000.0);
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            Logger.WARNING("Setting item fluid nbt");
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
            if (aNBT.func_74764_b("mFluid")) {
                Logger.WARNING("Set mFluid to NBT.");
            }
        }
    }
}

