/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGenPlasma
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenPlasma(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        if (material.getPlasma() != null) {
            ItemStack aContainerItem;
            ItemStack aPlasmaCell = material.getPlasmaCell(1);
            ItemStack aCell = material.getCell(1);
            ItemStack itemStack = aContainerItem = GTUtility.getFluidForFilledItem(aPlasmaCell, true) == null ? GTUtility.getContainerItem(aPlasmaCell, true) : CI.emptyCells(1);
            if (ItemUtils.checkForInvalidItems(new ItemStack[]{aPlasmaCell, aContainerItem})) {
                switch (material.getUnlocalizedName()) {
                    case "Runite": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1L, aPlasmaCell)).itemOutputs(aContainerItem).metadata(GTRecipeConstants.FUEL_VALUE, 350000).metadata(GTRecipeConstants.FUEL_TYPE, GTRecipeConstants.FuelType.PlasmaTurbine.ordinal()).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "CelestialTungsten": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1L, aPlasmaCell)).itemOutputs(aContainerItem).metadata(GTRecipeConstants.FUEL_VALUE, 720000).metadata(GTRecipeConstants.FUEL_TYPE, GTRecipeConstants.FuelType.PlasmaTurbine.ordinal()).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    default: {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1L, aPlasmaCell)).itemOutputs(aContainerItem).metadata(GTRecipeConstants.FUEL_VALUE, (int)Math.max(1024L, 1024L * material.getMass())).metadata(GTRecipeConstants.FUEL_TYPE, GTRecipeConstants.FuelType.PlasmaTurbine.ordinal()).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
                    }
                }
            }
            if (ItemUtils.checkForInvalidItems(new ItemStack[]{aCell, aPlasmaCell})) {
                GTValues.RA.stdBuilder().itemInputs(aPlasmaCell).itemOutputs(aCell).duration(Math.max(material.getMass() * 2L, 1L)).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

