/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.hatch;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.MTEHatchNbtConsumable;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtnhlanth.common.item.ICanFocus;
import gtnhlanth.util.Util;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEBusInputFocus
extends MTEHatchNbtConsumable {
    private static final int INPUT_SLOTS = 4;

    public MTEBusInputFocus(int id, String name, String nameRegional) {
        super(id, name, nameRegional, 0, 4, "Input Bus for Foci", false);
    }

    public MTEBusInputFocus(String name, String[] descriptionArray, ITexture[][][] textures) {
        super(name, 0, 4, descriptionArray, false, textures);
    }

    @Override
    public int getInputSlotCount() {
        return 4;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getItemsValidForUsageSlots() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean isItemValidForUsageSlot(ItemStack aStack) {
        if (this.getContentUsageSlots().isEmpty()) {
            return aStack.func_77973_b() instanceof ICanFocus;
        }
        return false;
    }

    @Override
    public String getNameGUI() {
        return "Focus Input Bus";
    }

    public void depleteFocusDurability(int damage) {
        ItemStack stack = this.getContentUsageSlots().get(0);
        Util.depleteDurabilityOfStack(stack, damage);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(TexturesGtBlock.Overlay_Bus_Catalyst)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(TexturesGtBlock.Overlay_Bus_Catalyst)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBusInputFocus(this.mName, this.mDescriptionArray, this.mTextures);
    }
}

