/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity.recipe.beamline;

import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBuilder;
import gregtech.api.util.GTUtility;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.tileentity.recipe.beamline.RecipeSC;
import gtnhlanth.common.tileentity.recipe.beamline.RecipeTC;
import gtnhlanth.common.tileentity.recipe.beamline.SourceChamberFrontend;
import gtnhlanth.common.tileentity.recipe.beamline.TargetChamberFrontend;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class BeamlineRecipeAdder2 {
    public static final BeamlineRecipeAdder2 instance = new BeamlineRecipeAdder2();
    public final RecipeMap<RecipeMapBackend> SourceChamberRecipes = RecipeMapBuilder.of("gtnhlanth.recipe.sc").minInputs(0, 0).maxIO(1, 2, 0, 0).amperage(1).frontend(SourceChamberFrontend::new).progressBar(GTUITextures.PROGRESSBAR_ASSEMBLY_LINE_1).neiSpecialInfoFormatter(recipeInfo -> {
        RecipeSC recipe = (RecipeSC)recipeInfo.recipe;
        float focus = recipe.focus;
        float maxEnergy = recipe.maxEnergy;
        int amount = recipe.rate;
        Particle particle = Particle.getParticleFromId(recipe.particleId);
        return Arrays.asList(StatCollector.func_74838_a((String)"beamline.energy") + ": <=" + GTUtility.formatNumbers(Math.min(maxEnergy, particle.maxSourceEnergy())) + " keV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + GTUtility.formatNumbers(focus), StatCollector.func_74838_a((String)"beamline.rate") + ": " + GTUtility.formatNumbers(amount));
    }).build();
    public final RecipeMap<RecipeMapBackend> TargetChamberRecipes = RecipeMapBuilder.of("gtnhlanth.recipe.tc").minInputs(0, 0).maxIO(3, 4, 0, 0).frontend(TargetChamberFrontend::new).neiSpecialInfoFormatter(recipeInfo -> {
        RecipeTC recipe = (RecipeTC)recipeInfo.recipe;
        float minEnergy = recipe.minEnergy;
        float maxEnergy = recipe.maxEnergy;
        float minFocus = recipe.minFocus;
        float amount = recipe.amount;
        Particle particle = Particle.getParticleFromId(recipe.particleId);
        return Arrays.asList(StatCollector.func_74838_a((String)"beamline.energy") + ": " + GTUtility.formatNumbers(minEnergy * 1000.0f) + "-" + GTUtility.formatNumbers(maxEnergy * 1000.0f) + " eV", StatCollector.func_74838_a((String)"beamline.focus") + ": >=" + GTUtility.formatNumbers(minFocus), StatCollector.func_74838_a((String)"beamline.amount") + ": " + GTUtility.formatNumbers(amount));
    }).progressBar(GTUITextures.PROGRESSBAR_ASSEMBLY_LINE_1).progressBarPos(108, 22).neiTransferRect(100, 22, 28, 18).build();

    public boolean addSourceChamberRecipe(ItemStack[] itemInputs, ItemStack[] itemOutputs, int particleId, int rate, float maxEnergy, float focus, float energyRatio, int minEUt) {
        return this.SourceChamberRecipes.addRecipe(new RecipeSC(false, itemInputs, itemOutputs, null, new int[0], null, null, 20, minEUt, particleId, rate, maxEnergy, focus, energyRatio)) != null;
    }

    public boolean addTargetChamberRecipe(ItemStack itemInput, ItemStack itemOutput, ItemStack itemFocus, int particleId, int amount, float minEnergy, float maxEnergy, float minFocus, float energyRatio, int minEUt) {
        return this.TargetChamberRecipes.addRecipe(new RecipeTC(false, itemInput, itemOutput, itemFocus, particleId, amount, minEnergy, maxEnergy, minFocus, energyRatio, minEUt), false, false, false) != null;
    }
}

