/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import bartworks.API.BorosilicateGlass;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.LongData;
import gregtech.api.util.LongRunningAverage;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.gui.modularui.widget.ShutDownReasonSyncer;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import kekztech.client.gui.KTUITextures;
import kekztech.common.Blocks;
import kekztech.common.itemBlocks.ItemBlockLapotronicEnergyUnit;
import kekztech.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;

public class MTELapotronicSuperCapacitor
extends MTEEnhancedMultiBlockBase<MTELapotronicSuperCapacitor>
implements ISurvivalConstructable {
    private boolean canUseWireless = false;
    private boolean wireless_mode = false;
    private int counter = 1;
    private boolean balanced = false;
    private final LongRunningAverage energyInputValues1h = new LongRunningAverage(72000);
    private final LongRunningAverage energyOutputValues1h = new LongRunningAverage(72000);
    private final LongData energyInputValues = this.energyInputValues1h.view(100);
    private final LongData energyOutputValues = this.energyOutputValues1h.view(100);
    private final LongData energyInputValues5m = this.energyInputValues1h.view(6000);
    private final LongData energyOutputValues5m = this.energyOutputValues1h.view(6000);
    private final long max_passive_drain_eu_per_tick_per_uhv_cap = 1000000L;
    private final long max_passive_drain_eu_per_tick_per_uev_cap = 100000000L;
    private final long max_passive_drain_eu_per_tick_per_uiv_cap = (long)Math.pow(10.0, 10.0);
    private final long max_passive_drain_eu_per_tick_per_umv_cap = (long)Math.pow(10.0, 12.0);
    private final BigInteger guiCapacityStoredReformatLimit = BigInteger.valueOf(1000000000000L);
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_LAYER = "slice";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_MID = "mid";
    private static final int GLASS_TIER_UNSET = -2;
    private static final Block LSC_PART = Blocks.lscLapotronicEnergyUnit;
    private static final Item LSC_PART_ITEM = Item.func_150898_a((Block)LSC_PART);
    private static final int CASING_META = 0;
    private static final int CASING_TEXTURE_ID = 5503;
    private static final int DURATION_AVERAGE_TICKS = 100;
    private static final IStructureDefinition<MTELapotronicSuperCapacitor> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"bbbbb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}, {"bb~bb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gcccg", "gcccg", "gcccg", "ggggg"}})).addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "ggggg", "ggggg", "ggggg", "ggggg"}})).addShape("mid", StructureUtility.transpose((String[][])new String[][]{{"ggggg", "gCCCg", "gCCCg", "gCCCg", "ggggg"}})).addElement('b', GTStructureUtility.buildHatchAdder(MTELapotronicSuperCapacitor.class).atLeast(LSCHatchElement.Energy, LSCHatchElement.Dynamo, HatchElement.Maintenance).hatchItemFilterAnd((t, h) -> ChannelDataAccessor.getChannelData((ItemStack)h, (String)"glass") < 6 ? GTStructureUtility.filterByMTEClass((List<? extends Class<? extends IMetaTileEntity>>)ImmutableList.of(MTEHatchEnergyTunnel.class, MTEHatchDynamoTunnel.class)).negate() : s -> true).casingIndex(5503).dot(1).buildAndChain(StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)LSC_PART, (int)0)))).addElement('g', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)-2, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onlyIf(te -> te.topState != TopState.NotTop, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.Top;
    }, (IStructureElement)StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)-2, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)))), StructureUtility.onlyIf(te -> te.topState != TopState.Top, (IStructureElement)StructureUtility.onElementPass(te -> {
        te.topState = TopState.NotTop;
    }, (IStructureElement)new IStructureElement<MTELapotronicSuperCapacitor>(){

        public boolean check(MTELapotronicSuperCapacitor t, World world, int x, int y, int z) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            if (LSC_PART != worldBlock || meta == 0) {
                return false;
            }
            int[] nArray = t.capacitors;
            int n = meta - 1;
            nArray[n] = nArray[n] + 1;
            return true;
        }

        private int getHint(ItemStack stack) {
            return Capacitor.VALUES_BY_TIER[Math.min(Capacitor.VALUES_BY_TIER.length, ChannelDataAccessor.getChannelData((ItemStack)stack, (String)"capacitor")) - 1].getMinimalGlassTier() + 1;
        }

        public boolean spawnHint(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)LSC_PART, (int)this.getHint(trigger));
            return true;
        }

        public boolean placeBlock(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, LSC_PART, this.getHint(trigger), 3);
            return true;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTELapotronicSuperCapacitor t, World world, int x, int y, int z, ItemStack trigger, IItemSource source, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            int glassTier = ChannelDataAccessor.getChannelData((ItemStack)trigger, (String)"glass") + 2;
            ItemStack targetStack = source.takeOne(s -> s != null && s.field_77994_a >= 0 && s.func_77973_b() == LSC_PART_ITEM && Capacitor.VALUES[Math.min(s.func_77960_j(), Capacitor.VALUES.length) - 1].getMinimalGlassTier() > glassTier, true);
            if (targetStack == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            return StructureUtility.survivalPlaceBlock((ItemStack)targetStack, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, (NBTTagCompound)targetStack.field_77990_d, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)source, (EntityPlayerMP)actor, chatter);
        }
    }))})).addElement('C', StructureUtility.ofBlock((Block)LSC_PART, (int)1)).build();
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private final Set<MTEHatchEnergyMulti> mEnergyHatchesTT = new HashSet<MTEHatchEnergyMulti>();
    private final Set<MTEHatchDynamoMulti> mDynamoHatchesTT = new HashSet<MTEHatchDynamoMulti>();
    private final Set<MTEHatchEnergyTunnel> mEnergyTunnelsTT = new HashSet<MTEHatchEnergyTunnel>();
    private final Set<MTEHatchDynamoTunnel> mDynamoTunnelsTT = new HashSet<MTEHatchDynamoTunnel>();
    private final int[] capacitors = new int[10];
    private BigInteger capacity = BigInteger.ZERO;
    private BigInteger stored = BigInteger.ZERO;
    private long passiveDischargeAmount = 0L;
    private long inputLastTick = 0L;
    private long outputLastTick = 0L;
    private int repairStatusCache = 0;
    private byte glassTier = (byte)-1;
    private int casingAmount = 0;
    private TopState topState = TopState.MayBeTop;
    private long mMaxEUIn = 0L;
    private long mMaxEUOut = 0L;
    private UUID global_energy_user_uuid;
    protected static DecimalFormat standardFormat;
    protected String capacityCache = "";
    protected String storedEUCache = "";
    protected String usedPercentCache = "";
    protected String passiveDischargeAmountCache = "";
    protected String wirelessStoreCache = "";
    protected long avgInCache;
    protected long avgOutCache;
    protected String timeToCache = "";
    protected boolean isActiveCache;

    public MTELapotronicSuperCapacitor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELapotronicSuperCapacitor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new MTELapotronicSuperCapacitor(this.mName);
    }

    @Override
    public IStructureDefinition<MTELapotronicSuperCapacitor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void processInputHatch(MTEHatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUIn += aHatch.maxEUInput() * aHatch.maxAmperesIn();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private void processOutputHatch(MTEHatch aHatch, int aBaseCasingIndex) {
        this.mMaxEUOut += aHatch.maxEUOutput() * aHatch.maxAmperesOut();
        aHatch.updateTexture(aBaseCasingIndex);
    }

    private boolean addBottomHatches(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead()) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (!(aMetaTileEntity instanceof MTEHatch)) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((MTEHatchMaintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            MTEHatchEnergy tHatch = (MTEHatchEnergy)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyTunnel) {
            MTEHatchEnergyTunnel tHatch = (MTEHatchEnergyTunnel)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyTunnelsTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            MTEHatchEnergyMulti tHatch = (MTEHatchEnergyMulti)aMetaTileEntity;
            this.processInputHatch(tHatch, aBaseCasingIndex);
            return this.mEnergyHatchesTT.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            MTEHatchDynamo tDynamo = (MTEHatchDynamo)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoHatches.add(tDynamo);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoTunnel) {
            MTEHatchDynamoTunnel tDynamo = (MTEHatchDynamoTunnel)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoTunnelsTT.add(tDynamo);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
            MTEHatchDynamoMulti tDynamo = (MTEHatchDynamoMulti)aMetaTileEntity;
            this.processOutputHatch(tDynamo, aBaseCasingIndex);
            return this.mDynamoHatchesTT.add(tDynamo);
        }
        return false;
    }

    private int getUHVCapacitorCount() {
        return this.capacitors[4];
    }

    private int getUEVCapacitorCount() {
        return this.capacitors[7];
    }

    private int getUIVCapacitorCount() {
        return this.capacitors[8];
    }

    private int getUMVCapacitorCount() {
        return this.capacitors[9];
    }

    private int wirelessCapableCapacitors() {
        return this.capacitors[4] + this.capacitors[7] + this.capacitors[8] + this.capacitors[9];
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Energy Storage, LSC").addInfo("Loses energy equal to 1% of the total capacity every 24 hours.").addInfo("Capped at " + EnumChatFormatting.RED + GTUtility.formatNumbers(1000000L) + EnumChatFormatting.GRAY + " EU/t passive loss per " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + " capacitor.").addInfo("The passive loss increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above.").addInfo("Passive loss is multiplied by the number of maintenance issues present.").addSeparator().addInfo("Glass shell has to be Tier - 3 of the highest capacitor tier.").addTecTechHatchInfo().addInfo(GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "-tier glass required for " + EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " Laser Hatches.").addInfo("Add more or better capacitors to increase capacity.").addSeparator().addInfo("Wireless mode can be enabled by right clicking with a screwdriver.").addInfo("This mode can only be enabled if you have a " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + "+ capacitor in the multiblock.").addInfo("When enabled every " + EnumChatFormatting.BLUE + GTUtility.formatNumbers(ItemBlockLapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) + EnumChatFormatting.GRAY + " ticks the LSC will attempt to re-balance against your").addInfo("wireless EU network.").addInfo("If there is less than " + EnumChatFormatting.RED + GTUtility.formatNumbers(ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap) + EnumChatFormatting.GRAY + "(" + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + ") EU in the LSC").addInfo("it will withdraw from the network and add to the LSC.").addInfo("If there is more it will add the EU to the network and remove it from the LSC.").addInfo("The threshold increases " + EnumChatFormatting.DARK_RED + "100" + EnumChatFormatting.GRAY + "-fold for every capacitor tier above.").beginVariableStructureBlock(5, 5, 4, 50, 5, 5, false).addStructureInfo("Modular height of 4-50 blocks.").addController("Front center bottom").addOtherStructurePart("Lapotronic Super Capacitor Casing", "5x2x5 base (at least 17x)").addOtherStructurePart("Lapotronic Capacitor (" + GTValues.TIER_COLORS[4] + GTValues.VN[4] + EnumChatFormatting.GRAY + "-" + GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "), Ultimate Capacitor (" + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.GRAY + "-" + GTValues.TIER_COLORS[12] + GTValues.VN[12] + EnumChatFormatting.GRAY + ")", "Center 3x(1-47)x3 above base (9-423 blocks)").addStructureInfo("You can also use the Empty Capacitor to save materials if you use it for less than half the blocks").addOtherStructurePart("Borosilicate Glass (any)", "41-777x, Encase capacitor pillar").addEnergyHatch("Any casing").addDynamoHatch("Any casing").addOtherStructurePart("Laser Target/Source Hatches", "Any casing, must be using " + GTValues.TIER_COLORS[8] + GTValues.VN[8] + EnumChatFormatting.GRAY + "-tier glass").addStructureInfo("You can have several I/O Hatches").addSubChannelUsage("glass", "Borosilicate Glass Tier").addSubChannelUsage("capacitor", "Maximum Capacitor Tier").addSubChannelUsage("height", "Height of structure").addMaintenanceHatch("Any casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection forgeDirectionacing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation(-1, Dyes._NULL.mRGBa))};
        if (side == forgeDirectionacing && aActive) {
            sTexture = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW, Dyes.getModulation(-1, Dyes._NULL.mRGBa))};
        }
        return sTexture;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity tileEntity) {
        super.onFirstTick(tileEntity);
        if (!tileEntity.isServerSide()) {
            return;
        }
        this.global_energy_user_uuid = tileEntity.getOwnerUuid();
        SpaceProjectManager.checkOrCreateTeam(this.global_energy_user_uuid);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack stack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack stack) {
        this.mProgresstime = 1;
        this.mMaxProgresstime = 1;
        this.mEUt = 0;
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        block8: {
            Arrays.fill(this.capacitors, 0);
            this.mEnergyHatchesTT.clear();
            this.mDynamoHatchesTT.clear();
            this.mEnergyTunnelsTT.clear();
            this.mDynamoTunnelsTT.clear();
            this.mMaxEUIn = 0L;
            this.mMaxEUOut = 0L;
            this.glassTier = (byte)-2;
            this.casingAmount = 0;
            if (!this.checkPiece(STRUCTURE_PIECE_BASE, 2, 1, 0)) {
                return false;
            }
            if (this.casingAmount < 17) {
                return false;
            }
            this.topState = TopState.NotTop;
            int layer = 2;
            do {
                if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 2, layer, 0)) {
                    return false;
                }
                ++layer;
                if (this.topState == TopState.Top) break block8;
                this.topState = TopState.MayBeTop;
            } while (layer <= 50);
            return false;
        }
        for (int highestGlassTier = this.capacitors.length - 1; highestGlassTier >= 0; --highestGlassTier) {
            int highestCapacitor = Capacitor.getIndexFromGlassTier(highestGlassTier);
            if (this.capacitors[highestCapacitor] <= 0) continue;
            if (Capacitor.VALUES[highestCapacitor].getMinimalGlassTier() <= this.glassTier) break;
            return false;
        }
        if (!(this.glassTier >= 8 || this.mEnergyTunnelsTT.isEmpty() && this.mDynamoTunnelsTT.isEmpty())) {
            return false;
        }
        if (this.capacitors[5] > this.capacitors[0] + this.capacitors[1] + this.capacitors[2] + this.capacitors[3] + this.getUHVCapacitorCount() + this.capacitors[6] + this.getUEVCapacitorCount() + this.getUIVCapacitorCount() + this.getUMVCapacitorCount()) {
            return false;
        }
        this.capacity = BigInteger.ZERO;
        for (int i = 0; i < this.capacitors.length; ++i) {
            int count = this.capacitors[i];
            this.capacity = this.capacity.add(Capacitor.VALUES[i].getProvidedCapacity().multiply(BigInteger.valueOf(count)));
        }
        this.passiveDischargeAmount = this.recalculateLossWithMaintenance(this.getRepairStatus());
        return this.mMaintenanceHatches.size() == 1;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = Math.min(stackSize.field_77994_a + 3, 50);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 2, 1, 0);
        for (int i = 2; i < layer - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MID, stackSize, hintsOnly, 2, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, layer - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int layer = Math.min(ChannelDataAccessor.getChannelData((ItemStack)stackSize, (String)"height") + 3, 50);
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 2, 1, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        for (int i = 2; i < layer - 1; ++i) {
            built = this.survivialBuildPiece(STRUCTURE_PIECE_MID, stackSize, 2, i, 0, elementBudget, env, false, true);
        }
        if (built >= 0) {
            return built;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_TOP, stackSize, 2, layer - 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean onRunningTick(ItemStack stack) {
        long power;
        long ttLaserWattage;
        long power2;
        this.inputLastTick = 0L;
        this.outputLastTick = 0L;
        long temp_stored = 0L;
        for (MTEHatchEnergy mTEHatchEnergy : this.mEnergyHatches) {
            if (mTEHatchEnergy == null || !mTEHatchEnergy.isValid()) continue;
            long power22 = this.getPowerToDraw(mTEHatchEnergy.maxEUInput() * mTEHatchEnergy.maxAmperesIn());
            if (mTEHatchEnergy.getEUVar() < power22) continue;
            mTEHatchEnergy.setEUVar(mTEHatchEnergy.getEUVar() - power22);
            temp_stored += power22;
            this.inputLastTick += power22;
        }
        for (MTEHatchDynamo mTEHatchDynamo : this.mDynamoHatches) {
            if (mTEHatchDynamo == null || !mTEHatchDynamo.isValid() || (power2 = this.getPowerToPush(mTEHatchDynamo.maxEUOutput() * mTEHatchDynamo.maxAmperesOut())) > mTEHatchDynamo.maxEUStore() - mTEHatchDynamo.getEUVar()) continue;
            mTEHatchDynamo.setEUVar(mTEHatchDynamo.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (MTEHatchEnergyMulti mTEHatchEnergyMulti : this.mEnergyHatchesTT) {
            if (mTEHatchEnergyMulti == null || !mTEHatchEnergyMulti.isValid()) continue;
            power2 = this.getPowerToDraw(mTEHatchEnergyMulti.maxEUInput() * mTEHatchEnergyMulti.maxAmperesIn());
            if (mTEHatchEnergyMulti.getEUVar() < power2) continue;
            mTEHatchEnergyMulti.setEUVar(mTEHatchEnergyMulti.getEUVar() - power2);
            temp_stored += power2;
            this.inputLastTick += power2;
        }
        for (MTEHatchDynamoMulti mTEHatchDynamoMulti : this.mDynamoHatchesTT) {
            if (mTEHatchDynamoMulti == null || !mTEHatchDynamoMulti.isValid() || (power2 = this.getPowerToPush(mTEHatchDynamoMulti.maxEUOutput() * mTEHatchDynamoMulti.maxAmperesOut())) > mTEHatchDynamoMulti.maxEUStore() - mTEHatchDynamoMulti.getEUVar()) continue;
            mTEHatchDynamoMulti.setEUVar(mTEHatchDynamoMulti.getEUVar() + power2);
            temp_stored -= power2;
            this.outputLastTick += power2;
        }
        for (MTEHatchEnergyTunnel mTEHatchEnergyTunnel : this.mEnergyTunnelsTT) {
            if (mTEHatchEnergyTunnel == null || !mTEHatchEnergyTunnel.isValid()) continue;
            ttLaserWattage = mTEHatchEnergyTunnel.maxEUInput() * (long)mTEHatchEnergyTunnel.Amperes - (long)(mTEHatchEnergyTunnel.Amperes / 20);
            power = this.getPowerToDraw(ttLaserWattage);
            if (mTEHatchEnergyTunnel.getEUVar() < power) continue;
            mTEHatchEnergyTunnel.setEUVar(mTEHatchEnergyTunnel.getEUVar() - power);
            temp_stored += power;
            this.inputLastTick += power;
        }
        for (MTEHatchDynamoTunnel mTEHatchDynamoTunnel : this.mDynamoTunnelsTT) {
            if (mTEHatchDynamoTunnel == null || !mTEHatchDynamoTunnel.isValid() || (power = this.getPowerToPush(ttLaserWattage = mTEHatchDynamoTunnel.maxEUOutput() * (long)mTEHatchDynamoTunnel.Amperes - (long)(mTEHatchDynamoTunnel.Amperes / 20))) > mTEHatchDynamoTunnel.maxEUStore() - mTEHatchDynamoTunnel.getEUVar()) continue;
            mTEHatchDynamoTunnel.setEUVar(mTEHatchDynamoTunnel.getEUVar() + power);
            temp_stored -= power;
            this.outputLastTick += power;
        }
        if (this.wirelessCapableCapacitors() <= 0) {
            this.wireless_mode = false;
        }
        ++this.counter;
        if (this.wireless_mode && (long)this.counter >= ItemBlockLapotronicEnergyUnit.LSC_time_between_wireless_rebalance_in_ticks) {
            this.counter = this.rebalance();
        }
        if (super.getRepairStatus() != this.repairStatusCache) {
            this.passiveDischargeAmount = this.recalculateLossWithMaintenance(super.getRepairStatus());
        }
        this.stored = this.stored.add(BigInteger.valueOf(temp_stored -= this.passiveDischargeAmount));
        this.stored = this.stored.compareTo(BigInteger.ZERO) <= 0 ? BigInteger.ZERO : this.stored;
        IGregTechTileEntity tBMTE = this.getBaseMetaTileEntity();
        tBMTE.injectEnergyUnits(ForgeDirection.UNKNOWN, this.inputLastTick, 1L);
        tBMTE.drainEnergyUnits(ForgeDirection.UNKNOWN, this.outputLastTick, 1L);
        this.energyInputValues1h.update(this.inputLastTick);
        this.energyOutputValues1h.update(this.outputLastTick);
        return true;
    }

    private int rebalance() {
        this.balanced = true;
        BigInteger transferred_eu = this.stored.subtract(ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
        if (transferred_eu.signum() == -1) {
            this.inputLastTick += Math.abs(transferred_eu.longValue());
        } else {
            this.outputLastTick += transferred_eu.longValue();
        }
        if (WirelessNetworkManager.addEUToGlobalEnergyMap(this.global_energy_user_uuid, transferred_eu)) {
            this.stored = ItemBlockLapotronicEnergyUnit.LSC_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUHVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UEV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUEVCapacitorCount())).add(ItemBlockLapotronicEnergyUnit.UIV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUIVCapacitorCount()))).add(ItemBlockLapotronicEnergyUnit.UMV_wireless_eu_cap.multiply(BigInteger.valueOf(this.getUMVCapacitorCount()))));
        }
        return 1;
    }

    private long recalculateLossWithMaintenance(int repairStatus) {
        this.repairStatusCache = repairStatus;
        long temp_capacity_divided = 0L;
        if (this.wirelessCapableCapacitors() == 0) {
            temp_capacity_divided = this.capacity.divide(BigInteger.valueOf(172800000L)).longValue();
        }
        if (this.wirelessCapableCapacitors() != 0) {
            temp_capacity_divided = (long)this.getUHVCapacitorCount() * 1000000L + (long)this.getUEVCapacitorCount() * 100000000L + (long)this.getUIVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_uiv_cap + (long)this.getUMVCapacitorCount() * this.max_passive_drain_eu_per_tick_per_umv_cap;
        }
        return temp_capacity_divided * (long)(this.getIdealStatus() - repairStatus + 1);
    }

    private long getPowerToDraw(long hatchWatts) {
        if (this.stored.compareTo(this.capacity) >= 0) {
            return 0L;
        }
        BigInteger remcapActual = this.capacity.subtract(this.stored);
        BigInteger recampLimited = MAX_LONG.compareTo(remcapActual) > 0 ? remcapActual : MAX_LONG;
        return Math.min(hatchWatts, recampLimited.longValue());
    }

    private long getPowerToPush(long hatchWatts) {
        BigInteger remStoredLimited = MAX_LONG.compareTo(this.stored) > 0 ? this.stored : MAX_LONG;
        return Math.min(hatchWatts, remStoredLimited.longValue());
    }

    private String getTimeTo() {
        double avgIn = this.energyInputValues.avgLong();
        double avgOut = this.energyOutputValues.avgLong();
        double passLoss = this.passiveDischargeAmount;
        double cap = this.capacity.doubleValue();
        double sto = this.stored.doubleValue();
        if (avgIn >= avgOut + passLoss) {
            if (avgIn - passLoss > 0.0) {
                double timeToFull = (cap - sto) / (avgIn - (passLoss + avgOut)) / 20.0;
                return "Time to Full: " + this.formatTime(timeToFull, true);
            }
            return "Time to Something: Infinity years";
        }
        double timeToEmpty = sto / (avgOut + passLoss - avgIn) / 20.0;
        return "Time to Empty: " + this.formatTime(timeToEmpty, false);
    }

    private String getCapacityCache() {
        return this.capacity.compareTo(this.guiCapacityStoredReformatLimit) > 0 ? standardFormat.format(this.capacity) : this.numberFormat.format((Object)this.capacity);
    }

    private String getStoredCache() {
        return this.stored.compareTo(this.guiCapacityStoredReformatLimit) > 0 ? standardFormat.format(this.stored) : this.numberFormat.format((Object)this.stored);
    }

    private String getUsedPercentCache() {
        return Util.toPercentageFrom(this.stored, this.capacity);
    }

    private String getWirelessStoredCache() {
        return standardFormat.format(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid));
    }

    private boolean isActiveCache() {
        return this.getBaseMetaTileEntity().isActive();
    }

    private String getPassiveDischargeAmountCache() {
        return this.passiveDischargeAmount > 100000000000L ? standardFormat.format(this.passiveDischargeAmount) : this.numberFormat.format(this.passiveDischargeAmount);
    }

    @Override
    public String[] getInfoData() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        int secInterval = 5;
        ArrayList<String> ll = new ArrayList<String>();
        ll.add(EnumChatFormatting.YELLOW + "Operational Data:" + EnumChatFormatting.RESET);
        ll.add("EU Stored: " + nf.format(this.stored) + " EU");
        ll.add("EU Stored: " + Util.toStandardForm(this.stored) + " EU");
        ll.add("Used Capacity: " + Util.toPercentageFrom(this.stored, this.capacity));
        ll.add("Total Capacity: " + nf.format(this.capacity) + " EU");
        ll.add("Total Capacity: " + Util.toStandardForm(this.capacity) + " EU");
        ll.add("Passive Loss: " + nf.format(this.passiveDischargeAmount) + " EU/t");
        ll.add("EU IN: " + GTUtility.formatNumbers(this.inputLastTick) + " EU/t");
        ll.add("EU OUT: " + GTUtility.formatNumbers(this.outputLastTick) + " EU/t");
        ll.add("Avg EU IN: " + nf.format(this.energyInputValues.avgLong()) + " (last " + secInterval + " seconds)");
        ll.add("Avg EU OUT: " + nf.format(this.energyOutputValues.avgLong()) + " (last " + secInterval + " seconds)");
        ll.add("Avg EU IN: " + nf.format(this.energyInputValues5m.avgLong()) + " (last 5 minutes)");
        ll.add("Avg EU OUT: " + nf.format(this.energyOutputValues5m.avgLong()) + " (last 5 minutes)");
        ll.add("Avg EU IN: " + nf.format(this.energyInputValues1h.avgLong()) + " (last 1 hour)");
        ll.add("Avg EU OUT: " + nf.format(this.energyOutputValues1h.avgLong()) + " (last 1 hour)");
        ll.add(this.getTimeTo());
        ll.add("Maintenance Status: " + (super.getRepairStatus() == super.getIdealStatus() ? EnumChatFormatting.GREEN + "Working perfectly" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "Has Problems" + EnumChatFormatting.RESET));
        ll.add("Wireless mode: " + (this.wireless_mode ? EnumChatFormatting.GREEN + "enabled" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "disabled" + EnumChatFormatting.RESET));
        ll.add(GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUHVCapacitorCount());
        ll.add(GTValues.TIER_COLORS[10] + GTValues.VN[10] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUEVCapacitorCount());
        ll.add(GTValues.TIER_COLORS[11] + GTValues.VN[11] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUIVCapacitorCount());
        ll.add(GTValues.TIER_COLORS[12] + GTValues.VN[12] + EnumChatFormatting.RESET + " Capacitors detected: " + this.getUMVCapacitorCount());
        ll.add("Total wireless EU: " + EnumChatFormatting.RED + nf.format(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid)) + " EU");
        ll.add("Total wireless EU: " + EnumChatFormatting.RED + Util.toStandardForm(WirelessNetworkManager.getUserEU(this.global_energy_user_uuid)) + " EU");
        String[] a = new String[ll.size()];
        return ll.toArray(a);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0);
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("132", "Pipe is loose. (Wrench)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mWrench))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mWrench, val -> {
            this.mWrench = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("133", "Screws are loose. (Screwdriver)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mScrewdriver))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mScrewdriver, val -> {
            this.mScrewdriver = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("134", "Something is stuck. (Soft Mallet)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSoftHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSoftHammer, val -> {
            this.mSoftHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("135", "Platings are dented. (Hammer)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mHardHammer))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mHardHammer, val -> {
            this.mHardHammer = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("136", "Circuitry burned out. (Soldering)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mSolderingTool))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mSolderingTool, val -> {
            this.mSolderingTool = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("137", "That doesn't belong there. (Crowbar)")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mCrowbar))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mCrowbar, val -> {
            this.mCrowbar = val;
        }));
        ((Column)screenElements.widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        ((Column)((Column)screenElements.widget(new TextWidget(GTUtility.trans("139", "Hit with Soft Mallet")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)));
        screenElements.widget(new TextWidget(GTUtility.trans("140", "to (re-)start the Machine")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(GTUtility.trans("141", "if it doesn't start.")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> {
            Duration time = Duration.ofSeconds((this.mTotalRunTime - this.mLastWorkingTick) / 20L);
            return StatCollector.func_74837_a((String)"GT5U.gui.text.shutdown_duration", (Object[])new Object[]{time.toHours(), time.toMinutes() % 60L, time.getSeconds() % 60L});
        }).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mTotalRunTime, time -> {
            this.mTotalRunTime = time;
        }))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.mLastWorkingTick, time -> {
            this.mLastWorkingTick = time;
        }));
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.shouldDisplayShutDownReason() && !this.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(this.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && this.getBaseMetaTileEntity().wasShutdown()))).widget((Widget)new ShutDownReasonSyncer(() -> this.getBaseMetaTileEntity().getLastShutDownReason(), reason -> this.getBaseMetaTileEntity().setShutDownReason((ShutDownReason)reason)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().wasShutdown(), wasShutDown -> this.getBaseMetaTileEntity().setShutdownStatus((boolean)wasShutDown)));
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> "Total Capacity: " + EnumChatFormatting.BLUE + this.capacityCache + EnumChatFormatting.WHITE + " EU").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getCapacityCache, val -> {
            this.capacityCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Stored: " + EnumChatFormatting.RED + this.storedEUCache + EnumChatFormatting.WHITE + " EU").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getStoredCache, val -> {
            this.storedEUCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Used capacity: " + EnumChatFormatting.RED + this.usedPercentCache).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getUsedPercentCache, val -> {
            this.usedPercentCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Passive Loss: " + EnumChatFormatting.RED + this.passiveDischargeAmountCache + EnumChatFormatting.WHITE + " EU/t").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getPassiveDischargeAmountCache, val -> {
            this.passiveDischargeAmountCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Avg EU IN: " + EnumChatFormatting.GREEN + (this.avgInCache > 100000000000L ? standardFormat.format(this.avgInCache) : this.numberFormat.format(this.avgInCache)) + EnumChatFormatting.WHITE + " last 5s").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.energyInputValues.avgLong(), val -> {
            this.avgInCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Avg EU OUT: " + EnumChatFormatting.RED + (this.avgOutCache > 100000000000L ? standardFormat.format(this.avgOutCache) : this.numberFormat.format(this.avgOutCache)) + EnumChatFormatting.WHITE + " last 5s").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.energyOutputValues.avgLong(), val -> {
            this.avgOutCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> EnumChatFormatting.WHITE + this.timeToCache).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getTimeTo, val -> {
            this.timeToCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> "Total wireless EU: " + EnumChatFormatting.BLUE + this.wirelessStoreCache + EnumChatFormatting.WHITE + " EU").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.isActiveCache))).widget((Widget)new FakeSyncWidget.StringSyncer(this::getWirelessStoredCache, val -> {
            this.wirelessStoreCache = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::isActiveCache, val -> {
            this.isActiveCache = val;
        }));
    }

    private String formatTime(double time, boolean fill) {
        if (time < 1.0) {
            return "Completely " + (fill ? "full" : "empty");
        }
        if (time < 60.0) {
            return String.format("%.2f seconds", time);
        }
        if (time < 3600.0) {
            return String.format("%.2f minutes", time / 60.0);
        }
        if (time < 86400.0) {
            return String.format("%.2f hours", time / 3600.0);
        }
        if (time < 3.1536E7) {
            return String.format("%.2f days", time / 86400.0);
        }
        double y = time / 3.1536E7;
        return y < 9000.0 ? String.format("%.2f years", y) : "Over9000 years";
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        nbt.func_74773_a("capacity", this.capacity.toByteArray());
        nbt.func_74773_a("stored", this.stored.toByteArray());
        nbt.func_74757_a("wireless_mode", this.wireless_mode);
        nbt.func_74768_a("wireless_mode_cooldown", this.counter);
        super.saveNBTData(nbt);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        nbt = nbt == null ? new NBTTagCompound() : nbt;
        this.capacity = new BigInteger(nbt.func_74770_j("capacity"));
        this.stored = new BigInteger(nbt.func_74770_j("stored"));
        this.wireless_mode = nbt.func_74767_n("wireless_mode");
        this.counter = nbt.func_74762_e("wireless_mode_cooldown");
        super.loadNBTData(nbt);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack stack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack stack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack stack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack stack) {
        return false;
    }

    @Override
    public long maxEUStore() {
        return this.capacity.longValue();
    }

    @Override
    public long getEUVar() {
        return this.stored.longValue();
    }

    @Override
    public long maxEUInput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUIn;
    }

    @Override
    public long maxAmperesIn() {
        return 1L;
    }

    @Override
    public long maxEUOutput() {
        if (this.wireless_mode) {
            return Long.MAX_VALUE;
        }
        return this.mMaxEUOut;
    }

    @Override
    public long maxAmperesOut() {
        return 1L;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    protected boolean canUseWireless() {
        return this.wirelessCapableCapacitors() != 0;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.canUseWireless()) {
            this.wireless_mode = !this.wireless_mode;
            GTUtility.sendChatToPlayer(aPlayer, "Wireless network mode " + (this.wireless_mode ? "enabled." : "disabled."));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "Wireless mode cannot be enabled without at least 1 " + GTValues.TIER_COLORS[9] + GTValues.VN[9] + EnumChatFormatting.RESET + "+ capacitor.");
            this.wireless_mode = false;
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.canUseWireless = this.canUseWireless();
            }
            if (this.canUseWireless) {
                this.wireless_mode = !this.wireless_mode;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            if (this.canUseWireless) {
                if (this.wireless_mode) {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_ON);
                } else {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF);
                }
            } else {
                ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.wireless_mode, val -> {
            this.wireless_mode = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::canUseWireless, val -> {
            this.canUseWireless = val;
        }))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.mMachine && this.wireless_mode && this.canUseWireless && !this.balanced) {
                this.counter = this.rebalance();
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_REBALANCE);
            return ret.toArray(new IDrawable[0]);
        }).setPos(98, 91).setSize(16, 16).setEnabled(widget -> this.wireless_mode && this.canUseWireless && !this.balanced).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless_rebalance")).setTooltipShowUpDelay(5));
    }

    static /* synthetic */ BigInteger access$000() {
        return MAX_LONG;
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setExponentSeparator("e");
        standardFormat = new DecimalFormat("0.00E0", dfs);
    }

    private static enum TopState {
        MayBeTop,
        Top,
        NotTop;

    }

    private static enum Capacitor {
        IV(2, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.IV_cap_storage)),
        LuV(3, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.LuV_cap_storage)),
        ZPM(4, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.ZPM_cap_storage)),
        UV(5, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UV_cap_storage)),
        UHV(6, MTELapotronicSuperCapacitor.access$000()),
        None(0, BigInteger.ZERO),
        EV(1, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.EV_cap_storage)),
        UEV(7, MTELapotronicSuperCapacitor.access$000()),
        UIV(8, BigInteger.valueOf(ItemBlockLapotronicEnergyUnit.UIV_cap_storage)),
        UMV(9, ItemBlockLapotronicEnergyUnit.UMV_cap_storage);

        private final int minimalGlassTier;
        private final BigInteger providedCapacity;
        static final Capacitor[] VALUES;
        static final Capacitor[] VALUES_BY_TIER;

        private Capacitor(int minimalGlassTier, BigInteger providedCapacity) {
            this.minimalGlassTier = minimalGlassTier;
            this.providedCapacity = providedCapacity;
        }

        public int getMinimalGlassTier() {
            return this.minimalGlassTier;
        }

        public BigInteger getProvidedCapacity() {
            return this.providedCapacity;
        }

        public static int getIndexFromGlassTier(int glassTier) {
            for (int index = 0; index < VALUES.length; ++index) {
                if (VALUES[index].getMinimalGlassTier() != glassTier) continue;
                return index;
            }
            return -1;
        }

        static {
            VALUES = Capacitor.values();
            VALUES_BY_TIER = (Capacitor[])Arrays.stream(Capacitor.values()).sorted(Comparator.comparingInt(Capacitor::getMinimalGlassTier)).toArray(Capacitor[]::new);
        }
    }

    private static enum LSCHatchElement implements IHatchElement<MTELapotronicSuperCapacitor>
    {
        Energy(new Class[]{MTEHatchEnergyMulti.class, MTEHatchEnergy.class}){

            @Override
            public long count(MTELapotronicSuperCapacitor t) {
                return t.mEnergyHatches.size() + t.mEnergyHatchesTT.size() + t.mEnergyTunnelsTT.size();
            }
        }
        ,
        Dynamo(new Class[]{MTEHatchDynamoMulti.class, MTEHatchDynamo.class}){

            @Override
            public long count(MTELapotronicSuperCapacitor t) {
                return t.mDynamoHatches.size() + t.mDynamoHatchesTT.size() + t.mDynamoTunnelsTT.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        @SafeVarargs
        private LSCHatchElement(Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Arrays.asList(mteClasses);
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTELapotronicSuperCapacitor> adder() {
            return (rec$, x$0, x$1) -> ((MTELapotronicSuperCapacitor)rec$).addBottomHatches(x$0, x$1);
        }
    }
}

