/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.util;

import java.math.BigInteger;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEExoticModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEForgeOfGods;
import tectech.thing.metaTileEntity.multi.godforge.MTEMoltenModule;
import tectech.thing.metaTileEntity.multi.godforge.MTEPlasmaModule;
import tectech.thing.metaTileEntity.multi.godforge.MTESmeltingModule;
import tectech.thing.metaTileEntity.multi.godforge.upgrade.ForgeOfGodsUpgrade;

public class GodforgeMath {
    public static int getRandomIntInRange(int min, int max) {
        return (int)(Math.random() * (double)(max - min)) + min;
    }

    public static double calculateFuelConsumption(MTEForgeOfGods godforge) {
        double upgradeFactor = 1.0;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.STEM)) {
            upgradeFactor = 0.8;
        }
        if (godforge.getFuelType() == 0) {
            return (double)(godforge.getFuelFactor() * 300) * Math.pow(1.15, godforge.getFuelFactor()) * upgradeFactor;
        }
        if (godforge.getFuelType() == 1) {
            return (double)(godforge.getFuelFactor() * 2) * Math.pow(1.08, godforge.getFuelFactor()) * upgradeFactor;
        }
        return (double)((float)godforge.getFuelFactor() / 25.0f) * upgradeFactor;
    }

    public static int calculateStartupFuelConsumption(MTEForgeOfGods godforge) {
        return (int)Math.max((double)(godforge.getFuelFactor() * 25) * Math.pow(1.2, godforge.getFuelFactor()), 1.0);
    }

    public static int calculateMaxFuelFactor(MTEForgeOfGods godforge) {
        int fuelCap = 5;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.TSE)) {
            fuelCap = Integer.MAX_VALUE;
        } else {
            if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.GEM)) {
                fuelCap += godforge.getTotalActiveUpgrades();
            }
            if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.CFCE)) {
                fuelCap = (int)((double)fuelCap * 1.2);
            }
        }
        return Math.max(fuelCap, 1);
    }

    public static int calculateEffectiveFuelFactor(MTEForgeOfGods godforge) {
        int fuelFactor = godforge.getFuelFactor();
        if (fuelFactor <= 43) {
            return fuelFactor;
        }
        return 43 + (int)Math.floor(Math.pow(fuelFactor - 43, 0.4));
    }

    public static void calculateMaxHeatForModules(MTEBaseModule module, MTEForgeOfGods godforge) {
        double logBase = 1.5;
        int baseHeat = 12601;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.SEFCP)) {
            logBase = module instanceof MTESmeltingModule ? 1.12 : 1.18;
        }
        int recipeHeat = baseHeat + (int)(Math.log(godforge.getFuelFactor()) / Math.log(logBase) * 1000.0);
        module.setHeatForOC(GodforgeMath.calculateOverclockHeat(module, godforge, recipeHeat));
        module.setHeat(recipeHeat);
    }

    public static int calculateOverclockHeat(MTEBaseModule module, MTEForgeOfGods godforge, Integer recipeHeat) {
        int actualHeat;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.NDPE)) {
            double exponent = module instanceof MTESmeltingModule ? 0.85 : 0.8;
            actualHeat = recipeHeat > 30000 ? (int)Math.floor(30000.0 + Math.pow(recipeHeat - 30000, exponent)) : recipeHeat;
        } else {
            actualHeat = godforge.isUpgradeActive(ForgeOfGodsUpgrade.CNTI) ? Math.min(recipeHeat, 30000) : Math.min(recipeHeat, 15000);
        }
        return actualHeat;
    }

    public static void calculateSpeedBonusForModules(MTEBaseModule module, MTEForgeOfGods godforge) {
        double speedBonus = 1.0;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.IGCC)) {
            speedBonus = Math.pow(module.getHeat(), -0.01);
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.DOR)) {
            speedBonus = module instanceof MTEPlasmaModule ? (speedBonus /= Math.pow(module.getMaxParallel(), 0.02)) : (speedBonus /= Math.pow(module.getMaxParallel(), 0.012));
        }
        if (module instanceof MTEExoticModule) {
            speedBonus = godforge.isUpgradeActive(ForgeOfGodsUpgrade.PA) ? Math.sqrt(speedBonus) : 1.0;
        }
        module.setSpeedBonus(speedBonus);
    }

    public static void calculateMaxParallelForModules(MTEBaseModule module, MTEForgeOfGods godforge) {
        int baseParallel = 0;
        float fuelFactorMultiplier = 1.0f;
        float heatMultiplier = 1.0f;
        float upgradeAmountMultiplier = 1.0f;
        int node53 = 1;
        boolean isMoltenOrSmeltingWithUpgrade = false;
        if (module instanceof MTESmeltingModule) {
            baseParallel = 1024;
        }
        if (module instanceof MTEMoltenModule) {
            baseParallel = 512;
        }
        if (module instanceof MTEPlasmaModule) {
            baseParallel = 384;
        }
        if (module instanceof MTEExoticModule) {
            baseParallel = 64;
        }
        if (module instanceof MTEMoltenModule || module instanceof MTESmeltingModule && godforge.isUpgradeActive(ForgeOfGodsUpgrade.DOP)) {
            isMoltenOrSmeltingWithUpgrade = true;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.CTCDD)) {
            node53 = 2;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.SA)) {
            fuelFactorMultiplier = 1.0f + (float)GodforgeMath.calculateEffectiveFuelFactor(godforge) / 15.0f;
            if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.TCT)) {
                fuelFactorMultiplier = isMoltenOrSmeltingWithUpgrade ? (fuelFactorMultiplier *= 3.0f) : (fuelFactorMultiplier *= 2.0f);
            }
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.EPEC)) {
            heatMultiplier = isMoltenOrSmeltingWithUpgrade ? 1.0f + (float)module.getHeat() / 15000.0f : 1.0f + (float)module.getHeat() / 25000.0f;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.POS)) {
            upgradeAmountMultiplier = isMoltenOrSmeltingWithUpgrade ? 1.0f + (float)godforge.getTotalActiveUpgrades() / 5.0f : 1.0f + (float)godforge.getTotalActiveUpgrades() / 8.0f;
        }
        float totalBonuses = (float)node53 * fuelFactorMultiplier * heatMultiplier * upgradeAmountMultiplier;
        if (module instanceof MTEExoticModule) {
            totalBonuses = godforge.isUpgradeActive(ForgeOfGodsUpgrade.PA) ? (float)Math.sqrt(totalBonuses) : 1.0f;
        }
        int maxParallel = (int)((float)baseParallel * totalBonuses);
        module.setMaxParallel(maxParallel);
    }

    public static void calculateEnergyDiscountForModules(MTEBaseModule module, MTEForgeOfGods godforge) {
        double fillRatioDiscount = 1.0;
        double maxBatteryDiscount = 1.0;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.REC)) {
            maxBatteryDiscount = 1.0 - (1.0 - Math.pow(1.05, -0.05 * (double)godforge.getMaxBatteryCharge())) / 20.0;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.IMKG)) {
            double fillRatioMinusZeroPointFive = (double)godforge.getBatteryCharge() / (double)godforge.getMaxBatteryCharge() - 0.5;
            fillRatioDiscount = module instanceof MTEPlasmaModule ? 1.0 - (Math.pow(fillRatioMinusZeroPointFive, 2.0) * -0.6 + 0.15) : 1.0 - (Math.pow(fillRatioMinusZeroPointFive, 2.0) * -0.6 + 0.15) * 2.0 / 3.0;
        }
        if (module instanceof MTEExoticModule) {
            if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.PA)) {
                fillRatioDiscount = Math.sqrt(fillRatioDiscount);
                maxBatteryDiscount = Math.sqrt(maxBatteryDiscount);
            } else {
                fillRatioDiscount = 1.0;
                maxBatteryDiscount = 1.0;
            }
        }
        module.setEnergyDiscount((float)(fillRatioDiscount * maxBatteryDiscount));
    }

    public static void calculateProcessingVoltageForModules(MTEBaseModule module, MTEForgeOfGods godforge) {
        long voltage = 2000000000L;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.GISS)) {
            voltage += (long)GodforgeMath.calculateEffectiveFuelFactor(godforge) * 100000000L;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.NGMS)) {
            voltage = (long)((double)voltage * Math.pow(4.0, godforge.getRingAmount()));
        }
        module.setProcessingVoltage(voltage);
    }

    public static void setMiscModuleParameters(MTEBaseModule module, MTEForgeOfGods godforge) {
        int plasmaTier = 0;
        double overclockTimeFactor = 2.0;
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.END)) {
            plasmaTier = 2;
        } else if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.SEDS)) {
            plasmaTier = 1;
        }
        if (godforge.isUpgradeActive(ForgeOfGodsUpgrade.GGEBE)) {
            overclockTimeFactor = module instanceof MTEPlasmaModule ? 2.3 : 2.15;
            if (module instanceof MTEExoticModule) {
                overclockTimeFactor = godforge.isUpgradeActive(ForgeOfGodsUpgrade.PA) ? 2.0 + Math.pow(overclockTimeFactor - 2.0, 2.0) : 2.0;
            }
        }
        module.setUpgrade83(godforge.isUpgradeActive(ForgeOfGodsUpgrade.IMKG));
        module.setMultiStepPlasma(godforge.isUpgradeActive(ForgeOfGodsUpgrade.TPTP));
        module.setPlasmaTier(plasmaTier);
        module.setMagmatterCapable(godforge.isUpgradeActive(ForgeOfGodsUpgrade.END));
        module.setVoltageConfig(godforge.isUpgradeActive(ForgeOfGodsUpgrade.TBF));
        module.setOverclockTimeFactor(overclockTimeFactor);
    }

    public static boolean allowModuleConnection(MTEBaseModule module, MTEForgeOfGods godforge) {
        if (module instanceof MTEMoltenModule && godforge.isUpgradeActive(ForgeOfGodsUpgrade.FDIM)) {
            return true;
        }
        if (module instanceof MTEPlasmaModule && godforge.isUpgradeActive(ForgeOfGodsUpgrade.GPCI)) {
            return true;
        }
        if (module instanceof MTEExoticModule && godforge.isUpgradeActive(ForgeOfGodsUpgrade.QGPIU)) {
            return true;
        }
        return module instanceof MTESmeltingModule;
    }

    public static void queryMilestoneStats(MTEBaseModule module, MTEForgeOfGods godforge) {
        godforge.addTotalPowerConsumed(module.getPowerTally());
        module.setPowerTally(BigInteger.ZERO);
        godforge.addTotalRecipesProcessed(module.getRecipeTally());
        module.setRecipeTally(0L);
        module.setInversionConfig(godforge.isInversionAvailable());
    }
}

