/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.asm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMUtil {
    private static final Logger logger = LogManager.getLogger((String)"ASM GTNH");
    private static File outputDir = null;

    private static void emptyClassOutputFolder() {
        outputDir = new File(Launch.minecraftHome, "ASM_GTNH");
        try {
            FileUtils.deleteDirectory((File)outputDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
    }

    public static void saveClassToDisk(Class<?> clazz) {
        try (InputStream is = clazz.getResourceAsStream('/' + clazz.getName().replace('.', '/') + ".class");){
            byte[] bytes = ASMUtil.getClassBytes(is);
            ASMUtil.saveClassBytesToDisk(bytes, clazz.getName());
        }
        catch (IOException e) {
            logger.error("Couldn't load bytes of " + clazz.getName(), (Throwable)e);
        }
    }

    private static byte[] getClassBytes(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    byte[] c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            int last = is.read();
            if (last < 0) {
                return b;
            }
            byte[] c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            c[len++] = (byte)last;
            b = c;
        }
    }

    private static String stripClassName(String classname) {
        String[] split = classname.split("\\.");
        return split[split.length - 1];
    }

    public static void saveClassBytesToDisk(byte[] classBytes, String classname, Object classTransformer) {
        classname = ASMUtil.stripClassName(classTransformer.getClass().getName()).toUpperCase() + File.separatorChar + classname;
        ASMUtil.saveClassBytesToDisk(classBytes, classname);
    }

    public static void saveClassBytesToDisk(byte[] classBytes, String classname) {
        String fileName = classname.replace('.', File.separatorChar);
        ASMUtil.saveAsRawClassFile(classBytes, classname, fileName);
        ASMUtil.saveAsBytecodeFile(classBytes, classname, fileName);
        ASMUtil.saveAsASMFile(classBytes, classname, fileName);
    }

    public static void saveAsRawClassFile(byte[] classBytes, String classname, Object classTransformer) {
        String fileName = ASMUtil.stripClassName(classTransformer.getClass().getName()).toUpperCase() + File.separatorChar + classname.replace('.', File.separatorChar);
        ASMUtil.saveAsRawClassFile(classBytes, classname, fileName);
    }

    public static void saveAsRawClassFile(byte[] classBytes, String classname) {
        String fileName = classname.replace('.', File.separatorChar);
        ASMUtil.saveAsRawClassFile(classBytes, classname, fileName);
    }

    public static void saveAsRawClassFile(byte[] classBytes, String classname, String fileName) {
        File classFile;
        File outDir;
        if (outputDir == null) {
            ASMUtil.emptyClassOutputFolder();
        }
        if (!(outDir = (classFile = new File(outputDir, fileName + ".class")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (classFile.exists()) {
            classFile.delete();
        }
        try (OutputStream output = Files.newOutputStream(classFile.toPath(), new OpenOption[0]);){
            output.write(classBytes);
            logger.info("Saved class (byte[]) to " + classFile.toPath());
        }
        catch (IOException e) {
            logger.error("Could not save class (byte[]) " + classname, (Throwable)e);
        }
    }

    public static void saveAsBytecodeFile(byte[] classBytes, String classname, Object classTransformer) {
        String fileName = ASMUtil.stripClassName(classTransformer.getClass().getName()).toUpperCase() + File.separatorChar + classname.replace('.', File.separatorChar);
        ASMUtil.saveAsBytecodeFile(classBytes, classname, fileName);
    }

    public static void saveAsBytecodeFile(byte[] classBytes, String classname) {
        String fileName = classname.replace('.', File.separatorChar);
        ASMUtil.saveAsBytecodeFile(classBytes, classname, fileName);
    }

    public static void saveAsBytecodeFile(byte[] classBytes, String classname, String fileName) {
        File bytecodeFile;
        File outDir;
        if (outputDir == null) {
            ASMUtil.emptyClassOutputFolder();
        }
        if (!(outDir = (bytecodeFile = new File(outputDir, fileName + "_BYTECODE.txt")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (bytecodeFile.exists()) {
            bytecodeFile.delete();
        }
        try (OutputStream output = Files.newOutputStream(bytecodeFile.toPath(), new OpenOption[0]);){
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(output)), 0);
            logger.info("Saved class (bytecode) to " + bytecodeFile.toPath());
        }
        catch (IOException e) {
            logger.error("Could not save class (bytecode) " + classname, (Throwable)e);
        }
    }

    public static void saveAsASMFile(byte[] classBytes, String classname, Object classTransformer) {
        String fileName = ASMUtil.stripClassName(classTransformer.getClass().getName()).toUpperCase() + File.separatorChar + classname.replace('.', File.separatorChar);
        ASMUtil.saveAsASMFile(classBytes, classname, fileName);
    }

    public static void saveAsASMFile(byte[] classBytes, String classname) {
        String fileName = classname.replace('.', File.separatorChar);
        ASMUtil.saveAsASMFile(classBytes, classname, fileName);
    }

    public static void saveAsASMFile(byte[] classBytes, String classname, String fileName) {
        File asmifiedFile;
        File outDir;
        if (outputDir == null) {
            ASMUtil.emptyClassOutputFolder();
        }
        if (!(outDir = (asmifiedFile = new File(outputDir, fileName + "_ASM.txt")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (asmifiedFile.exists()) {
            asmifiedFile.delete();
        }
        try (OutputStream output = Files.newOutputStream(asmifiedFile.toPath(), new OpenOption[0]);){
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new ASMifier(), new PrintWriter(output)), 0);
            logger.info("Saved class (ASMified) to " + asmifiedFile.toPath());
        }
        catch (IOException e) {
            logger.error("Could not save class (ASMified) " + classname, (Throwable)e);
        }
    }
}

