/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.transformers.mc;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SpeedupLongIntHashMapTransformer
implements IClassTransformer {
    public static final String LONG_HASH_MAP = "net/minecraft/util/LongHashMap";
    public static final String LONG_HASH_MAP_OBF = "qd";
    public static final String INT_HASH_MAP = "net/minecraft/util/IntHashMap";
    public static final String INT_HASH_MAP_OBF = "pz";
    public static final String FAST_UTIL_LONG_HASH_MAP = "com/mitchej123/hodgepodge/util/FastUtilLongHashMap";
    public static final String FAST_UTIL_INT_HASH_MAP = "com/mitchej123/hodgepodge/util/FastUtilIntHashMap";
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"net/minecraft/util/IntHashMap", "pz", "net/minecraft/util/LongHashMap", "qd"});
    private static final Logger LOGGER = LogManager.getLogger((String)"SpeedupLongIntHashMapTransformer");
    public static final String INIT = "<init>";
    public static final String EMPTY_DESC = "()V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!cstPoolParser.find(basicClass, true)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        if (transformedName.startsWith("com.mitchej123.hodgepodge.util")) {
            return false;
        }
        boolean changed = false;
        boolean longHashMapInit = false;
        boolean intHashMapInit = false;
        for (MethodNode mn : cn.methods) {
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node.getOpcode() == 187 && node instanceof TypeInsnNode) {
                    TypeInsnNode tNode = (TypeInsnNode)node;
                    if (!longHashMapInit && (tNode.desc.equals(LONG_HASH_MAP) || tNode.desc.equals(LONG_HASH_MAP_OBF))) {
                        longHashMapInit = true;
                        LOGGER.info("Found LongHashMap instantiation in " + transformedName + "." + mn.name);
                        mn.instructions.insertBefore((AbstractInsnNode)tNode, (AbstractInsnNode)new TypeInsnNode(187, FAST_UTIL_LONG_HASH_MAP));
                        mn.instructions.remove((AbstractInsnNode)tNode);
                        changed = true;
                        continue;
                    }
                    if (intHashMapInit || !tNode.desc.equals(INT_HASH_MAP) && !tNode.desc.equals(INT_HASH_MAP_OBF)) continue;
                    intHashMapInit = true;
                    LOGGER.info("Found IntHashMap instantiation in " + transformedName + "." + mn.name);
                    mn.instructions.insertBefore((AbstractInsnNode)tNode, (AbstractInsnNode)new TypeInsnNode(187, FAST_UTIL_INT_HASH_MAP));
                    mn.instructions.remove((AbstractInsnNode)tNode);
                    changed = true;
                    continue;
                }
                if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (!mNode.name.equals(INIT) || !mNode.desc.equals(EMPTY_DESC)) continue;
                if (longHashMapInit && (mNode.owner.equals(LONG_HASH_MAP) || mNode.owner.equals(LONG_HASH_MAP_OBF))) {
                    longHashMapInit = false;
                    LOGGER.info("Found LongHashMap constructor call in " + transformedName + "." + mn.name);
                    mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new MethodInsnNode(183, FAST_UTIL_LONG_HASH_MAP, INIT, EMPTY_DESC, false));
                    mn.instructions.remove((AbstractInsnNode)mNode);
                    continue;
                }
                if (!intHashMapInit || !mNode.owner.equals(INT_HASH_MAP) && !mNode.owner.equals(INT_HASH_MAP_OBF)) continue;
                intHashMapInit = false;
                LOGGER.info("Found IntHashMap constructor call in " + transformedName + "." + mn.name);
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new MethodInsnNode(183, FAST_UTIL_INT_HASH_MAP, INIT, EMPTY_DESC, false));
                mn.instructions.remove((AbstractInsnNode)mNode);
            }
        }
        if (longHashMapInit || intHashMapInit) {
            throw new IllegalStateException("Failed to transform " + transformedName + " due to missing constructor call");
        }
        return changed;
    }
}

