/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.blocks.HETieredTileEntity;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public abstract class HEHydroPumpTileEntity
extends HETieredTileEntity {
    private static Textures.BlockIcons.CustomIcon textureScreenPumpON;
    private static Textures.BlockIcons.CustomIcon textureScreenPumpOFF;
    private static Textures.BlockIcons.CustomIcon textureScreenArrowUpAnimated;
    private final int blockTextureIndex = this.getCasingTextureId();

    public HEHydroPumpTileEntity(int tierId) {
        super("he_pump_" + GTValues.VN[tierId].toLowerCase());
    }

    public HEHydroPumpTileEntity(int blockId, int tierId) {
        super(blockId + tierId, "he_pump_" + GTValues.VN[tierId].toLowerCase(), "Hydro Pump (" + GTValues.VN[tierId] + ")");
    }

    @Override
    public void onTick() {
        FluidStack fluidStack2;
        int requiredWater = (int)((float)GTValues.V[this.getTier()] * HEConfig.milliBucketPerEU);
        for (FluidStack fluidStack2 : this.getStoredFluids()) {
            if (fluidStack2.getFluid().getID() != FluidRegistry.WATER.getID()) continue;
            int consumedWater = Math.min(fluidStack2.amount, requiredWater);
            requiredWater -= consumedWater;
            fluidStack2.amount -= consumedWater;
        }
        if (requiredWater > 0) {
            this.stopMachine();
            return;
        }
        float pumpedWater = (float)this.getVoltage() * HEConfig.milliBucketPerEU;
        pumpedWater *= this.getEfficiencyModifier();
        fluidStack2 = new FluidStack((Fluid)HE.pressurizedWater, (int)(pumpedWater *= (float)this.getCurrentEfficiency(null) / 10000.0f));
        HE.pressurizedWater.setPressure(fluidStack2, this.getPressure());
        this.addOutput(fluidStack2);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister blockIconRegister) {
        textureScreenPumpOFF = new Textures.BlockIcons.CustomIcon("iconsets/he_pump");
        textureScreenPumpON = new Textures.BlockIcons.CustomIcon("iconsets/he_pump_active");
        textureScreenArrowUpAnimated = new Textures.BlockIcons.CustomIcon("iconsets/he_arrow_up_animated");
        super.registerIcons(blockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean isActive, boolean hasRedstoneSignal) {
        if (side == facing) {
            if (isActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F], new TTRenderedExtendedFacingTexture((IIconContainer)textureScreenPumpON), new TTRenderedExtendedFacingTexture((IIconContainer)textureScreenArrowUpAnimated)};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F], new TTRenderedExtendedFacingTexture((IIconContainer)textureScreenPumpOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[this.blockTextureIndex >> 6][this.blockTextureIndex & 0x3F]};
    }

    public String[] getDescription() {
        return new String[]{"Hydro Pump Controller", "Controller Block for the Hydro Pump", "Consumes EU to pressurize water", "Output is pressurized water for Hydro Dams", "Requires a Energy, Input, Output and Maintenance Hatch anywhere!", "Requires " + this.getMilliBucketsPerTick() + "mB Water per Tick", "Efficiency: " + this.getEfficiencyModifierInPercent(), HE.blueprintHintTecTech, "Use Redstone to automate!"};
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return new String[]{"1 Energy Hatch", "1 Fluid Input Hatch", "1 Fluid Output Hatch", "1 Maintenance Hatch", "Fill the rest with " + this.getCasingName()};
    }

    @Override
    protected long getEnergyConsumption() {
        return -this.getVoltage();
    }

    public boolean isPowerPassButtonEnabled() {
        return false;
    }

    public boolean isSafeVoidButtonEnabled() {
        return false;
    }

    public boolean isAllowedToWorkButtonEnabled() {
        return false;
    }

    public static class MAX
    extends HEHydroPumpTileEntity {
        private static final int tierId = 14;

        public MAX() {
            super(14);
        }

        public MAX(int id) {
            super(id, 14);
        }

        @Override
        protected int getTier() {
            return 14;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new MAX();
        }
    }

    public static class UXV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 13;

        public UXV() {
            super(13);
        }

        public UXV(int id) {
            super(id, 13);
        }

        @Override
        protected int getTier() {
            return 13;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UXV();
        }
    }

    public static class UMV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 12;

        public UMV() {
            super(12);
        }

        public UMV(int id) {
            super(id, 12);
        }

        @Override
        protected int getTier() {
            return 12;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UMV();
        }
    }

    public static class UIV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 11;

        public UIV() {
            super(11);
        }

        public UIV(int id) {
            super(id, 11);
        }

        @Override
        protected int getTier() {
            return 11;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UIV();
        }
    }

    public static class UEV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 10;

        public UEV() {
            super(10);
        }

        public UEV(int id) {
            super(id, 10);
        }

        @Override
        protected int getTier() {
            return 10;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UEV();
        }
    }

    public static class UHV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 9;

        public UHV() {
            super(9);
        }

        public UHV(int id) {
            super(id, 9);
        }

        @Override
        protected int getTier() {
            return 9;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UHV();
        }
    }

    public static class UV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 8;

        public UV() {
            super(8);
        }

        public UV(int id) {
            super(id, 8);
        }

        @Override
        protected int getTier() {
            return 8;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new UV();
        }
    }

    public static class ZPM
    extends HEHydroPumpTileEntity {
        private static final int tierId = 7;

        public ZPM() {
            super(7);
        }

        public ZPM(int id) {
            super(id, 7);
        }

        @Override
        protected int getTier() {
            return 7;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new ZPM();
        }
    }

    public static class LuV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 6;

        public LuV() {
            super(6);
        }

        public LuV(int id) {
            super(id, 6);
        }

        @Override
        protected int getTier() {
            return 6;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new LuV();
        }
    }

    public static class IV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 5;

        public IV() {
            super(5);
        }

        public IV(int id) {
            super(id, 5);
        }

        @Override
        protected int getTier() {
            return 5;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new IV();
        }
    }

    public static class EV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 4;

        public EV() {
            super(4);
        }

        public EV(int id) {
            super(id, 4);
        }

        @Override
        protected int getTier() {
            return 4;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new EV();
        }
    }

    public static class HV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 3;

        public HV() {
            super(3);
        }

        public HV(int id) {
            super(id, 3);
        }

        @Override
        protected int getTier() {
            return 3;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new HV();
        }
    }

    public static class MV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 2;

        public MV() {
            super(2);
        }

        public MV(int id) {
            super(id, 2);
        }

        @Override
        protected int getTier() {
            return 2;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new MV();
        }
    }

    public static class LV
    extends HEHydroPumpTileEntity {
        private static final int tierId = 1;

        public LV() {
            super(1);
        }

        public LV(int id) {
            super(id, 1);
        }

        @Override
        protected int getTier() {
            return 1;
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
            return new LV();
        }
    }
}

