/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.components.ColorPipetteBase;
import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.ui.util.TimerUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DefaultColorPipette
extends ColorPipetteBase {
    private static final int SIZE = 36;
    private static final int DIALOG_SIZE = 50;
    private static final int MOUSE_OFF_X = 7;
    private static final int MOUSE_OFF_Y = -7;
    private final Rectangle captureRect = new Rectangle();
    private final Point previousLocation = new Point();
    private final Timer timer = TimerUtil.createNamedTimer("DefaultColorPipette", 5, e -> this.updatePipette());
    protected final Color borderColor = UIManager.getColor("ColorChooser.pipetteBorderColor");
    private Graphics2D zoomGraphics;
    private BufferedImage zoomImage;

    public DefaultColorPipette(JComponent parent, ColorListener colorListener) {
        super(parent, colorListener);
    }

    protected void updatePipette() {
        this.updatePipette(false);
    }

    @Override
    protected Color getPixelColor(Point location) {
        return super.getPixelColor(this.getHotSPot(location));
    }

    @Override
    public Window show() {
        Window picker = super.show();
        this.timer.start();
        return picker;
    }

    @Override
    public void cancelPipette() {
        this.timer.stop();
        super.cancelPipette();
    }

    @Override
    protected Window getOrCreatePickerWindow() {
        Window pickerWindow = this.getPickerWindow();
        if (pickerWindow == null) {
            pickerWindow = super.getOrCreatePickerWindow();
            pickerWindow.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent event) {
                    DefaultColorPipette.this.updatePipette();
                }
            });
            pickerWindow.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    DefaultColorPipette.this.updatePipette();
                }
            });
            pickerWindow.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DefaultColorPipette.this.pickAndClose();
                }
            });
            pickerWindow.setSize(50, 50);
            this.zoomImage = this.parent.getGraphicsConfiguration().createCompatibleImage(36, 36, 3);
            this.zoomGraphics = (Graphics2D)this.zoomImage.getGraphics();
            this.zoomGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        return pickerWindow;
    }

    @Override
    protected JWindow createPickerWindow(Window parent) {
        return new DefaultPickerWindow(this);
    }

    @Override
    protected Point adjustPickerLocation(Point mouseLocation, Window pickerWindow) {
        Point p = super.adjustPickerLocation(mouseLocation, pickerWindow);
        p.x += 18;
        p.y -= 18;
        return p;
    }

    @Override
    protected void updatePipette(boolean force) {
        Window pickerWindow = this.getPickerWindow();
        if (pickerWindow != null && pickerWindow.isShowing()) {
            Point mouseLoc = this.updateLocation();
            if (mouseLoc == null) {
                return;
            }
            Color c = this.getPixelColor(mouseLoc);
            if (!c.equals(this.getColor()) || !mouseLoc.equals(this.previousLocation) || force) {
                this.setColor(c);
                this.previousLocation.setLocation(mouseLoc);
                if (this.isKeyDown() && this.getPressedKeyCode() == 16) {
                    Point p = pickerWindow.getLocationOnScreen();
                    p.y += pickerWindow.getHeight() - 2;
                    p.x += 2;
                    this.captureRect.setBounds(p.x - 9, p.y - 9, 18, 18);
                    BufferedImage capture = this.robot.createScreenCapture(this.captureRect);
                    this.zoomGraphics.drawImage(capture, 0, 0, this.zoomImage.getWidth(), this.zoomImage.getHeight(), this);
                }
                pickerWindow.repaint();
                this.notifyListener(c);
            }
        }
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
        if (this.zoomGraphics != null) {
            this.zoomGraphics.dispose();
        }
        this.zoomImage = null;
    }

    protected Point getHotSPot(Point location) {
        location.x -= 5;
        location.y -= -5;
        return location;
    }

    @Override
    public boolean isAvailable() {
        if (this.robot != null) {
            this.robot.createScreenCapture(new Rectangle(0, 0, 1, 1));
            return true;
        }
        return false;
    }

    protected Icon getPipetteIcon() {
        Icon icon = UIManager.getIcon("ColorChooser.pipette.icon");
        if (icon == null) {
            icon = DarkUIUtil.iconResolver().getIcon("misc/pipette.svg", true);
        }
        if (icon == null) {
            icon = EmptyIcon.create(0);
        }
        return icon;
    }

    protected Color getPipetteBorderColor() {
        return this.borderColor;
    }

    protected static class DefaultPickerWindow
    extends ColorPipetteBase.PickerWindow {
        private final DefaultColorPipette pipette;

        protected DefaultPickerWindow(DefaultColorPipette pipette) {
            this.pipette = pipette;
        }

        @Override
        public void paint(Graphics g2) {
            super.paint(g2);
            GraphicsUtil.setupStrokePainting(g2);
            Graphics2D g = (Graphics2D)g2;
            g.setColor(Color.WHITE);
            GraphicsContext config = GraphicsUtil.paintWithAlpha(g, 0.005f);
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this);
            g.fillRect(p.x - 5, p.y - 5, 10, 10);
            config.restore();
            Icon icon = this.pipette.getPipetteIcon();
            if (this.pipette.isKeyDown() && this.pipette.getPressedKeyCode() == 16) {
                Shape oldCLip = g.getClip();
                Ellipse2D.Float circ = new Ellipse2D.Float(icon.getIconWidth() - 4, 2.0f, this.getWidth() - icon.getIconWidth() - 2 + 4, this.getHeight() - 2 - icon.getIconHeight() + 4);
                g.setClip(circ);
                g.drawImage((Image)this.pipette.zoomImage, icon.getIconWidth() - 4, 2, null);
                g.setClip(oldCLip);
                g.setColor(this.pipette.getPipetteBorderColor());
                g.setStroke(new BasicStroke(1.0f, 1, 1));
                g.draw(circ);
            }
            icon.paintIcon(null, g, 0, this.getHeight() - icon.getIconHeight());
        }
    }
}

