/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static void safelySetPaint(@NotNull Graphics2D g, @NotNull Paint paint) {
        g.setPaint(GraphicsUtil.setupPaint(g.getPaint(), paint));
    }

    @NotNull
    public static Paint setupPaint(@NotNull Paint current, @NotNull Paint paint) {
        if (current instanceof WrappingPaint) {
            ((WrappingPaint)((Object)current)).setPaint(paint);
            return current;
        }
        return paint;
    }

    @Nullable
    public static AffineTransform tryCreateInverse(@NotNull AffineTransform transform) {
        try {
            return transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public static interface WrappingPaint {
        public void setPaint(@NotNull Paint var1);
    }
}

