/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemStackItemHandler
implements IItemHandlerModifiable {
    private static final String KEY_ITEMS = "Items";
    private final ItemStack container;
    private final int slots;

    public ItemStackItemHandler(ItemStack container, int slots) {
        this.container = container;
        this.slots = slots;
    }

    @Override
    public int getSlots() {
        return this.slots;
    }

    @Override
    @Nullable
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        NBTTagCompound item = this.getItemsNbt().func_150305_b(slot);
        return item == null ? null : ItemStack.func_77949_a((NBTTagCompound)item);
    }

    @Override
    public void setStackInSlot(int slot, @Nullable ItemStack stack) {
        this.validateSlotIndex(slot);
        NBTTagList list = this.getItemsNbt();
        list.func_150304_a(slot, (NBTBase)(stack == null ? new NBTTagCompound() : stack.func_77955_b(new NBTTagCompound())));
    }

    @Override
    @Nullable
    public ItemStack insertItem(int slot, @Nullable ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null) {
            return null;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.field_77994_a;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.field_77994_a > limit;
        if (!simulate) {
            if (existing == null) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.field_77994_a - limit) : null;
    }

    @Override
    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing == null) {
            return null;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.field_77994_a <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, null);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize(existing, existing.field_77994_a - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    protected void onContentsChanged(int slot) {
    }

    public NBTTagList getItemsNbt() {
        NBTTagCompound nbt = this.container.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.container.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b(KEY_ITEMS)) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.getSlots(); ++i) {
                list.func_74742_a((NBTBase)new NBTTagCompound());
            }
            nbt.func_74782_a(KEY_ITEMS, (NBTBase)list);
        }
        return nbt.func_150295_c(KEY_ITEMS, 10);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots + ")");
        }
    }
}

