/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.IItemHandlerLong;
import com.cleanroommc.modularui.utils.item.IItemStackLong;
import com.cleanroommc.modularui.utils.item.INBTSerializable;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import com.cleanroommc.modularui.utils.item.ItemStackLong;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemStackLongHandler
implements IItemHandlerLong,
INBTSerializable<NBTTagCompound> {
    private List<IItemStackLong> items;
    private long slotLimit;

    public ItemStackLongHandler(int slots, long slotLimit) {
        Object[] items = new ItemStackLong[slots];
        Arrays.fill(items, null);
        this.items = Arrays.asList(items);
        this.slotLimit = slotLimit;
    }

    public ItemStackLongHandler(List<IItemStackLong> items) {
        this.items = items;
    }

    public ItemStackLongHandler(ItemStackLong[] items) {
        this.items = Arrays.asList(items);
    }

    @Override
    public int getSlots() {
        return this.items.size();
    }

    @Override
    public void setStackInSlotLong(int slot, IItemStackLong stack) {
        this.items.set(slot, stack == null ? null : new ItemStackLong(stack.getItem(), this.getSlotLimitLong(slot), stack.getItemDamage(), stack.getStackSize(), stack.getTagCompound()));
    }

    @Override
    public IItemStackLong extractItemLong(int slot, long amount, boolean simulate) {
        if (amount == 0L) {
            return null;
        }
        this.validateSlotIndex(slot);
        IItemStackLong existing = this.items.get(slot);
        if (existing == null) {
            return null;
        }
        long toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getStackSize() <= toExtract) {
            if (!simulate) {
                this.items.set(slot, null);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.items.set(slot, ItemHandlerHelper.copyStackWithSize(existing, existing.getStackSize() - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public long getSlotLimitLong(int slot) {
        return this.slotLimit;
    }

    @Override
    public IItemStackLong getStackInSlotLong(int slot) {
        return this.items.get(slot);
    }

    @Override
    public IItemStackLong insertItemLong(int slot, IItemStackLong stack, boolean simulate) {
        boolean reachedLimit;
        if (stack == null) {
            return null;
        }
        this.validateSlotIndex(slot);
        IItemStackLong existing = this.items.get(slot);
        long limit = this.getSlotLimitLong(slot);
        if (existing != null) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.getStackSize();
        }
        if (limit <= 0L) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getStackSize() > limit;
        if (!simulate) {
            if (existing == null) {
                this.items.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.setStackSize(existing.getStackSize() + (reachedLimit ? limit : stack.getStackSize()));
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.getStackSize() - limit) : null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            this.items.get(i).writeToNBT(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.items.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.items.size());
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, ItemStackLong.loadFromNBT(itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.items.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.items.size() + ")");
        }
    }

    public void setSize(int size) {
        Object[] stacks = new IItemStackLong[size];
        Arrays.fill(stacks, null);
        this.items = Arrays.asList(stacks);
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

