/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public abstract class LayerManager {
    private final ButtonManager buttonManager;
    public boolean forceRefresh = false;
    private final Int2ObjectMap<Long2ObjectMap<ILocationProvider>> dimCachedLocations = new Int2ObjectOpenHashMap();
    private Long2ObjectMap<ILocationProvider> currentDimCache;
    private final Set<ILocationProvider> visibleLocations = new HashSet<ILocationProvider>();
    private final Set<ILocationProvider> removeQueue = new HashSet<ILocationProvider>();
    protected final Map<SupportedMods, LayerRenderer> layerRenderer = new EnumMap<SupportedMods, LayerRenderer>(SupportedMods.class);
    private int miniMapWidth = 0;
    private int miniMapHeight = 0;
    private int fullscreenMapWidth = 0;
    private int fullscreenMapHeight = 0;
    private int currentDim;
    private SupportedMods openModGui;
    private boolean refreshDim = true;
    private boolean clearFull;
    private boolean clearCurrent;

    public LayerManager(ButtonManager buttonManager) {
        this.buttonManager = buttonManager;
        buttonManager.setLayerNotify(this::onLayerToggled);
        for (SupportedMods mod : SupportedMods.values()) {
            LayerRenderer renderer;
            if (!mod.isEnabled() || (renderer = this.addLayerRenderer(this, mod)) == null) continue;
            this.layerRenderer.put(mod, renderer);
        }
    }

    @Nullable
    protected abstract LayerRenderer addLayerRenderer(LayerManager var1, SupportedMods var2);

    @Nullable
    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        return null;
    }

    @Nullable
    protected ILocationProvider generateLocation(long packedChunk, int dim) {
        return null;
    }

    public void updateElement(ILocationProvider location) {
    }

    public int getElementSize() {
        return 0;
    }

    private ILocationProvider getOrCreateLocation(int chunkX, int chunkZ) {
        long chunkKey = Util.packChunkToLocation(chunkX, chunkZ);
        ILocationProvider location = (ILocationProvider)this.currentDimCache.get(chunkKey);
        if (location != null) {
            return location;
        }
        location = this.generateLocation(chunkX, chunkZ, this.currentDim);
        if (location == null) {
            location = this.generateLocation(chunkKey, this.currentDim);
        }
        if (location == null) {
            location = this.tryOldLocation(chunkX, chunkZ);
        }
        if (location == null) {
            return null;
        }
        this.currentDimCache.put(chunkKey, (Object)location);
        return location;
    }

    private ILocationProvider tryOldLocation(int chunkX, int chunkZ) {
        int maxBlockZ;
        int maxBlockX;
        int minBlockZ;
        int minBlockX = Util.coordChunkToBlock(chunkX);
        if (this.needsRegenerateVisibleElements(minBlockX, minBlockZ = Util.coordChunkToBlock(chunkZ), maxBlockX = minBlockX + 15, maxBlockZ = minBlockZ + 15)) {
            List<? extends ILocationProvider> oldLoc = this.generateVisibleElements(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            if (oldLoc == null || oldLoc.isEmpty()) {
                return null;
            }
            ILocationProvider loc = null;
            for (ILocationProvider iLocationProvider : oldLoc) {
                if (loc == null) {
                    loc = iLocationProvider;
                    continue;
                }
                this.currentDimCache.put(iLocationProvider.toLong(), (Object)iLocationProvider);
            }
            return loc;
        }
        return null;
    }

    public boolean isLayerActive() {
        return this.buttonManager.isActive();
    }

    public void activateLayer() {
        this.buttonManager.activate();
    }

    public void deactivateLayer() {
        this.buttonManager.deactivate();
    }

    public void toggleLayer() {
        this.buttonManager.toggle();
    }

    public void forceRefresh() {
        this.forceRefresh = true;
    }

    public final void onGuiOpened(SupportedMods mod) {
        this.openModGui = mod;
        this.onOpenMap();
    }

    public final void onGuiClosed(SupportedMods mod) {
        this.openModGui = SupportedMods.NONE;
        this.onCloseMap();
    }

    public void onOpenMap() {
    }

    public void onCloseMap() {
    }

    public final SupportedMods getOpenModGui() {
        return this.openModGui;
    }

    public void recacheMiniMap(int centerBlockX, int centerBlockZ, int blockRadius) {
        this.recacheMiniMap(centerBlockX, centerBlockZ, blockRadius, blockRadius);
    }

    public void recacheMiniMap(int centerBlockX, int centerBlockZ, int blockWidth, int blockHeight) {
        this.miniMapWidth = blockWidth;
        this.miniMapHeight = blockHeight;
        this.recacheVisibleElements(centerBlockX, centerBlockZ);
    }

    public void recacheFullscreenMap(int centerBlockX, int centerBlockZ, int blockWidth, int blockHeight) {
        this.fullscreenMapWidth = blockWidth;
        this.fullscreenMapHeight = blockHeight;
        this.recacheVisibleElements(centerBlockX, centerBlockZ);
    }

    private void recacheVisibleElements(int centerBlockX, int centerBlockZ) {
        int radiusBlockX = Math.max(this.miniMapWidth, this.fullscreenMapWidth) + 1 >> 1;
        int radiusBlockZ = Math.max(this.miniMapHeight, this.fullscreenMapHeight) + 1 >> 1;
        int minBlockX = centerBlockX - radiusBlockX;
        int minBlockZ = centerBlockZ - radiusBlockZ;
        int maxBlockX = centerBlockX + radiusBlockX;
        int maxBlockZ = centerBlockZ + radiusBlockZ;
        if (this.clearCurrent) {
            this.clearCurrent();
        }
        if (this.clearFull) {
            this.clearFull();
        }
        int dim = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        if (this.refreshDim || this.currentDim != dim) {
            this.currentDim = dim;
            this.refreshDimCache();
        }
        if (!this.removeQueue.isEmpty()) {
            for (ILocationProvider location : this.removeQueue) {
                this.layerRenderer.values().forEach(layer -> layer.removeRenderStep(location.toLong()));
                this.currentDimCache.remove(location.toLong());
            }
            this.removeQueue.clear();
        }
        int chunkMinX = Util.coordBlockToChunk(minBlockX) - this.getElementSize();
        int chunkMinZ = Util.coordBlockToChunk(minBlockZ) - this.getElementSize();
        int chunkMaxX = Util.coordBlockToChunk(maxBlockX) + this.getElementSize();
        int chunkMaxZ = Util.coordBlockToChunk(maxBlockZ) + this.getElementSize();
        this.onUpdatePre(chunkMinX, chunkMaxX, chunkMinZ, chunkMaxZ);
        this.visibleLocations.clear();
        for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
            for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                ILocationProvider location = this.getOrCreateLocation(chunkX, chunkZ);
                if (location == null) continue;
                this.updateElement(location);
                this.visibleLocations.add(location);
            }
        }
        this.layerRenderer.values().forEach(layer -> layer.refreshVisibleElements(this.visibleLocations));
        this.onUpdatePost(chunkMinX, chunkMaxX, chunkMinZ, chunkMaxZ);
    }

    public void onLayerToggled(boolean toEnable) {
        if (!toEnable) {
            this.clearFull();
        }
    }

    public void onUpdatePre(int minX, int maxX, int minZ, int maxZ) {
    }

    public void onUpdatePost(int minX, int maxX, int minZ, int maxZ) {
    }

    public final void removeLocation(ILocationProvider location) {
        this.removeQueue.add(location);
        this.forceRefresh();
    }

    public final void removeLocation(long location) {
        ILocationProvider loc = (ILocationProvider)this.currentDimCache.get(location);
        if (loc == null) {
            return;
        }
        this.removeLocation(loc);
    }

    public final void removeLocation(int chunkX, int chunkZ) {
        this.removeLocation(Util.packChunkToLocation(chunkX, chunkZ));
    }

    public final void addExtraLocation(ILocationProvider location) {
        this.currentDimCache.put(location.toLong(), (Object)location);
    }

    public ButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public LayerRenderer getLayerRenderer(SupportedMods map) {
        return this.layerRenderer.get((Object)map);
    }

    public Collection<? extends ILocationProvider> getVisibleLocations() {
        return this.visibleLocations;
    }

    public Collection<? extends ILocationProvider> getCachedLocations() {
        return this.getCurrentDimCache().values();
    }

    public Long2ObjectMap<ILocationProvider> getCurrentDimCache() {
        if (this.currentDimCache == null) {
            this.currentDimCache = (Long2ObjectMap)this.dimCachedLocations.computeIfAbsent(this.currentDim, k -> new Long2ObjectOpenHashMap());
        }
        return this.currentDimCache;
    }

    public boolean isEnabled(SupportedMods mod) {
        return this.layerRenderer.containsKey((Object)mod);
    }

    protected void refreshDimCache() {
        this.refreshDim = false;
        this.currentDimCache = (Long2ObjectMap)this.dimCachedLocations.computeIfAbsent(this.currentDim, k -> new Long2ObjectOpenHashMap());
        this.layerRenderer.values().forEach(renderer -> renderer.setDimCache(this.currentDim));
    }

    public void clearCurrentCache() {
        this.clearCurrent = true;
        this.forceRefresh();
    }

    public void clearFullCache() {
        this.clearFull = true;
        this.forceRefresh();
    }

    private void clearCurrent() {
        this.clearCurrent = false;
        if (this.currentDimCache == null) {
            return;
        }
        this.currentDimCache.clear();
        this.layerRenderer.values().forEach(LayerRenderer::clearCurrentCache);
    }

    private void clearFull() {
        this.clearFull = false;
        this.refreshDim = true;
        this.dimCachedLocations.clear();
        this.currentDimCache = null;
        this.layerRenderer.values().forEach(LayerRenderer::clearFullCache);
    }

    @Deprecated
    protected void checkAndUpdateElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
    }

    @Deprecated
    protected boolean needsRegenerateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return false;
    }

    @Deprecated
    protected List<? extends ILocationProvider> generateVisibleElements(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return null;
    }
}

