/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.effects;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.utility.Log;
import java.util.Arrays;
import java.util.List;
import net.minecraft.potion.Potion;

public class Effect {
    public final String name;
    public final Potion potion;
    public int amplifier = 0;
    public int minimum;
    public int maximum;
    public EnumDetectionType detectionType;
    public List<Nutrient> nutrients = NutrientList.get();
    public int cumulativeModifier = 1;

    private Effect(String name, Potion potion) {
        this.name = name;
        this.potion = potion;
    }

    public static Builder builder(String name, Potion potion) {
        return new Builder(name, potion);
    }

    public static class Builder {
        private final Effect effect;

        private Builder(String name, Potion potion) {
            this.effect = new Effect(name, potion);
        }

        public Builder amplifier(int amplifier) {
            this.effect.amplifier = amplifier;
            return this;
        }

        public Builder nutrientRange(int minimum, int maximum) {
            this.effect.minimum = minimum;
            this.effect.maximum = maximum;
            return this;
        }

        public Builder detectionType(EnumDetectionType detectionType) {
            this.effect.detectionType = detectionType;
            return this;
        }

        public Builder nutrients(Nutrient ... nutrients) {
            this.effect.nutrients = Arrays.asList(nutrients);
            return this;
        }

        public Builder cumulativeModifier(int cumulativeModifier) {
            if (this.effect.detectionType != EnumDetectionType.CUMULATIVE) {
                Log.error("Cannot use cumulative modifier if detection type is not cumulative! Skipping call...");
                return this;
            }
            this.effect.cumulativeModifier = cumulativeModifier;
            return this;
        }

        public Effect build() {
            if (this.effect.detectionType == null) {
                Log.fatal("Must set a detection type for effect " + this.effect.name + "!");
                throw new IllegalStateException("Must set a detection type for effect " + this.effect.name + "!");
            }
            return this.effect;
        }
    }

    public static enum EnumDetectionType {
        ANY,
        AVERAGE,
        ALL,
        CUMULATIVE;

    }
}

