/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import thaumicenergistics.common.network.NetworkHandler;
import thaumicenergistics.common.network.ThEBasePacket;
import thaumicenergistics.common.utils.ThELog;

public abstract class WrapperPacket
implements IMessage {
    private ThEBasePacket embeddedPacket;

    public WrapperPacket() {
    }

    public WrapperPacket(ThEBasePacket packet) {
        this.embeddedPacket = packet;
    }

    public void execute() {
        if (this.embeddedPacket != null) {
            this.embeddedPacket.execute();
        }
    }

    public void fromBytes(ByteBuf stream) {
        short id = stream.readShort();
        if (id == -1) {
            ThELog.warning("Unknown packet detected", new Object[0]);
            return;
        }
        Class<?> epClass = NetworkHandler.getPacketClassFromID(id);
        if (epClass == null) {
            return;
        }
        try {
            this.embeddedPacket = (ThEBasePacket)epClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.embeddedPacket.fromBytes(stream);
        }
        catch (Exception e) {
            ThELog.warning("Unable to construct packet %s", epClass.getCanonicalName());
        }
    }

    public void toBytes(ByteBuf stream) {
        if (this.embeddedPacket != null) {
            short id = NetworkHandler.getPacketID(this.embeddedPacket);
            stream.writeShort((int)id);
            this.embeddedPacket.toBytes(stream);
        } else {
            stream.writeShort(-1);
        }
    }
}

