/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.tiles;

import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.tiles.TileInfusionProvider;
import thaumicenergistics.implementaion.ThEMultiCraftingTracker;

public class TileAdvancedInfusionProvider
extends TileInfusionProvider
implements IAspectSource {
    public List<TileInfusionMatrix> matrices = new ArrayList<TileInfusionMatrix>();
    private List<TileInfusionMatrix> matricesToRemove = new ArrayList<TileInfusionMatrix>();
    public static final int HORIZONTAL_RADIUS = 12;
    public static final int VERTICAL_RADIUS = 5;
    private int currentZ = -12;

    public TileAdvancedInfusionProvider() {
        this.craftingTracker = new ThEMultiCraftingTracker(this, 16);
    }

    @Override
    protected double getIdlePowerusage() {
        return 50.0;
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().AdvancedInfusionProvider.getStack();
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.matrices.isEmpty()) {
            if (this.extractEssentiaFromNetwork(tag, amount, true) == amount) {
                this.doParticalFX(tag.getColor());
                return true;
            }
            this.orderSomeEssentia(tag);
        }
        return false;
    }

    public void searchMatrix() {
        if (this.field_145850_b == null) {
            return;
        }
        for (int dx = -12; dx <= 12; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                if (dx == 0 && dy == 0 && this.currentZ == 0) continue;
                this.bindMatrixs(this.field_145851_c + dx, this.field_145848_d + dy, this.field_145849_e + this.currentZ);
            }
        }
        if (++this.currentZ > 12) {
            this.currentZ = -12;
        }
    }

    public void bindMatrixs(int x, int y, int z) {
        TileEntity tileEntity;
        if (this.field_145850_b != null && (tileEntity = this.field_145850_b.func_147438_o(x, y, z)) instanceof TileInfusionMatrix) {
            TileInfusionMatrix tim = (TileInfusionMatrix)tileEntity;
            if (this.matrices.contains(tim)) {
                return;
            }
            this.matrices.add(tim);
            this.markForUpdate();
            this.saveChanges();
        }
    }

    public void unbindMatrixs() {
        this.matrices.clear();
        this.markForUpdate();
        this.saveChanges();
    }

    public void grabAllAspects(TileInfusionMatrix matrix) {
        if (matrix.getAspects().size() != 0) {
            AspectList aspectList = matrix.getAspects().copy();
            for (Aspect aspect : aspectList.getAspects()) {
                int extractAmount;
                if (aspect == null) continue;
                int needAspectsAmount = aspectList.getAmount(aspect);
                if (needAspectsAmount != (extractAmount = this.extractEssentiaFromNetwork(aspect, needAspectsAmount, false))) {
                    this.orderSomeEssentia(aspect, needAspectsAmount - extractAmount);
                }
                if (extractAmount <= 0) continue;
                this.doParticalFX(aspect.getColor());
                matrix.getAspects().remove(aspect, extractAmount);
            }
        }
    }

    @Override
    public void addWailaInformation(List<String> tooltip) {
        super.addWailaInformation(tooltip);
        if (this.matrices.isEmpty()) {
            tooltip.add(ThEStrings.Tooltip_AdvancedInfusionProviderWorkingMode.getLocalized() + ":" + ThEStrings.Tooltip_AdvancedInfusionProviderNormalMode.getLocalized());
        } else {
            tooltip.add(ThEStrings.Tooltip_AdvancedInfusionProviderWorkingMode.getLocalized() + ":" + ThEStrings.Tooltip_AdvancedInfusionProviderAdvancedMode.getLocalized());
            tooltip.add(String.format(ThEStrings.Tooltip_AdvancedInfusionProviderTotalBind.getLocalized(), this.matrices.size()));
        }
    }

    @TileEvent(value=TileEventType.TICK)
    public void onTick() {
        if (this.isActive) {
            this.searchMatrix();
        }
        if (!this.matrices.isEmpty() && this.isActive) {
            for (TileInfusionMatrix matrix : this.matrices) {
                if (matrix == null) {
                    this.matricesToRemove.add(matrix);
                    continue;
                }
                this.grabAllAspects(matrix);
            }
        }
        if (!this.matricesToRemove.isEmpty()) {
            this.matrices.removeAll(this.matricesToRemove);
            this.matricesToRemove.clear();
            this.markForUpdate();
            this.saveChanges();
        }
    }
}

