/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.render;

import codechicken.nei.api.ShortcutInputHandler;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalInteractableStep;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.integration.model.locations.OreVeinLocation;
import gregtech.api.GregTechAPI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class OreVeinRenderStep
extends UniversalInteractableStep<OreVeinLocation> {
    private static final ResourceLocation clickSound = new ResourceLocation("gui.button.press");
    private static final ResourceLocation depletedTextureLocation = new ResourceLocation("visualprospecting", "textures/depleted.png");
    private static final int fontHeight = Minecraft.func_71410_x().field_71466_p.field_78288_b;

    public OreVeinRenderStep(OreVeinLocation location) {
        super((IWaypointAndLocationProvider)location);
        this.setFontScale(1.2f);
        this.setMinScale(1);
    }

    public void preRender(double topX, double topY, float drawScale, double zoom) {
        double iconSize = this.isXaero ? 10.0 * zoom : (double)(32.0f * drawScale);
        this.setSize(iconSize);
        this.setOffset(-iconSize / 2.0);
    }

    public void draw(double topX, double topY, float drawScale, double zoom) {
        if (zoom >= (double)Config.minZoomLevelForOreLabel && !((OreVeinLocation)this.location).isDepleted()) {
            int fontColor = ((OreVeinLocation)this.location).drawSearchHighlight() ? 0xFFFFFF : 0x7F7F7F;
            DrawUtils.drawLabel((String)((OreVeinLocation)this.location).getName(), (double)(topX + this.width / 2.0), (double)(topY - (double)fontHeight - 5.0), (int)fontColor, (int)0, (boolean)true, (double)this.getFontScale());
        }
        IIcon blockIcon = Blocks.field_150348_b.func_149691_a(0, 0);
        DrawUtils.drawQuad((IIcon)blockIcon, (double)topX, (double)topY, (double)this.width, (double)this.height, (int)0xFFFFFF, (int)255);
        DrawUtils.drawQuad((IIcon)((OreVeinLocation)this.location).getIconFromPrimaryOre(), (double)topX, (double)topY, (double)this.width, (double)this.height, (int)((OreVeinLocation)this.location).getColor(), (int)255);
        if (!((OreVeinLocation)this.location).drawSearchHighlight() || ((OreVeinLocation)this.location).isDepleted()) {
            DrawUtils.drawRect((double)topX, (double)topY, (double)this.width, (double)this.height, (int)0, (int)150);
            if (((OreVeinLocation)this.location).isDepleted()) {
                DrawUtils.drawQuad((ResourceLocation)depletedTextureLocation, (double)topX, (double)topY, (double)this.width, (double)this.height, (int)0xFFFFFF, (int)255);
            }
        }
        if (((OreVeinLocation)this.location).isActiveAsWaypoint()) {
            double thickness = this.width / 8.0;
            DrawUtils.drawHollowRect((double)topX, (double)topY, (double)this.width, (double)this.height, (int)16766720, (int)204, (double)thickness);
        }
    }

    public void getTooltip(List<String> list) {
        if (((OreVeinLocation)this.location).isDepleted()) {
            list.add(((OreVeinLocation)this.location).getDepletedHint());
        }
        if (((OreVeinLocation)this.location).isActiveAsWaypoint()) {
            list.add(((OreVeinLocation)this.location).getActiveWaypointHint());
        }
        list.add(((OreVeinLocation)this.location).getName());
        if (!((OreVeinLocation)this.location).isDepleted()) {
            list.addAll(((OreVeinLocation)this.location).getMaterialNames());
        }
        list.add(((OreVeinLocation)this.location).getToggleDepletedHint());
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX >= this.getX() && (double)mouseX <= this.getX() + this.width && (double)mouseY >= this.getY() && (double)mouseY <= this.getY() + this.height;
    }

    public void onActionKeyPressed() {
        ((OreVeinLocation)this.location).toggleOreVein();
    }

    public boolean onKeyPressed(int keyCode) {
        if (super.onKeyPressed(keyCode)) {
            return true;
        }
        ItemStack itemStack = new ItemStack(GregTechAPI.sBlockOres1, 1, (int)((OreVeinLocation)this.location).getPrimaryOreMeta());
        if (ShortcutInputHandler.handleKeyEvent((ItemStack)itemStack)) {
            this.playClickSound();
            return true;
        }
        return false;
    }

    private void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)clickSound, (float)1.0f));
    }
}

