/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.ILoadConditionSerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.resources.ResourceLocation;

public class LoadConditions {
    private static final Map<ResourceLocation, ILoadConditionSerializer<?>> REGISTRY = new HashMap();

    public static void register(ResourceLocation id, ILoadConditionSerializer<?> serializer) {
        if (REGISTRY.containsKey(id)) {
            Constants.LOG.warn("JSON Load Serializer ID {} has already been assigned to {}. Replacing with {}.", new Object[]{id, REGISTRY.get(id), serializer});
        }
        REGISTRY.put(id, serializer);
    }

    public static ILoadCondition getCondition(JsonObject conditionData) {
        ResourceLocation serializerId = Serializers.RESOURCE_LOCATION.fromJSON(conditionData, "type");
        ILoadConditionSerializer<?> serializer = REGISTRY.get(serializerId);
        if (serializer != null) {
            return serializer.fromJson(conditionData);
        }
        throw new JsonParseException("Serializer ID " + serializerId.toString() + " is unknown!");
    }

    public static ILoadCondition[] getConditions(JsonElement conditionData) {
        if (conditionData instanceof JsonObject) {
            JsonObject obj = (JsonObject)conditionData;
            return new ILoadCondition[]{LoadConditions.getCondition(obj)};
        }
        if (conditionData instanceof JsonArray) {
            JsonArray array = (JsonArray)conditionData;
            ILoadCondition[] conditions = new ILoadCondition[array.size()];
            for (int i = 0; i < conditions.length; ++i) {
                JsonElement jsonElement = array.get(i);
                if (!(jsonElement instanceof JsonObject)) {
                    throw new JsonParseException("Array of load conditions must contain exclusively objects! " + array.get(i).toString());
                }
                JsonObject obj = (JsonObject)jsonElement;
                conditions[i] = LoadConditions.getCondition(obj);
            }
            return conditions;
        }
        throw new JsonParseException("Condition must be object or array of object! " + conditionData.toString());
    }

    public static boolean canLoad(JsonObject rawJson) {
        if (rawJson.has("bookshelf:load_conditions")) {
            JsonElement conditionData = rawJson.get("bookshelf:load_conditions");
            for (ILoadCondition condition : LoadConditions.getConditions(conditionData)) {
                if (condition.test()) continue;
                return false;
            }
        }
        return true;
    }
}

