/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.command.EnumArgument;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.deleter.tasks.DeletionCircle;
import pregenerator.common.deleter.tasks.DeletionCircleExpansion;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionSquare;
import pregenerator.common.deleter.tasks.DeletionSquareExpansion;
import pregenerator.common.deleter.tasks.DeletionTimeOut;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;
import pregenerator.common.utils.misc.GenShape;

public class DeletionCommand {
    public static CommandBuilder createDeletionCommand(boolean advArgs) {
        CommandBuilder builder = new CommandBuilder("delete");
        Command radius = DeletionCommand::executeRadius;
        builder.addLiteral("radius");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Radius", RadiusArgument.integer(1, 25000), (Command<CommandSourceStack>)radius);
        } else {
            builder.addArgument("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)DeletionCommand::listShape));
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1, (int)25000), (Command<CommandSourceStack>)radius);
        }
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)radius).popTop();
        Command expansion = DeletionCommand::executeExpansion;
        builder.addLiteral("expansion");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Shape", (ArgumentType<?>)EnumArgument.enumArgument(GenShape.class));
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Min Radius", RadiusArgument.integer(1));
            builder.addArgument("Max Radius", RadiusArgument.integer(1), (Command<CommandSourceStack>)expansion);
        } else {
            builder.addArgument("Shape", (ArgumentType<?>)StringArgumentType.word(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)DeletionCommand::listShape));
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
            builder.addArgument("Max Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), (Command<CommandSourceStack>)expansion);
        }
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)expansion).popTop();
        Command trim = DeletionCommand::exececuteTrim;
        builder.addLiteral("trim");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Min Radius", RadiusArgument.integer(1), (Command<CommandSourceStack>)trim);
        } else {
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1), (Command<CommandSourceStack>)radius);
        }
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)trim).popTop();
        Command cleanup = DeletionCommand::executeCleanup;
        builder.addLiteral("timedtrim");
        builder.addArgument("Task Name", (ArgumentType<?>)StringArgumentType.word());
        if (advArgs) {
            builder.addArgument("Center", CenterArgument.center());
            builder.addArgument("Min Radius", RadiusArgument.integer(1));
        } else {
            builder.addArgument("Center", (ArgumentType<?>)ColumnPosArgument.m_118989_(), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)CenterArgument::listSimpleSuggestion));
            builder.addArgument("Min Radius", (ArgumentType<?>)IntegerArgumentType.integer((int)1));
        }
        builder.addArgument("Min Time", (ArgumentType<?>)TimeArgument.m_113037_(), (Command<CommandSourceStack>)cleanup);
        builder.addArgument("Dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), (Command<CommandSourceStack>)cleanup).popTop();
        return builder;
    }

    private static CompletableFuture<Suggestions> listShape(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(GenShape.values()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString()));
        return builder.buildFuture();
    }

    private static int executeCleanup(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int radius = wrapper.get("Min Radius", Integer.class);
        int timeOut = wrapper.get("Min Time", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (((CommandSourceStack)source.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237113_((String)"Dimension does not exist"));
            return 0;
        }
        ServerManager.INSTANCE.startTask(new DeletionTimeOut(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), radius, timeOut), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int exececuteTrim(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int radius = wrapper.get("Min Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (((CommandSourceStack)source.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237113_((String)"Dimension does not exist"));
            return 0;
        }
        ServerManager.INSTANCE.startTask(new DeletionExcess(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), radius), wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeRadius(CommandContext<CommandSourceStack> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.hasValue("Shape", String.class) ? GenShape.valueOf(wrapper.get("Shape", String.class)) : wrapper.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int radius = wrapper.get("Radius", Integer.class);
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (((CommandSourceStack)source.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237113_((String)"Dimension does not exist"));
            return 0;
        }
        BaseDeletionTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new DeletionSquare(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), radius);
                break;
            }
            case CIRCLE: {
                task = new DeletionCircle(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), radius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }

    private static int executeExpansion(CommandContext<CommandSourceStack> source) {
        int maxRadius;
        CommandWrapper wrapper = new CommandWrapper(source);
        String name = wrapper.get("Task Name", String.class);
        GenShape shape = wrapper.hasValue("Shape", String.class) ? GenShape.valueOf(wrapper.get("Shape", String.class)) : wrapper.get("Shape", GenShape.class);
        BlockPos center = CenterArgument.getVanillaBlockPos(wrapper.get("Center", Coordinates.class), (CommandSourceStack)source.getSource());
        int minRadius = wrapper.get("Min Radius", Integer.class);
        if (minRadius > (maxRadius = wrapper.get("Max Radius", Integer.class).intValue())) {
            wrapper.sendErrorMessage("Min Radius is not allowed to be bigger then Max Radius");
            return 0;
        }
        if (maxRadius * maxRadius - minRadius * minRadius > 1000000000) {
            wrapper.sendErrorMessage("Expansions bigger then 1Billion Chunks are not allowed");
            return 0;
        }
        ResourceLocation dimension = wrapper.getOrDefault("Dimension", ResourceLocation.class, wrapper.getSource().m_81372_().m_46472_().m_135782_());
        if (((CommandSourceStack)source.getSource()).m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension)) == null) {
            ((CommandSourceStack)source.getSource()).m_81352_((Component)Component.m_237113_((String)"Dimension does not exist"));
            return 0;
        }
        BaseDeletionTask task = null;
        switch (shape) {
            case SQUARE: {
                task = new DeletionSquareExpansion(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), minRadius, maxRadius);
                break;
            }
            case CIRCLE: {
                task = new DeletionCircleExpansion(name, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension), new ChunkPos(center.m_123341_(), center.m_123343_()), minRadius, maxRadius);
            }
        }
        if (task == null) {
            wrapper.sendErrorMessage("Couldn't create Task!");
            return 0;
        }
        ServerManager.INSTANCE.startTask(task, wrapper.getSenderId(), wrapper);
        return 0;
    }
}

