/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter;

import java.time.Duration;
import java.time.Instant;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.DeltaTimer;
import pregenerator.common.utils.misc.IntCounter;

public class DeletionProcessor
implements IProcess<ChunkDeleter, IDeletionTask> {
    boolean prepairing = true;
    boolean unpaused = true;
    long chunksDeleted = 0L;
    long chunksFailed = 0L;
    IDeletionTask task;
    String taskName;
    ChunkDeleter deleter;
    DeltaTimer timer = new DeltaTimer();
    IProcess.PrepaireProgress progress = null;
    IntCounter deletionSpeed = new IntCounter(2000);
    int ticker = 0;
    Instant start;

    @Override
    public void prepaireTask(IProcess.PrepaireProgress progress, String taskName) {
        this.progress = progress;
        this.taskName = taskName;
        this.prepairing = true;
    }

    @Override
    public boolean startTask(IDeletionTask task, ChunkDeleter deleter) {
        if (deleter == null || task == null || !this.prepairing) {
            return false;
        }
        this.deleter = deleter;
        this.task = task;
        this.chunksDeleted = 0L;
        this.chunksFailed = 0L;
        this.ticker = 0;
        this.start = Instant.now();
        this.deletionSpeed.clear();
        this.timer.reset();
        this.unpaused = true;
        this.prepairing = false;
        this.progress = null;
        return true;
    }

    @Override
    public boolean isMultithreaded() {
        return false;
    }

    @Override
    public boolean isBlockingRetrogen() {
        return false;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public boolean isRunning() {
        return this.unpaused;
    }

    @Override
    public void pauseTask() {
        this.unpaused = false;
    }

    @Override
    public void resumeTask() {
        this.unpaused = true;
    }

    @Override
    public void stopTask() {
        TaskStorage.getDeletionStorage().stopTask(this.getTaskName());
        if (this.deleter != null) {
            this.deleter.interrupt();
            this.deleter = null;
        }
        this.task = null;
        this.prepairing = false;
        if (this.progress != null) {
            this.progress.interruptTask();
        }
        this.progress = null;
    }

    @Override
    public void onTickStart() {
        if (this.progress != null && this.ticker++ % 20 == 0) {
            long value = this.progress.getValue();
            long max = this.progress.getMax();
            double progress = (double)value / (double)max * 100.0;
            ServerManager.INSTANCE.listen((Component)Component.m_237113_((String)("Prepaire Progress: " + FORMAT.format(value) + " / " + FORMAT.format(max) + " [" + ItemStack.f_41584_.format(progress) + "%]")).m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public void onTickStop(boolean paused) {
        ChunkDeleter.DeleterEntry entry;
        if (paused || this.deleter == null) {
            return;
        }
        if (this.timer.getAverage() > 10L) {
            this.timer.start();
            this.timer.finish();
            return;
        }
        this.deleter.start();
        this.timer.start();
        while (this.timer.getDeltaTime() < 50L && (entry = this.deleter.getNextTask()) != null) {
            entry.update();
            this.chunksDeleted += (long)entry.getRemoved();
            this.chunksFailed += (long)entry.getSkipped();
        }
        this.deletionSpeed.setNewValue(this.chunksDeleted + this.chunksFailed);
        if (this.unpaused && this.ticker++ % 20 == 0) {
            MutableComponent text = Component.m_237113_((String)"\n");
            text.m_7220_((Component)ChunkLogger.wrap(Component.m_237113_((String)("Task Name: " + this.getTaskName())).m_130940_(ChatFormatting.RED))).m_130946_("\n");
            text.m_7220_((Component)ChunkLogger.wrap(Component.m_237113_((String)("World: " + ChunkLogger.toPascalCase(this.deleter.getType().m_135782_().m_135815_()))).m_130940_(ChatFormatting.GREEN))).m_130946_("\n");
            text.m_7220_((Component)ChunkLogger.wrap(Component.m_237113_((String)("Task, (Deleted | Failed) / Total: " + FORMAT.format(this.chunksDeleted) + " | " + FORMAT.format(this.chunksFailed) + " / " + FORMAT.format(this.deleter.getTotal()))).m_130940_(ChatFormatting.BLUE))).m_130946_("\n");
            text.m_7220_((Component)ChunkLogger.wrap(Component.m_237113_((String)("Ram Usage: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "MB")).m_130940_(ChatFormatting.LIGHT_PURPLE)));
            ServerManager.INSTANCE.listen((Component)text);
        }
        if (this.deleter.isDone()) {
            this.onTaskFinished();
        }
    }

    protected void onTaskFinished() {
        ServerManager.INSTANCE.listen((Component)Component.m_237113_((String)("Pregenation Finished: [Time=" + this.getTime() + ", Chunks=" + this.deleter.getTotal() + "]")));
        this.deleter = null;
        TaskStorage.getDeletionStorage().removeTask(this.getTaskName());
        ServerManager.INSTANCE.onTaskFinished(this.task.getDimension());
        this.task = null;
    }

    protected String getTime() {
        return DurationFormatUtils.formatDuration((long)Duration.between(Instant.now(), this.start).abs().toMillis(), (String)"HH:mm:ss");
    }

    @Override
    public long getExpectedTime() {
        if (this.deleter == null) {
            return 0L;
        }
        float value = this.deletionSpeed.getTotalValue();
        if (value <= 0.0f) {
            return 0L;
        }
        return (long)((float)(this.deleter.getTotal() - (this.chunksDeleted + this.chunksFailed)) / value) * 50L;
    }

    @Override
    public void sendClientData(FriendlyByteBuf buffer) {
        buffer.writeByte(2);
        buffer.writeBoolean(this.prepairing || this.task == null);
        buffer.m_130070_(this.taskName);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        if (this.prepairing || this.task == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getValue());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(this.unpaused);
        buffer.writeLong(Duration.between(this.start, Instant.now()).toMillis());
        buffer.writeLong(this.deleter.getTotal());
        buffer.writeLong(this.chunksDeleted);
        buffer.writeLong(this.chunksFailed);
        buffer.m_130079_(IDeletionTask.saveTask(this.task));
    }
}

