/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionCircle
extends BaseDeletionTask {
    long center;
    int radius;

    public DeletionCircle(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.radius = nbt.m_128451_("radius");
    }

    public DeletionCircle(String name, ResourceKey<Level> type, ChunkPos center, int radius) {
        super(name, type);
        this.center = center.m_45588_();
        this.radius = radius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128356_("center", this.center);
        nbt.m_128405_("radius", this.radius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    public String getShapeName() {
        return "Circle";
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Circle, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.f_45578_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Z=" + center.f_45579_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Radius=" + this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)((long)this.radius * 2L) * Math.PI);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkDeleter deleter = new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world);
        ChunkPos center = new ChunkPos(this.center);
        return deleter.init(ChunkShapeBuilder.getCircleShape(center.f_45578_, center.f_45579_, this.radius, progress), center, progress);
    }
}

