/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.overrider;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;

public class CustomTaskPriorityQueue<T>
extends ChunkTaskPriorityQueue<T> {
    protected List<Long2ObjectMap<List<Optional<T>>>> f_140509_ = new ObjectArrayList();
    private volatile int firstQueue = f_140508_;
    protected final String f_140511_;
    protected final LongSet f_140512_ = new LongOpenHashSet();
    protected final Long2IntMap heightMap = new Long2IntLinkedOpenHashMap();
    protected final int f_140513_;
    protected Int2IntMap radius = new Int2IntOpenHashMap();

    public CustomTaskPriorityQueue(String name, int maxTasks) {
        super(name, maxTasks);
        this.f_140511_ = name;
        this.f_140513_ = maxTasks;
        int m = f_140508_;
        for (int i = 0; i < m; ++i) {
            this.f_140509_.add((Long2ObjectMap<List<Optional<T>>>)new Long2ObjectLinkedOpenHashMap());
        }
        this.radius.put(ChunkStatus.f_62326_.m_62445_(), this.calculateDistance(ChunkStatus.f_62326_, ChunkStatus.f_62322_));
        this.radius.put(ChunkStatus.f_62322_.m_62445_(), this.calculateDistance(ChunkStatus.f_62322_, ChunkStatus.f_62321_));
        this.radius.put(ChunkStatus.f_62321_.m_62445_(), this.calculateDistance(ChunkStatus.f_62321_, ChunkStatus.f_62315_));
        this.addRadius(ChunkStatus.f_62326_, ChunkStatus.f_62322_);
        this.addRadius(ChunkStatus.f_62326_, ChunkStatus.f_62321_);
        this.addRadius(ChunkStatus.f_62326_, ChunkStatus.f_62315_);
        this.addRadius(ChunkStatus.f_62322_, ChunkStatus.f_62321_);
        this.addRadius(ChunkStatus.f_62322_, ChunkStatus.f_62315_);
        this.addRadius(ChunkStatus.f_62321_, ChunkStatus.f_62315_);
    }

    protected void addRadius(ChunkStatus from, ChunkStatus to) {
        this.radius.put(from.m_62445_() << 8 | to.m_62445_(), this.calculateDistance(from, to));
    }

    protected int calculateDistance(ChunkStatus from, ChunkStatus to) {
        int radius = 0;
        while (from != to && from != ChunkStatus.f_62314_) {
            radius += from.m_62488_();
            from = from.m_62482_();
        }
        return radius;
    }

    private boolean isEmpty(Optional<T> optional) {
        return !optional.isPresent();
    }

    protected void updateQueueHeight() {
        while (this.firstQueue < ChunkTaskPriorityQueue.f_140508_ && this.f_140509_.get(this.firstQueue).isEmpty()) {
            ++this.firstQueue;
        }
    }

    protected void m_140521_(int oldPriority, ChunkPos chunkPos, int newPriority) {
        if (oldPriority < ChunkTaskPriorityQueue.f_140508_) {
            List tasks = (List)this.f_140509_.get(oldPriority).remove(chunkPos.m_45588_());
            if (oldPriority == this.firstQueue) {
                this.updateQueueHeight();
            }
            if (tasks != null && !tasks.isEmpty()) {
                ((List)this.f_140509_.get(newPriority).computeIfAbsent(chunkPos.m_45588_(), T -> Lists.newArrayList())).addAll(tasks);
                this.firstQueue = Math.min(this.firstQueue, newPriority);
            }
            this.updateHeight(chunkPos.m_45588_());
        }
    }

    public void updateHeight(long pos) {
        for (int i = this.firstQueue; i < ChunkTaskPriorityQueue.f_140508_; ++i) {
            if (!this.f_140509_.get(i).containsKey(pos)) continue;
            this.heightMap.put(pos, i);
            return;
        }
        this.heightMap.remove(pos);
    }

    protected void m_140535_(Optional<T> task, long chunkPos, int priority) {
        ((List)this.f_140509_.get(priority).computeIfAbsent(chunkPos, T -> Lists.newArrayList())).add(task);
        this.firstQueue = Math.min(this.firstQueue, priority);
        this.updateHeight(chunkPos);
    }

    protected void m_140530_(long chunkPos, boolean clear) {
        for (Long2ObjectMap<List<Optional<T>>> chunk2TaskMap : this.f_140509_) {
            List tasks = (List)chunk2TaskMap.get(chunkPos);
            if (tasks == null) continue;
            if (clear) {
                tasks.clear();
            } else {
                tasks.removeIf(this::isEmpty);
            }
            if (!tasks.isEmpty()) continue;
            chunk2TaskMap.remove(chunkPos);
        }
        this.updateQueueHeight();
        this.f_140512_.remove(chunkPos);
        this.updateHeight(chunkPos);
    }

    private Runnable acquire(long p_219418_1_) {
        return () -> this.f_140512_.add(p_219418_1_);
    }

    @Nullable
    public Stream<Either<T, Runnable>> m_140518_() {
        if (this.f_140512_.size() >= this.f_140513_ || this.firstQueue >= f_140508_) {
            return null;
        }
        int roomLeft = 1024 - this.f_140512_.size();
        ObjectArrayList list = new ObjectArrayList();
        Long2ObjectLinkedOpenHashMap statusMap = new Long2ObjectLinkedOpenHashMap();
        block0: for (int i = this.firstQueue; i < f_140508_ && list.size() < roomLeft; ++i) {
            if (this.f_140509_.get(i).isEmpty()) continue;
            ChunkStatus currentStatus = i < 33 ? ChunkStatus.f_62326_ : ChunkStatus.m_156185_((int)(i - 33));
            ObjectIterator iter = Long2ObjectMaps.fastIterator(this.f_140509_.get(i));
            while (iter.hasNext() && list.size() < roomLeft) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iter.next();
                long chunk = entry.getLongKey();
                if (this.heightMap.get(chunk) < i || !this.canTaskBeExecuted(chunk, currentStatus, (Long2ObjectMap<ChunkStatus>)statusMap)) continue;
                statusMap.put(chunk, (Object)currentStatus);
                for (Optional optional : (List)entry.getValue()) {
                    list.add(optional.map(Either::left).orElseGet(() -> Either.right((Object)this.acquire(chunk))));
                }
                iter.remove();
                this.updateHeight(chunk);
                if (currentStatus != ChunkStatus.f_62322_) continue;
                continue block0;
            }
        }
        this.updateQueueHeight();
        return list.stream();
    }

    protected boolean canTaskBeExecuted(long key, ChunkStatus currentStatus, Long2ObjectMap<ChunkStatus> areaMap) {
        int askX = ChunkPos.m_45592_((long)key);
        int askZ = ChunkPos.m_45602_((long)key);
        int doubleDistance = this.radius.get(currentStatus.m_62445_()) * 2;
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(areaMap)) {
            long chunkPos;
            ChunkStatus other = (ChunkStatus)entry.getValue();
            int distance = other == currentStatus ? doubleDistance : this.radius.get(this.findRadius(other, currentStatus)) + 1;
            if (distance < Math.abs(ChunkPos.m_45592_((long)(chunkPos = entry.getLongKey())) - askX) || distance < Math.abs(ChunkPos.m_45602_((long)chunkPos) - askZ)) continue;
            return false;
        }
        return true;
    }

    protected int findRadius(ChunkStatus left, ChunkStatus right) {
        return left.m_62445_() > right.m_62445_() ? left.m_62445_() << 8 | right.m_62445_() : right.m_62445_() << 8 | left.m_62445_();
    }

    public String toString() {
        return this.f_140511_ + " " + this.firstQueue + "...";
    }
}

