/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.retrogen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.client.helpers.IResourceAcceptor;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.networking.IPregenPacket;

public class RetrogenSyncAnswer
implements IPregenPacket {
    Set<ResourceLocation> active = new ObjectOpenHashSet();
    List<ResourceLocation> allEntries = new ObjectArrayList();

    public RetrogenSyncAnswer() {
    }

    public RetrogenSyncAnswer(Set<ResourceLocation> active, List<ResourceLocation> allEntries) {
        this.active.addAll(active);
        this.allEntries.addAll(allEntries);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.allEntries.size());
        for (ResourceLocation location : this.allEntries) {
            buffer.m_130085_(location);
            buffer.writeBoolean(this.active.contains(location));
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buffer.m_130281_();
            this.allEntries.add(id);
            if (!buffer.readBoolean()) continue;
            this.active.add(id);
        }
    }

    @Override
    public void process(Player player) {
        RetrogenManager.INSTANCE.onSyncPacket(this.active);
        this.processClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processClient() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof IResourceAcceptor) {
            ((IResourceAcceptor)screen).onResourceReceived(this.allEntries);
        }
    }
}

