/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import com.google.common.base.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import pregenerator.common.generator.ChunkLogger;

public class StructureRef {
    ResourceLocation name;
    long pos;
    int components;
    int size;
    int[] bounds;

    public StructureRef(ResourceLocation name, StructureStart start) {
        this.name = name;
        this.pos = start.m_163625_().m_45588_();
        this.components = start.m_73602_().size();
        BoundingBox box = start.m_73601_();
        this.bounds = new int[]{box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_()};
        this.size = this.calculateChunkSize();
    }

    public StructureRef(ResourceLocation name, int[] data) {
        this.name = name;
        this.pos = ChunkPos.m_45589_((int)data[0], (int)data[1]);
        this.components = data[2];
        this.size = data[3];
        this.bounds = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.bounds[i] = data[4 + i];
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureRef) {
            return ((StructureRef)obj).pos == this.pos;
        }
        return false;
    }

    public int[] write() {
        int[] index = new int[10];
        index[0] = ChunkPos.m_45592_((long)this.pos);
        index[1] = ChunkPos.m_45602_((long)this.pos);
        index[2] = this.components;
        index[3] = this.size;
        for (int i = 0; i < 6; ++i) {
            index[4 + i] = this.bounds[i];
        }
        return index;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChunkLogger.toPascalCase(this.name.m_135815_()) + " (" + ChunkLogger.toPascalCase(this.name.m_135827_()) + ")";
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public int getSize() {
        return this.size;
    }

    private int calculateChunkSize() {
        int width = this.bounds[3] - this.bounds[0];
        int depth = this.bounds[5] - this.bounds[2];
        return (int)Math.sqrt(width * width + depth * depth);
    }
}

